/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit.builders;

import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.liferay.tools.doclets.internal.toolkit.MethodWriter;
import com.liferay.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.liferay.tools.doclets.internal.toolkit.util.DocFinder;
import com.liferay.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Type;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MethodBuilder
extends AbstractMemberBuilder {
    private int currentMethodIndex;
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private MethodWriter writer;
    private List methods;

    private MethodBuilder(Configuration configuration) {
        super(configuration);
    }

    public static MethodBuilder getInstance(Configuration configuration, ClassDoc classDoc, MethodWriter writer) {
        MethodBuilder builder = new MethodBuilder(configuration);
        builder.classDoc = classDoc;
        builder.writer = writer;
        builder.visibleMemberMap = new VisibleMemberMap(classDoc, 4, configuration.nodeprecated);
        builder.methods = new ArrayList(builder.visibleMemberMap.getLeafClassMembers(configuration));
        if (configuration.getMemberComparator() != null) {
            Collections.sort(builder.methods, configuration.getMemberComparator());
        }
        return builder;
    }

    public String getName() {
        return "MethodDetails";
    }

    public void invokeMethod(String methodName, Class[] paramClasses, Object[] params) throws Exception {
        Method method = this.getClass().getMethod(methodName, paramClasses);
        method.invoke((Object)this, params);
    }

    public List members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    public boolean hasMembersToDocument() {
        return this.methods.size() > 0;
    }

    public void buildMethodDoc(List elements) {
        if (this.writer == null) {
            return;
        }
        this.currentMethodIndex = 0;
        while (this.currentMethodIndex < this.methods.size()) {
            this.build(elements);
            ++this.currentMethodIndex;
        }
    }

    public void buildHeader() {
        this.writer.writeHeader(this.classDoc, this.configuration.getText("doclet.Method_Detail"));
    }

    public void buildMethodHeader() {
        this.writer.writeMethodHeader((MethodDoc)this.methods.get(this.currentMethodIndex), this.currentMethodIndex == 0);
    }

    public void buildSignature() {
        this.writer.writeSignature((MethodDoc)this.methods.get(this.currentMethodIndex));
    }

    public void buildDeprecationInfo() {
        this.writer.writeDeprecated((MethodDoc)this.methods.get(this.currentMethodIndex));
    }

    public void buildMethodComments() {
        if (!this.configuration.nocomment) {
            MethodDoc method = (MethodDoc)this.methods.get(this.currentMethodIndex);
            if (method.inlineTags().length == 0) {
                DocFinder.Output docs = DocFinder.search(new DocFinder.Input(method));
                method = docs.inlineTags != null && docs.inlineTags.length > 0 ? (MethodDoc)docs.holder : method;
            }
            this.writer.writeComments((Type)method.containingClass(), method);
        }
    }

    public void buildTagInfo() {
        this.writer.writeTags((MethodDoc)this.methods.get(this.currentMethodIndex));
    }

    public void buildMethodFooter() {
        this.writer.writeMethodFooter();
    }

    public void buildFooter() {
        this.writer.writeFooter(this.classDoc);
    }

    public MethodWriter getWriter() {
        return this.writer;
    }
}

