/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit.builders;

import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.liferay.tools.doclets.internal.toolkit.SerializedFormWriter;
import com.liferay.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.liferay.tools.doclets.internal.toolkit.builders.LayoutParser;
import com.liferay.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.Tag;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class SerializedFormBuilder
extends AbstractBuilder {
    public static final String NAME = "SerializedForm";
    private SerializedFormWriter writer;
    private SerializedFormWriter.SerialFieldWriter fieldWriter;
    private SerializedFormWriter.SerialMethodWriter methodWriter;
    private static final String SERIAL_VERSION_UID_HEADER = "serialVersionUID:";
    private PackageDoc currentPackage;
    private ClassDoc currentClass;
    protected MemberDoc currentMember;

    private SerializedFormBuilder(Configuration configuration) {
        super(configuration);
    }

    public static SerializedFormBuilder getInstance(Configuration configuration) {
        SerializedFormBuilder builder = new SerializedFormBuilder(configuration);
        return builder;
    }

    public void build() throws IOException {
        if (!this.serialClassFoundToDocument(this.configuration.root.classes())) {
            return;
        }
        try {
            this.writer = this.configuration.getWriterFactory().getSerializedFormWriter();
            if (this.writer == null) {
                return;
            }
        }
        catch (Exception e) {
            throw new DocletAbortException();
        }
        this.build(LayoutParser.getInstance(this.configuration).parseXML(NAME));
        this.writer.close();
    }

    public String getName() {
        return NAME;
    }

    public void buildSerializedForm(List elements) throws Exception {
        this.build(elements);
        this.writer.close();
    }

    public void invokeMethod(String methodName, Class[] paramClasses, Object[] params) throws Exception {
        Method method = this.getClass().getMethod(methodName, paramClasses);
        method.invoke((Object)this, params);
    }

    public void buildHeader() {
        this.writer.writeHeader(this.configuration.getText("doclet.Serialized_Form"));
    }

    public void buildSerializedFormSummaries(List elements) {
        PackageDoc[] packages = this.configuration.packages;
        for (int i = 0; i < packages.length; ++i) {
            this.currentPackage = packages[i];
            this.build(elements);
        }
    }

    public void buildPackageSerializedForm(List elements) {
        String foo = this.currentPackage.name();
        ClassDoc[] classes = this.currentPackage.allClasses(false);
        if (classes == null || classes.length == 0) {
            return;
        }
        if (!SerializedFormBuilder.serialInclude((Doc)this.currentPackage)) {
            return;
        }
        if (!this.serialClassFoundToDocument(classes)) {
            return;
        }
        this.build(elements);
    }

    public void buildPackageHeader() {
        this.writer.writePackageHeader(Util.getPackageName(this.currentPackage));
    }

    public void buildClassSerializedForm(List elements) {
        Object[] classes = this.currentPackage.allClasses(false);
        Arrays.sort(classes);
        for (int j = 0; j < classes.length; ++j) {
            this.currentClass = classes[j];
            this.fieldWriter = this.writer.getSerialFieldWriter(this.currentClass);
            this.methodWriter = this.writer.getSerialMethodWriter(this.currentClass);
            if (!this.currentClass.isClass() || !this.currentClass.isSerializable() || !SerializedFormBuilder.serialClassInclude(this.currentClass)) continue;
            this.build(elements);
        }
    }

    public void buildClassHeader() {
        this.writer.writeClassHeader(this.currentClass);
    }

    public void buildSerialUIDInfo() {
        FieldDoc[] fields = this.currentClass.fields(false);
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].name().equals("serialVersionUID") || fields[i].constantValueExpression() == null) continue;
            this.writer.writeSerialUIDInfo(SERIAL_VERSION_UID_HEADER, fields[i].constantValueExpression());
            return;
        }
    }

    public void buildFooter() {
        this.writer.writeFooter();
    }

    public static boolean serialInclude(Doc doc) {
        if (doc == null) {
            return false;
        }
        return doc.isClass() ? SerializedFormBuilder.serialClassInclude((ClassDoc)doc) : SerializedFormBuilder.serialDocInclude(doc);
    }

    private static boolean serialClassInclude(ClassDoc cd) {
        if (cd.isEnum()) {
            return false;
        }
        try {
            cd.superclassType();
        }
        catch (NullPointerException e) {
            return false;
        }
        if (cd.isSerializable()) {
            if (cd.tags("serial").length > 0) {
                return SerializedFormBuilder.serialDocInclude((Doc)cd);
            }
            return cd.isPublic() || cd.isProtected();
        }
        return false;
    }

    private static boolean serialDocInclude(Doc doc) {
        if (doc.isEnum()) {
            return false;
        }
        Tag[] serial = doc.tags("serial");
        if (serial.length > 0) {
            String serialtext = serial[0].text().toLowerCase();
            if (serialtext.indexOf("exclude") >= 0) {
                return false;
            }
            if (serialtext.indexOf("include") >= 0) {
                return true;
            }
        }
        return true;
    }

    private boolean serialClassFoundToDocument(ClassDoc[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (!SerializedFormBuilder.serialClassInclude(classes[i])) continue;
            return true;
        }
        return false;
    }

    public void buildMethodHeader() {
        if (this.currentClass.serializationMethods().length > 0) {
            this.methodWriter.writeHeader(this.configuration.getText("doclet.Serialized_Form_methods"));
            if (this.currentClass.isSerializable() && !this.currentClass.isExternalizable() && this.currentClass.serializationMethods().length == 0) {
                this.methodWriter.writeNoCustomizationMsg(this.configuration.getText("doclet.Serializable_no_customization"));
            }
        }
    }

    public void buildMethodSubHeader() {
        this.methodWriter.writeMemberHeader((MethodDoc)this.currentMember);
    }

    public void buildDeprecatedMethodInfo() {
        this.methodWriter.writeDeprecatedMemberInfo((MethodDoc)this.currentMember);
    }

    public void buildMethodDescription() {
        this.methodWriter.writeMemberDescription((MethodDoc)this.currentMember);
    }

    public void buildMethodTags() {
        this.methodWriter.writeMemberTags((MethodDoc)this.currentMember);
        MethodDoc method = (MethodDoc)this.currentMember;
        if (method.name().compareTo("writeExternal") == 0 && method.tags("serialData").length == 0 && this.configuration.serialwarn) {
            this.configuration.getDocletSpecificMsg().warning(this.currentMember.position(), "doclet.MissingSerialDataTag", method.containingClass().qualifiedName(), method.name());
        }
    }

    public void buildMethodInfo(List elements) {
        if (this.configuration.nocomment) {
            return;
        }
        this.build(elements);
    }

    public void buildMethodFooter() {
        this.methodWriter.writeMemberFooter((MethodDoc)this.currentMember);
    }

    public void buildFieldHeader() {
        if (this.currentClass.serializableFields().length > 0) {
            this.buildFieldSerializationOverview(this.currentClass);
            this.fieldWriter.writeHeader(this.configuration.getText("doclet.Serialized_Form_fields"));
        }
    }

    public void buildFieldSerializationOverview(ClassDoc classDoc) {
        FieldDoc serialPersistentField;
        String comment;
        if (classDoc.definesSerializableFields() && (comment = (serialPersistentField = (FieldDoc)Util.asList((ProgramElementDoc[])classDoc.serializableFields()).get(0)).commentText()).length() > 0) {
            this.fieldWriter.writeHeader(this.configuration.getText("doclet.Serialized_Form_class"));
            if (!this.configuration.nocomment) {
                this.fieldWriter.writeMemberDeprecatedInfo(serialPersistentField);
                this.fieldWriter.writeMemberDescription(serialPersistentField);
                this.fieldWriter.writeMemberTags(serialPersistentField);
                this.fieldWriter.writeMemberFooter(serialPersistentField);
            }
        }
    }

    public void buildFieldSubHeader() {
        if (!this.currentClass.definesSerializableFields()) {
            FieldDoc field = (FieldDoc)this.currentMember;
            this.fieldWriter.writeMemberHeader(field.type().asClassDoc(), field.type().typeName(), field.type().dimension(), field.name());
        }
    }

    public void buildFieldInfo() {
        if (this.configuration.nocomment) {
            return;
        }
        FieldDoc field = (FieldDoc)this.currentMember;
        ClassDoc cd = field.containingClass();
        if (cd.definesSerializableFields()) {
            Object[] tags = field.serialFieldTags();
            Arrays.sort(tags);
            for (int i = 0; i < tags.length; ++i) {
                this.fieldWriter.writeMemberHeader(tags[i].fieldTypeDoc(), tags[i].fieldType(), "", tags[i].fieldName());
                this.fieldWriter.writeMemberDescription((SerialFieldTag)tags[i]);
            }
        } else {
            if (field.tags("serial").length == 0 && !field.isSynthetic() && this.configuration.serialwarn) {
                this.configuration.message.warning(field.position(), "doclet.MissingSerialTag", cd.qualifiedName(), field.name());
            }
            this.fieldWriter.writeMemberDeprecatedInfo(field);
            this.fieldWriter.writeMemberDescription(field);
            this.fieldWriter.writeMemberTags(field);
        }
    }

    public void buildFieldFooter() {
        if (!this.currentClass.definesSerializableFields()) {
            this.fieldWriter.writeMemberFooter((FieldDoc)this.currentMember);
        }
    }

    public void buildSerializableMethods(List elements) {
        MethodDoc[] members = this.currentClass.serializationMethods();
        if (members.length > 0) {
            for (int i = 0; i < members.length; ++i) {
                this.currentMember = members[i];
                this.build(elements);
            }
        }
    }

    public void buildSerializableFields(List elements) {
        FieldDoc[] members = this.currentClass.serializableFields();
        if (members.length > 0) {
            for (int i = 0; i < members.length; ++i) {
                this.currentMember = members[i];
                this.build(elements);
            }
        }
    }
}

