/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit.taglets;

import com.liferay.tools.doclets.internal.toolkit.taglets.CodeTaglet;
import com.liferay.tools.doclets.internal.toolkit.taglets.DocRootTaglet;
import com.liferay.tools.doclets.internal.toolkit.taglets.InheritDocTaglet;
import com.liferay.tools.doclets.internal.toolkit.taglets.LegacyTaglet;
import com.liferay.tools.doclets.internal.toolkit.taglets.LiteralTaglet;
import com.liferay.tools.doclets.internal.toolkit.taglets.ParamTaglet;
import com.liferay.tools.doclets.internal.toolkit.taglets.ReturnTaglet;
import com.liferay.tools.doclets.internal.toolkit.taglets.SeeTaglet;
import com.liferay.tools.doclets.internal.toolkit.taglets.SimpleTaglet;
import com.liferay.tools.doclets.internal.toolkit.taglets.Taglet;
import com.liferay.tools.doclets.internal.toolkit.taglets.ThrowsTaglet;
import com.liferay.tools.doclets.internal.toolkit.taglets.ValueTaglet;
import com.liferay.tools.doclets.internal.toolkit.util.MessageRetriever;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class TagletManager {
    public static final char SIMPLE_TAGLET_OPT_SEPERATOR = ':';
    public static final String ALT_SIMPLE_TAGLET_OPT_SEPERATOR = "-";
    private LinkedHashMap customTags;
    private Taglet[] packageTags;
    private Taglet[] typeTags;
    private Taglet[] fieldTags;
    private Taglet[] constructorTags;
    private Taglet[] methodTags;
    private Taglet[] overviewTags;
    private Taglet[] inlineTags;
    private Taglet[] serializedFormTags;
    private MessageRetriever message;
    private Set standardTags;
    private Set standardTagsLowercase;
    private Set overridenStandardTags = new HashSet();
    private Set potentiallyConflictingTags = new HashSet();
    private Set unseenCustomTags;
    private boolean nosince;
    private boolean showversion;
    private boolean showauthor;

    public TagletManager(boolean nosince, boolean showversion, boolean showauthor, MessageRetriever message) {
        this.standardTags = new HashSet();
        this.standardTagsLowercase = new HashSet();
        this.unseenCustomTags = new HashSet();
        this.customTags = new LinkedHashMap();
        this.nosince = nosince;
        this.showversion = showversion;
        this.showauthor = showauthor;
        this.message = message;
        this.initStandardTags();
        this.initStandardTagsLowercase();
    }

    public void addCustomTag(Taglet customTag) {
        if (customTag != null) {
            String name = customTag.getName();
            if (this.customTags.containsKey(name)) {
                this.customTags.remove(name);
            }
            this.customTags.put(name, customTag);
            this.checkTagName(name);
        }
    }

    public void addCustomTag(String classname, String tagletPath) {
        try {
            Object newLastTag;
            Class<?> customTagClass = null;
            String cpString = null;
            cpString = this.appendPath(System.getProperty("env.class.path"), cpString);
            cpString = this.appendPath(System.getProperty("java.class.path"), cpString);
            cpString = this.appendPath(tagletPath, cpString);
            URLClassLoader appClassLoader = new URLClassLoader(TagletManager.pathToURLs(cpString));
            customTagClass = appClassLoader.loadClass(classname);
            Method meth = customTagClass.getMethod("register", Class.forName("java.util.Map"));
            Object[] list = this.customTags.values().toArray();
            Taglet lastTag = list != null && list.length > 0 ? (Taglet)list[list.length - 1] : null;
            meth.invoke(null, this.customTags);
            list = this.customTags.values().toArray();
            Object object = newLastTag = list != null && list.length > 0 ? list[list.length - 1] : null;
            if (lastTag != newLastTag) {
                this.message.notice("doclet.Notice_taglet_registered", classname);
                if (newLastTag != null) {
                    this.checkTaglet(newLastTag);
                }
            }
        }
        catch (Exception exc) {
            this.message.error("doclet.Error_taglet_not_registered", exc.getClass().getName(), classname);
        }
    }

    private String appendPath(String path1, String path2) {
        if (path1 == null || path1.length() == 0) {
            return path2 == null ? "." : path2;
        }
        if (path2 == null || path2.length() == 0) {
            return path1;
        }
        return path1 + File.pathSeparator + path2;
    }

    private static URL[] pathToURLs(String path) {
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            URL url = TagletManager.fileToURL(new File(st.nextToken()));
            if (url == null) continue;
            urls[count++] = url;
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    private static URL fileToURL(File file) {
        String name;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            name = file.getAbsolutePath();
        }
        name = name.replace(File.separatorChar, '/');
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (!file.isFile()) {
            name = name + "/";
        }
        try {
            return new URL("file", "", name);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("file");
        }
    }

    public void addNewSimpleCustomTag(String tagName, String header, String locations) {
        if (tagName == null || locations == null) {
            return;
        }
        Taglet tag = (Taglet)this.customTags.get(tagName);
        locations = locations.toLowerCase();
        if (tag == null || header != null) {
            this.customTags.remove(tagName);
            this.customTags.put(tagName, new SimpleTaglet(tagName, header, locations));
            if (locations != null && locations.indexOf(120) == -1) {
                this.checkTagName(tagName);
            }
        } else {
            this.customTags.remove(tagName);
            this.customTags.put(tagName, tag);
        }
    }

    private void checkTagName(String name) {
        if (this.standardTags.contains(name)) {
            this.overridenStandardTags.add(name);
        } else {
            if (name.indexOf(46) == -1) {
                this.potentiallyConflictingTags.add(name);
            }
            this.unseenCustomTags.add(name);
        }
    }

    private void checkTaglet(Object taglet) {
        if (taglet instanceof Taglet) {
            this.checkTagName(((Taglet)taglet).getName());
        } else if (taglet instanceof com.liferay.tools.doclets.Taglet) {
            com.liferay.tools.doclets.Taglet legacyTaglet = (com.liferay.tools.doclets.Taglet)taglet;
            this.customTags.remove(legacyTaglet.getName());
            this.customTags.put(legacyTaglet.getName(), new LegacyTaglet(legacyTaglet));
            this.checkTagName(legacyTaglet.getName());
        } else {
            throw new IllegalArgumentException("Given object is not a taglet.");
        }
    }

    public void seenCustomTag(String name) {
        this.unseenCustomTags.remove(name);
    }

    public void checkTags(Doc doc, Tag[] tags, boolean areInlineTags) {
        if (tags == null) {
            return;
        }
        for (int i = 0; i < tags.length; ++i) {
            String name = tags[i].name();
            if (name.length() > 0 && name.charAt(0) == '@') {
                name = name.substring(1, name.length());
            }
            if (!this.standardTags.contains(name) && !this.customTags.containsKey(name)) {
                if (this.standardTagsLowercase.contains(name.toLowerCase())) {
                    this.message.warning(tags[i].position(), "doclet.UnknownTagLowercase", tags[i].name());
                    continue;
                }
                this.message.warning(tags[i].position(), "doclet.UnknownTag", tags[i].name());
                continue;
            }
            Taglet taglet = (Taglet)this.customTags.get(name);
            if (taglet == null) continue;
            if (areInlineTags && !taglet.isInlineTag()) {
                this.printTagMisuseWarn(taglet, tags[i], "inline");
            }
            if (doc instanceof RootDoc && !taglet.inOverview()) {
                this.printTagMisuseWarn(taglet, tags[i], "overview");
                continue;
            }
            if (doc instanceof PackageDoc && !taglet.inPackage()) {
                this.printTagMisuseWarn(taglet, tags[i], "package");
                continue;
            }
            if (doc instanceof ClassDoc && !taglet.inType()) {
                this.printTagMisuseWarn(taglet, tags[i], "class");
                continue;
            }
            if (doc instanceof ConstructorDoc && !taglet.inConstructor()) {
                this.printTagMisuseWarn(taglet, tags[i], "constructor");
                continue;
            }
            if (doc instanceof FieldDoc && !taglet.inField()) {
                this.printTagMisuseWarn(taglet, tags[i], "field");
                continue;
            }
            if (!(doc instanceof MethodDoc) || taglet.inMethod()) continue;
            this.printTagMisuseWarn(taglet, tags[i], "method");
        }
    }

    private void printTagMisuseWarn(Taglet taglet, Tag tag, String holderType) {
        String[] locations;
        LinkedHashSet<String> locationsSet = new LinkedHashSet<String>();
        if (taglet.inOverview()) {
            locationsSet.add("overview");
        }
        if (taglet.inPackage()) {
            locationsSet.add("package");
        }
        if (taglet.inType()) {
            locationsSet.add("class/interface");
        }
        if (taglet.inConstructor()) {
            locationsSet.add("constructor");
        }
        if (taglet.inField()) {
            locationsSet.add("field");
        }
        if (taglet.inMethod()) {
            locationsSet.add("method");
        }
        if (taglet.isInlineTag()) {
            locationsSet.add("inline text");
        }
        if ((locations = locationsSet.toArray(new String[0])) == null || locations.length == 0) {
            return;
        }
        StringBuffer combined_locations = new StringBuffer();
        for (int i = 0; i < locations.length; ++i) {
            if (i > 0) {
                combined_locations.append(", ");
            }
            combined_locations.append(locations[i]);
        }
        this.message.warning(tag.position(), "doclet.tag_misuse", "@" + taglet.getName(), holderType, combined_locations.toString());
    }

    public Taglet[] getPackageCustomTags() {
        if (this.packageTags == null) {
            this.initCustomTagArrays();
        }
        return this.packageTags;
    }

    public Taglet[] getTypeCustomTags() {
        if (this.typeTags == null) {
            this.initCustomTagArrays();
        }
        return this.typeTags;
    }

    public Taglet[] getInlineCustomTags() {
        if (this.inlineTags == null) {
            this.initCustomTagArrays();
        }
        return this.inlineTags;
    }

    public Taglet[] getFieldCustomTags() {
        if (this.fieldTags == null) {
            this.initCustomTagArrays();
        }
        return this.fieldTags;
    }

    public Taglet[] getSerializedFormTags() {
        if (this.serializedFormTags == null) {
            this.initCustomTagArrays();
        }
        return this.serializedFormTags;
    }

    public Taglet[] getCustomTags(Doc doc) {
        if (doc instanceof ConstructorDoc) {
            return this.getConstructorCustomTags();
        }
        if (doc instanceof MethodDoc) {
            return this.getMethodCustomTags();
        }
        if (doc instanceof FieldDoc) {
            return this.getFieldCustomTags();
        }
        if (doc instanceof ClassDoc) {
            return this.getTypeCustomTags();
        }
        if (doc instanceof PackageDoc) {
            return this.getPackageCustomTags();
        }
        if (doc instanceof RootDoc) {
            return this.getOverviewCustomTags();
        }
        return null;
    }

    public Taglet[] getConstructorCustomTags() {
        if (this.constructorTags == null) {
            this.initCustomTagArrays();
        }
        return this.constructorTags;
    }

    public Taglet[] getMethodCustomTags() {
        if (this.methodTags == null) {
            this.initCustomTagArrays();
        }
        return this.methodTags;
    }

    public Taglet[] getOverviewCustomTags() {
        if (this.overviewTags == null) {
            this.initCustomTagArrays();
        }
        return this.overviewTags;
    }

    private void initCustomTagArrays() {
        Iterator it = this.customTags.values().iterator();
        ArrayList<Taglet> pTags = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> tTags = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> fTags = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> cTags = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> mTags = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> iTags = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> oTags = new ArrayList<Taglet>(this.customTags.size());
        while (it.hasNext()) {
            Taglet current = (Taglet)it.next();
            if (current.inPackage() && !current.isInlineTag()) {
                pTags.add(current);
            }
            if (current.inType() && !current.isInlineTag()) {
                tTags.add(current);
            }
            if (current.inField() && !current.isInlineTag()) {
                fTags.add(current);
            }
            if (current.inConstructor() && !current.isInlineTag()) {
                cTags.add(current);
            }
            if (current.inMethod() && !current.isInlineTag()) {
                mTags.add(current);
            }
            if (current.isInlineTag()) {
                iTags.add(current);
            }
            if (!current.inOverview() || current.isInlineTag()) continue;
            oTags.add(current);
        }
        this.packageTags = pTags.toArray(new Taglet[0]);
        this.typeTags = tTags.toArray(new Taglet[0]);
        this.fieldTags = fTags.toArray(new Taglet[0]);
        this.constructorTags = cTags.toArray(new Taglet[0]);
        this.methodTags = mTags.toArray(new Taglet[0]);
        this.overviewTags = oTags.toArray(new Taglet[0]);
        this.inlineTags = iTags.toArray(new Taglet[0]);
        this.serializedFormTags = new Taglet[4];
        this.serializedFormTags[0] = (Taglet)this.customTags.get("serialData");
        this.serializedFormTags[1] = (Taglet)this.customTags.get("throws");
        this.serializedFormTags[2] = (Taglet)this.customTags.get("since");
        this.serializedFormTags[3] = (Taglet)this.customTags.get("see");
    }

    private void initStandardTags() {
        Taglet temp = new ParamTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new ReturnTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new ThrowsTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new SimpleTaglet("exception", null, "mc");
        this.customTags.put(temp.getName(), temp);
        if (!this.nosince) {
            temp = new SimpleTaglet("since", this.message.getText("doclet.Since"), "a");
            this.customTags.put(temp.getName(), temp);
        }
        if (this.showversion) {
            temp = new SimpleTaglet("version", this.message.getText("doclet.Version"), "pto");
            this.customTags.put(temp.getName(), temp);
        }
        if (this.showauthor) {
            temp = new SimpleTaglet("author", this.message.getText("doclet.Author"), "pto");
            this.customTags.put(temp.getName(), temp);
        }
        temp = new SimpleTaglet("serialData", this.message.getText("doclet.SerialData"), "x");
        this.customTags.put(temp.getName(), temp);
        temp = new SimpleTaglet("factory", this.message.getText("doclet.Factory"), "m");
        this.customTags.put(temp.getName(), temp);
        temp = new SeeTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new DocRootTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new InheritDocTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new ValueTaglet();
        this.customTags.put(temp.getName(), temp);
        temp = new LegacyTaglet(new LiteralTaglet());
        this.customTags.put(temp.getName(), temp);
        temp = new LegacyTaglet(new CodeTaglet());
        this.customTags.put(temp.getName(), temp);
        this.standardTags.add("param");
        this.standardTags.add("return");
        this.standardTags.add("throws");
        this.standardTags.add("exception");
        this.standardTags.add("since");
        this.standardTags.add("version");
        this.standardTags.add("author");
        this.standardTags.add("see");
        this.standardTags.add("deprecated");
        this.standardTags.add("link");
        this.standardTags.add("linkplain");
        this.standardTags.add("inheritDoc");
        this.standardTags.add("docRoot");
        this.standardTags.add("value");
        this.standardTags.add("serial");
        this.standardTags.add("serialData");
        this.standardTags.add("serialField");
        this.standardTags.add("Text");
        this.standardTags.add("literal");
        this.standardTags.add("code");
    }

    private void initStandardTagsLowercase() {
        Iterator it = this.standardTags.iterator();
        while (it.hasNext()) {
            this.standardTagsLowercase.add(((String)it.next()).toLowerCase());
        }
    }

    public boolean isKnownCustomTag(String tagName) {
        return this.customTags.containsKey(tagName);
    }

    public void printReport() {
        this.printReportHelper("doclet.Notice_taglet_conflict_warn", this.potentiallyConflictingTags);
        this.printReportHelper("doclet.Notice_taglet_overriden", this.overridenStandardTags);
        this.printReportHelper("doclet.Notice_taglet_unseen", this.unseenCustomTags);
    }

    private void printReportHelper(String noticeKey, Set names) {
        if (names.size() > 0) {
            String[] namesArray = names.toArray(new String[0]);
            String result = " ";
            for (int i = 0; i < namesArray.length; ++i) {
                result = result + "@" + namesArray[i];
                if (i + 1 >= namesArray.length) continue;
                result = result + ", ";
            }
            this.message.notice(noticeKey, result);
        }
    }

    public Taglet getTaglet(String name) {
        if (name.indexOf("@") == 0) {
            return (Taglet)this.customTags.get(name.substring(1));
        }
        return (Taglet)this.customTags.get(name);
    }
}

