/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit.util;

import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ClassTree {
    private List baseclasses = new ArrayList();
    private Map subclasses = new HashMap();
    private List baseinterfaces = new ArrayList();
    private Map subinterfaces = new HashMap();
    private List baseEnums = new ArrayList();
    private Map subEnums = new HashMap();
    private List baseAnnotationTypes = new ArrayList();
    private Map subAnnotationTypes = new HashMap();
    private Map implementingclasses = new HashMap();

    public ClassTree(Configuration configuration, boolean noDeprecated) {
        configuration.message.notice("doclet.Building_Tree");
        this.buildTree(configuration.root.classes(), configuration);
    }

    public ClassTree(RootDoc root, Configuration configuration) {
        this.buildTree(root.classes(), configuration);
    }

    public ClassTree(ClassDoc[] classes, Configuration configuration) {
        this.buildTree(classes, configuration);
    }

    private void buildTree(ClassDoc[] classes, Configuration configuration) {
        for (int i = 0; i < classes.length; ++i) {
            if (configuration.nodeprecated && classes[i].tags("deprecated").length > 0) continue;
            if (classes[i].isEnum()) {
                this.processType(classes[i], configuration, this.baseEnums, this.subEnums);
                continue;
            }
            if (classes[i].isClass()) {
                this.processType(classes[i], configuration, this.baseclasses, this.subclasses);
                continue;
            }
            if (classes[i].isInterface()) {
                this.processInterface(classes[i]);
                List list = (List)this.implementingclasses.get(classes[i]);
                if (list == null) continue;
                Collections.sort(list);
                continue;
            }
            if (!classes[i].isAnnotationType()) continue;
            this.processType(classes[i], configuration, this.baseAnnotationTypes, this.subAnnotationTypes);
        }
        Collections.sort(this.baseinterfaces);
        Iterator it = this.subinterfaces.values().iterator();
        while (it.hasNext()) {
            Collections.sort((List)it.next());
        }
        it = this.subclasses.values().iterator();
        while (it.hasNext()) {
            Collections.sort((List)it.next());
        }
    }

    private void processType(ClassDoc cd, Configuration configuration, List bases, Map subs) {
        ClassDoc superclass = Util.getFirstVisibleSuperClassCD(cd, configuration);
        if (superclass != null) {
            if (!this.add(subs, superclass, cd)) {
                return;
            }
            this.processType(superclass, configuration, bases, subs);
        } else if (!bases.contains(cd)) {
            bases.add(cd);
        }
        List intfacs = Util.getAllInterfaces((Type)cd, configuration);
        Iterator iter = intfacs.iterator();
        while (iter.hasNext()) {
            this.add(this.implementingclasses, ((Type)iter.next()).asClassDoc(), cd);
        }
    }

    private void processInterface(ClassDoc cd) {
        ClassDoc[] intfacs = cd.interfaces();
        if (intfacs.length > 0) {
            for (int i = 0; i < intfacs.length; ++i) {
                if (!this.add(this.subinterfaces, intfacs[i], cd)) {
                    return;
                }
                this.processInterface(intfacs[i]);
            }
        } else if (!this.baseinterfaces.contains(cd)) {
            this.baseinterfaces.add(cd);
        }
    }

    private boolean add(Map map, ClassDoc superclass, ClassDoc cd) {
        ArrayList<ClassDoc> list = (ArrayList<ClassDoc>)map.get(superclass);
        if (list == null) {
            list = new ArrayList<ClassDoc>();
            map.put(superclass, list);
        }
        if (list.contains(cd)) {
            return false;
        }
        list.add(cd);
        return true;
    }

    private List get(Map map, ClassDoc cd) {
        List list = (List)map.get(cd);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public List subclasses(ClassDoc cd) {
        return this.get(this.subclasses, cd);
    }

    public List subinterfaces(ClassDoc cd) {
        return this.get(this.subinterfaces, cd);
    }

    public List implementingclasses(ClassDoc cd) {
        List result = this.get(this.implementingclasses, cd);
        List subinterfaces = this.allSubs(cd, false);
        ListIterator subInterfacesIter = subinterfaces.listIterator();
        while (subInterfacesIter.hasNext()) {
            ListIterator implementingClassesIter = this.implementingclasses((ClassDoc)subInterfacesIter.next()).listIterator();
            while (implementingClassesIter.hasNext()) {
                ClassDoc c = (ClassDoc)implementingClassesIter.next();
                if (result.contains(c)) continue;
                result.add(c);
            }
        }
        Collections.sort(result);
        return result;
    }

    public List subs(ClassDoc cd, boolean isEnum) {
        if (isEnum) {
            return this.get(this.subEnums, cd);
        }
        if (cd.isAnnotationType()) {
            return this.get(this.subAnnotationTypes, cd);
        }
        if (cd.isInterface()) {
            return this.get(this.subinterfaces, cd);
        }
        if (cd.isClass()) {
            return this.get(this.subclasses, cd);
        }
        return null;
    }

    public List allSubs(ClassDoc cd, boolean isEnum) {
        List list = this.subs(cd, isEnum);
        for (int i = 0; i < list.size(); ++i) {
            cd = (ClassDoc)list.get(i);
            List tlist = this.subs(cd, isEnum);
            for (int j = 0; j < tlist.size(); ++j) {
                ClassDoc tcd = (ClassDoc)tlist.get(j);
                if (list.contains(tcd)) continue;
                list.add(tcd);
            }
        }
        Collections.sort(list);
        return list;
    }

    public List baseclasses() {
        return this.baseclasses;
    }

    public List baseinterfaces() {
        return this.baseinterfaces;
    }

    public List baseEnums() {
        return this.baseEnums;
    }

    public List baseAnnotationTypes() {
        return this.baseAnnotationTypes;
    }
}

