/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit.util;

import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.sun.javadoc.PackageDoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Group {
    private static Group instance;
    private Map regExpGroupMap = new HashMap();
    private List sortedRegExpList = new ArrayList();
    private List groupList = new ArrayList();
    private Map pkgNameGroupMap = new HashMap();
    private final Configuration configuration;

    private Group(Configuration configuration) {
        this.configuration = configuration;
    }

    public static Group getInstance(Configuration configuration) {
        if (instance == null) {
            instance = new Group(configuration);
        }
        return instance;
    }

    public boolean checkPackageGroups(String groupname, String pkgNameFormList) {
        StringTokenizer strtok = new StringTokenizer(pkgNameFormList, ":");
        if (this.groupList.contains(groupname)) {
            this.configuration.message.warning("doclet.Groupname_already_used", groupname);
            return false;
        }
        this.groupList.add(groupname);
        while (strtok.hasMoreTokens()) {
            String id = strtok.nextToken();
            if (id.length() == 0) {
                this.configuration.message.warning("doclet.Error_in_packagelist", groupname, pkgNameFormList);
                return false;
            }
            if (id.endsWith("*")) {
                if (this.foundGroupFormat(this.regExpGroupMap, id = id.substring(0, id.length() - 1))) {
                    return false;
                }
                this.regExpGroupMap.put(id, groupname);
                this.sortedRegExpList.add(id);
                continue;
            }
            if (this.foundGroupFormat(this.pkgNameGroupMap, id)) {
                return false;
            }
            this.pkgNameGroupMap.put(id, groupname);
        }
        Collections.sort(this.sortedRegExpList, new MapKeyComparator());
        return true;
    }

    boolean foundGroupFormat(Map map, String pkgFormat) {
        if (map.containsKey(pkgFormat)) {
            this.configuration.message.error("doclet.Same_package_name_used", pkgFormat);
            return true;
        }
        return false;
    }

    public Map groupPackages(PackageDoc[] packages) {
        String defaultGroupName;
        HashMap groupPackageMap = new HashMap();
        String string = defaultGroupName = this.pkgNameGroupMap.isEmpty() && this.regExpGroupMap.isEmpty() ? this.configuration.message.getText("doclet.Packages") : this.configuration.message.getText("doclet.Other_Packages");
        if (!this.groupList.contains(defaultGroupName)) {
            this.groupList.add(defaultGroupName);
        }
        for (int i = 0; i < packages.length; ++i) {
            PackageDoc pkg = packages[i];
            String pkgName = pkg.name();
            String groupName = (String)this.pkgNameGroupMap.get(pkgName);
            if (groupName == null) {
                groupName = this.regExpGroupName(pkgName);
            }
            if (groupName == null) {
                groupName = defaultGroupName;
            }
            this.getPkgList(groupPackageMap, groupName).add(pkg);
        }
        return groupPackageMap;
    }

    String regExpGroupName(String pkgName) {
        for (int j = 0; j < this.sortedRegExpList.size(); ++j) {
            String regexp = (String)this.sortedRegExpList.get(j);
            if (!pkgName.startsWith(regexp)) continue;
            return (String)this.regExpGroupMap.get(regexp);
        }
        return null;
    }

    List getPkgList(Map map, String groupname) {
        ArrayList list = (ArrayList)map.get(groupname);
        if (list == null) {
            list = new ArrayList();
            map.put(groupname, list);
        }
        return list;
    }

    public List getGroupList() {
        return this.groupList;
    }

    private static class MapKeyComparator
    implements Comparator {
        private MapKeyComparator() {
        }

        public int compare(Object key1, Object key2) {
            return ((String)key2).length() - ((String)key1).length();
        }
    }
}

