/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit.util;

import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import java.util.ArrayList;

public class MetaKeywords {
    private static MetaKeywords instance = null;
    private final Configuration configuration;

    private MetaKeywords(Configuration configuration) {
        this.configuration = configuration;
    }

    public static MetaKeywords getInstance(Configuration configuration) {
        if (instance == null) {
            instance = new MetaKeywords(configuration);
        }
        return instance;
    }

    public String[] getMetaKeywords(ClassDoc classdoc) {
        ArrayList results = new ArrayList();
        if (this.configuration.keywords) {
            results.addAll(this.getClassKeyword(classdoc));
            results.addAll(this.getMemberKeywords((MemberDoc[])classdoc.fields()));
            results.addAll(this.getMemberKeywords((MemberDoc[])classdoc.methods()));
        }
        return results.toArray(new String[0]);
    }

    protected ArrayList getClassKeyword(ClassDoc classdoc) {
        String cltypelower = classdoc.isInterface() ? "interface" : "class";
        ArrayList<String> metakeywords = new ArrayList<String>(1);
        metakeywords.add(classdoc.qualifiedName() + " " + cltypelower);
        return metakeywords;
    }

    public String[] getMetaKeywords(PackageDoc packageDoc) {
        if (this.configuration.keywords) {
            String pkgName = Util.getPackageName(packageDoc);
            return new String[]{pkgName + " " + "package"};
        }
        return new String[0];
    }

    public String[] getOverviewMetaKeywords(String title, String docTitle) {
        if (this.configuration.keywords) {
            String windowOverview = this.configuration.getText(title);
            String[] metakeywords = new String[]{windowOverview};
            if (docTitle.length() > 0) {
                metakeywords[0] = metakeywords[0] + ", " + docTitle;
            }
            return metakeywords;
        }
        return new String[0];
    }

    protected ArrayList getMemberKeywords(MemberDoc[] memberdocs) {
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < memberdocs.length; ++i) {
            String membername = memberdocs[i].name() + (memberdocs[i].isMethod() ? "()" : "");
            if (results.contains(membername)) continue;
            results.add(membername);
        }
        return results;
    }
}

