/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit.util;

import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.liferay.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class PackageListWriter
extends PrintWriter {
    private Configuration configuration;

    public PackageListWriter(Configuration configuration) throws IOException {
        super(Util.genWriter(configuration, configuration.destDirName, "package-list", configuration.docencoding));
        this.configuration = configuration;
    }

    public static void generate(Configuration configuration) {
        try {
            PackageListWriter packgen = new PackageListWriter(configuration);
            packgen.generatePackageListFile(configuration.root);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.message.error("doclet.exception_encountered", exc.toString(), "package-list");
            throw new DocletAbortException();
        }
    }

    protected void generatePackageListFile(RootDoc root) {
        int i;
        PackageDoc[] packages = this.configuration.packages;
        Object[] names = new String[packages.length];
        for (i = 0; i < packages.length; ++i) {
            names[i] = packages[i].name();
        }
        Arrays.sort(names);
        for (i = 0; i < packages.length; ++i) {
            this.println((String)names[i]);
        }
    }
}

