/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit.util;

import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.liferay.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.liferay.tools.doclets.internal.toolkit.util.DocletConstants;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SourceToHTMLConverter {
    protected static final String HEADER = "<HTML>\n<head>\n<style>\n.line { color: gray }\n.keyword { color: blue }\n.comment { color: green }\n.comment .keyword { color: green }\n</style>\n</head>\n<BODY>\n<PRE>\n";
    protected static final String KEYWORD_REPLACEMENT = "<span class=\"keyword\">$0</span>";
    protected static final String COMMENT_START_REPLACEMENT = "<span class=\"comment\">$0";
    protected static final String COMMENT_END_REPLACEMENT = "$0</span>";
    protected static final String COMMENT_REPLACEMENT = "<span class=\"comment\">$0</span>";
    protected static final Pattern KEYWORD_PATTERN = Pattern.compile("\\b(abstract|continue|for|new|switch|assert|default|if|package|synchronized|boolean|do|goto|private|this|break|double|implements|protected|throw|byte|else|import|public|throws|case|enum|instanceof|return|transient|catch|extends|int|short|try|char|final|interface|static|void|class|finally|long|strictfp|volatile|const|float|native|super|while)\\b");
    protected static final Pattern COMMENT_START_PATTERN = Pattern.compile("/\\*");
    protected static final Pattern COMMENT_END_PATTERN = Pattern.compile("\\*/");
    protected static final Pattern COMMENT_PATTERN = Pattern.compile("//.*");
    protected static final int NUM_BLANK_LINES = 60;

    private SourceToHTMLConverter() {
    }

    public static void convertRoot(Configuration configuration, RootDoc rd, String outputdir) {
        if (rd == null || outputdir == null) {
            return;
        }
        PackageDoc[] pds = rd.specifiedPackages();
        for (int i = 0; i < pds.length; ++i) {
            SourceToHTMLConverter.convertPackage(configuration, pds[i], outputdir);
        }
        ClassDoc[] cds = rd.specifiedClasses();
        for (int i = 0; i < cds.length; ++i) {
            SourceToHTMLConverter.convertClass(configuration, cds[i], SourceToHTMLConverter.getPackageOutputDir(outputdir, cds[i].containingPackage()));
        }
    }

    public static void convertPackage(Configuration configuration, PackageDoc pd, String outputdir) {
        if (pd == null || outputdir == null) {
            return;
        }
        String classOutputdir = SourceToHTMLConverter.getPackageOutputDir(outputdir, pd);
        ClassDoc[] cds = pd.allClasses();
        for (int i = 0; i < cds.length; ++i) {
            SourceToHTMLConverter.convertClass(configuration, cds[i], classOutputdir);
        }
    }

    private static String getPackageOutputDir(String outputDir, PackageDoc pd) {
        return outputDir + File.separator + DirectoryManager.getDirectoryPath(pd) + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertClass(Configuration configuration, ClassDoc cd, String outputdir) {
        File file;
        if (cd == null || outputdir == null) {
            return;
        }
        SourcePosition sp = cd.position();
        if (sp == null || (file = sp.file()) == null) {
            return;
        }
        try {
            int lineno = 1;
            StringBuffer output = new StringBuffer();
            LineNumberReader reader = new LineNumberReader(new FileReader(file));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    output.append(SourceToHTMLConverter.formatLine(line, configuration.sourcetab, lineno));
                    ++lineno;
                }
            }
            finally {
                reader.close();
            }
            output = SourceToHTMLConverter.addLineNumbers(output.toString());
            output.insert(0, SourceToHTMLConverter.getHeader());
            output.append(SourceToHTMLConverter.getFooter());
            SourceToHTMLConverter.writeToFile(output.toString(), outputdir, cd.name(), configuration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeToFile(String output, String outputDir, String className, Configuration configuration) throws IOException {
        File dir = new File(outputDir);
        dir.mkdirs();
        File newFile = new File(dir, className + ".html");
        configuration.message.notice("doclet.Generating_0", newFile.getPath());
        FileOutputStream fout = new FileOutputStream(newFile);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fout));
        bw.write(output);
        bw.close();
        fout.close();
    }

    private static StringBuffer addLineNumbers(String s) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, "\n", true);
        int lineno = 1;
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            sb.append(current.equals("\n") ? SourceToHTMLConverter.getHTMLLineNo(lineno) + current : SourceToHTMLConverter.getHTMLLineNo(lineno) + current + st.nextToken());
            ++lineno;
        }
        return sb;
    }

    protected static String getHeader() {
        return HEADER;
    }

    protected static String getFooter() {
        StringBuffer footer = new StringBuffer();
        for (int i = 0; i < 60; ++i) {
            footer.append(DocletConstants.NL);
        }
        footer.append("</PRE>" + DocletConstants.NL + "</BODY>" + DocletConstants.NL + "</HTML>" + DocletConstants.NL);
        return footer.toString();
    }

    protected static String getHTMLLineNo(int lineno) {
        StringBuffer result = new StringBuffer("<span id=\"line." + Integer.toString(lineno) + "\" class=\"line\">");
        if (lineno < 10) {
            result.append("00" + new Integer(lineno).toString());
        } else if (lineno < 100) {
            result.append("0" + new Integer(lineno).toString());
        } else {
            result.append(new Integer(lineno).toString());
        }
        result.append("</span>    ");
        return result.toString();
    }

    protected static String formatLine(String line, int tabLength, int currentLineNo) {
        if (line == null) {
            return null;
        }
        line = Util.escapeHtmlChars(line);
        Matcher matcher = KEYWORD_PATTERN.matcher(line);
        line = matcher.replaceAll(KEYWORD_REPLACEMENT);
        matcher = COMMENT_START_PATTERN.matcher(line);
        line = matcher.replaceAll(COMMENT_START_REPLACEMENT);
        matcher = COMMENT_END_PATTERN.matcher(line);
        line = matcher.replaceAll(COMMENT_END_REPLACEMENT);
        matcher = COMMENT_PATTERN.matcher(line);
        line = matcher.replaceAll(COMMENT_REPLACEMENT);
        StringBuffer lineBuffer = new StringBuffer(line);
        lineBuffer.append(DocletConstants.NL);
        Util.replaceTabs(tabLength, lineBuffer);
        return lineBuffer.toString();
    }

    protected static void addToHash(Doc[] docs, HashMap hash) {
        if (docs == null) {
            return;
        }
        for (int i = 0; i < docs.length; ++i) {
            hash.put(new Integer(docs[i].position().line()), SourceToHTMLConverter.getAnchor(docs[i]));
        }
    }

    protected static String getAnchor(Doc d) {
        return "    <a name=\"" + SourceToHTMLConverter.getAnchorName(d) + "\"></a>";
    }

    public static String getAnchorName(Doc d) {
        return "line." + d.position().line();
    }
}

