/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit.util;

import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VisibleMemberMap {
    private boolean noVisibleMembers = true;
    public static final int INNERCLASSES = 0;
    public static final int ENUM_CONSTANTS = 1;
    public static final int FIELDS = 2;
    public static final int CONSTRUCTORS = 3;
    public static final int METHODS = 4;
    public static final int ANNOTATION_TYPE_MEMBER_OPTIONAL = 5;
    public static final int ANNOTATION_TYPE_MEMBER_REQUIRED = 6;
    public static final int NUM_MEMBER_TYPES = 7;
    public static final String STARTLEVEL = "start";
    private final List visibleClasses = new ArrayList();
    private final Map memberNameMap = new HashMap();
    private final Map classMap = new HashMap();
    private final ClassDoc classdoc;
    private final int kind;
    private final boolean nodepr;

    public VisibleMemberMap(ClassDoc classdoc, int kind, boolean nodepr) {
        this.classdoc = classdoc;
        this.nodepr = nodepr;
        this.kind = kind;
        new ClassMembers(classdoc, STARTLEVEL).build();
    }

    public List getVisibleClassesList() {
        this.sort(this.visibleClasses);
        return this.visibleClasses;
    }

    private List getInheritedPackagePrivateMethods(Configuration configuration) {
        ArrayList results = new ArrayList();
        for (ClassDoc currentClass : this.visibleClasses) {
            if (currentClass == this.classdoc || !currentClass.isPackagePrivate() || Util.isLinkable(currentClass, configuration)) continue;
            results.addAll(this.getMembersFor(currentClass));
        }
        return results;
    }

    public List getLeafClassMembers(Configuration configuration) {
        List result = this.getMembersFor(this.classdoc);
        result.addAll(this.getInheritedPackagePrivateMethods(configuration));
        return result;
    }

    public List getMembersFor(ClassDoc cd) {
        ClassMembers clmembers = (ClassMembers)this.classMap.get(cd);
        if (clmembers == null) {
            return new ArrayList();
        }
        return clmembers.getMembers();
    }

    private void sort(List list) {
        ArrayList<ClassDoc> classes = new ArrayList<ClassDoc>();
        ArrayList<ClassDoc> interfaces = new ArrayList<ClassDoc>();
        for (int i = 0; i < list.size(); ++i) {
            ClassDoc cd = (ClassDoc)list.get(i);
            if (cd.isClass()) {
                classes.add(cd);
                continue;
            }
            interfaces.add(cd);
        }
        list.clear();
        list.addAll(classes);
        list.addAll(interfaces);
    }

    private void fillMemberLevelMap(List list, String level) {
        for (int i = 0; i < list.size(); ++i) {
            Object key = this.getMemberKey((ProgramElementDoc)list.get(i));
            HashMap memberLevelMap = (HashMap)this.memberNameMap.get(key);
            if (memberLevelMap == null) {
                memberLevelMap = new HashMap();
                this.memberNameMap.put(key, memberLevelMap);
            }
            memberLevelMap.put(list.get(i), level);
        }
    }

    private void purgeMemberLevelMap(List list, String level) {
        for (int i = 0; i < list.size(); ++i) {
            Object key = this.getMemberKey((ProgramElementDoc)list.get(i));
            Map memberLevelMap = (Map)this.memberNameMap.get(key);
            if (!level.equals(memberLevelMap.get(list.get(i)))) continue;
            memberLevelMap.remove(list.get(i));
        }
    }

    public boolean noVisibleMembers() {
        return this.noVisibleMembers;
    }

    private ClassMember getClassMember(MethodDoc member) {
        for (Object key : this.memberNameMap.keySet()) {
            if (key instanceof String || !((ClassMember)key).isEqual(member)) continue;
            return (ClassMember)key;
        }
        return new ClassMember((ProgramElementDoc)member);
    }

    private Object getMemberKey(ProgramElementDoc doc) {
        if (doc.isConstructor()) {
            return doc.name() + ((ExecutableMemberDoc)doc).signature();
        }
        if (doc.isMethod()) {
            return this.getClassMember((MethodDoc)doc);
        }
        if (doc.isField() || doc.isEnumConstant() || doc.isAnnotationTypeElement()) {
            return doc.name();
        }
        String classOrIntName = doc.name();
        classOrIntName = classOrIntName.indexOf(46) != 0 ? classOrIntName.substring(classOrIntName.lastIndexOf(46), classOrIntName.length()) : classOrIntName;
        return "clint" + classOrIntName;
    }

    private class ClassMembers {
        private ClassDoc mappingClass;
        private List members = new ArrayList();
        private String level;

        public List getMembers() {
            return this.members;
        }

        private ClassMembers(ClassDoc mappingClass, String level) {
            this.mappingClass = mappingClass;
            this.level = level;
            if (VisibleMemberMap.this.classMap.containsKey(mappingClass) && level.startsWith(((ClassMembers)((VisibleMemberMap)VisibleMemberMap.this).classMap.get((Object)mappingClass)).level)) {
                VisibleMemberMap.this.purgeMemberLevelMap(this.getClassMembers(mappingClass, false), ((ClassMembers)((VisibleMemberMap)VisibleMemberMap.this).classMap.get((Object)mappingClass)).level);
                VisibleMemberMap.this.classMap.remove(mappingClass);
                VisibleMemberMap.this.visibleClasses.remove(mappingClass);
            }
            if (!VisibleMemberMap.this.classMap.containsKey(mappingClass)) {
                VisibleMemberMap.this.classMap.put(mappingClass, this);
                VisibleMemberMap.this.visibleClasses.add(mappingClass);
            }
        }

        private void build() {
            if (VisibleMemberMap.this.kind == 3) {
                this.addMembers(this.mappingClass);
            } else {
                this.mapClass();
            }
        }

        private void mapClass() {
            ClassDoc superclass;
            this.addMembers(this.mappingClass);
            ClassDoc[] interfaces = this.mappingClass.interfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                String locallevel = this.level + 1;
                ClassMembers cm = new ClassMembers(interfaces[i], locallevel);
                cm.mapClass();
            }
            if (this.mappingClass.isClass() && (superclass = this.mappingClass.superclass()) != null && !this.mappingClass.equals(superclass)) {
                ClassMembers cm = new ClassMembers(superclass, this.level + "c");
                cm.mapClass();
            }
        }

        private void addMembers(ClassDoc fromClass) {
            List cdmembers = this.getClassMembers(fromClass, true);
            ArrayList<ProgramElementDoc> incllist = new ArrayList<ProgramElementDoc>();
            for (int i = 0; i < cdmembers.size(); ++i) {
                ProgramElementDoc pgmelem = (ProgramElementDoc)cdmembers.get(i);
                if (this.found(this.members, pgmelem) || !this.memberIsVisible(pgmelem) || this.isOverridden(pgmelem, this.level)) continue;
                incllist.add(pgmelem);
            }
            if (incllist.size() > 0) {
                VisibleMemberMap.this.noVisibleMembers = false;
            }
            this.members.addAll(incllist);
            VisibleMemberMap.this.fillMemberLevelMap(this.getClassMembers(fromClass, false), this.level);
        }

        private boolean memberIsVisible(ProgramElementDoc pgmdoc) {
            if (pgmdoc.containingClass().equals(VisibleMemberMap.this.classdoc)) {
                return true;
            }
            if (pgmdoc.isPrivate()) {
                return false;
            }
            if (pgmdoc.isPackagePrivate()) {
                return pgmdoc.containingClass().containingPackage().equals(VisibleMemberMap.this.classdoc.containingPackage());
            }
            return true;
        }

        private List getClassMembers(ClassDoc cd, boolean filter) {
            if (cd.isEnum() && VisibleMemberMap.this.kind == 3) {
                return Arrays.asList(new ProgramElementDoc[0]);
            }
            FieldDoc[] members = null;
            switch (VisibleMemberMap.this.kind) {
                case 5: {
                    members = cd.isAnnotationType() ? this.filter((AnnotationTypeDoc)cd, false) : new AnnotationTypeElementDoc[]{};
                    break;
                }
                case 6: {
                    members = cd.isAnnotationType() ? this.filter((AnnotationTypeDoc)cd, true) : new AnnotationTypeElementDoc[]{};
                    break;
                }
                case 0: {
                    members = cd.innerClasses(filter);
                    break;
                }
                case 1: {
                    members = cd.enumConstants();
                    break;
                }
                case 2: {
                    members = cd.fields(filter);
                    break;
                }
                case 3: {
                    members = cd.constructors();
                    break;
                }
                case 4: {
                    members = cd.methods(filter);
                    break;
                }
                default: {
                    members = new ProgramElementDoc[]{};
                }
            }
            if (VisibleMemberMap.this.nodepr) {
                return Util.excludeDeprecatedMembersAsList((ProgramElementDoc[])members);
            }
            return Arrays.asList(members);
        }

        private AnnotationTypeElementDoc[] filter(AnnotationTypeDoc doc, boolean required) {
            AnnotationTypeElementDoc[] members = doc.elements();
            ArrayList<AnnotationTypeElementDoc> targetMembers = new ArrayList<AnnotationTypeElementDoc>();
            for (int i = 0; i < members.length; ++i) {
                if ((!required || members[i].defaultValue() != null) && (required || members[i].defaultValue() == null)) continue;
                targetMembers.add(members[i]);
            }
            return targetMembers.toArray(new AnnotationTypeElementDoc[0]);
        }

        private boolean found(List list, ProgramElementDoc elem) {
            for (int i = 0; i < list.size(); ++i) {
                ProgramElementDoc pgmelem = (ProgramElementDoc)list.get(i);
                if (!Util.matches(pgmelem, elem)) continue;
                return true;
            }
            return false;
        }

        private boolean isOverridden(ProgramElementDoc pgmdoc, String level) {
            Map memberLevelMap = (Map)VisibleMemberMap.this.memberNameMap.get(VisibleMemberMap.this.getMemberKey(pgmdoc));
            if (memberLevelMap == null) {
                return false;
            }
            String mappedlevel2 = null;
            for (String mappedlevel2 : memberLevelMap.values()) {
                if (!mappedlevel2.equals(VisibleMemberMap.STARTLEVEL) && (!level.startsWith(mappedlevel2) || level.equals(mappedlevel2))) continue;
                return true;
            }
            return false;
        }
    }

    private class ClassMember {
        private Set members = new HashSet();

        public ClassMember(ProgramElementDoc programElementDoc) {
            this.members.add(programElementDoc);
        }

        public void addMember(ProgramElementDoc programElementDoc) {
            this.members.add(programElementDoc);
        }

        public boolean isEqual(MethodDoc member) {
            for (MethodDoc member2 : this.members) {
                if (!Util.executableMembersEqual((ExecutableMemberDoc)member, (ExecutableMemberDoc)member2)) continue;
                this.members.add(member);
                return true;
            }
            return false;
        }
    }
}

