/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.PropertiesFileRenderer;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.SecretPropertyField;
import org.tp23.antinstaller.page.Page;

public class ExplicitPropertiesFileRenderer
implements PropertiesFileRenderer {
    private static String newLine = System.getProperty("line.separator");
    private static final char[] hexidecimals = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void renderProperties(Installer installer, File file) {
        Object object;
        Page[] pageArray = installer.getPages();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("### Ant Installer - properties auto generated on ");
        stringBuffer.append(new Date().toString());
        stringBuffer.append(newLine);
        stringBuffer.append(newLine);
        stringBuffer.append("basedir");
        stringBuffer.append(" = ");
        stringBuffer.append(file.getAbsolutePath());
        stringBuffer.append(newLine);
        stringBuffer.append(newLine);
        String string = null;
        String string2 = null;
        for (int i = 0; i < pageArray.length; ++i) {
            object = pageArray[i].getOutputField();
            stringBuffer.append(newLine);
            stringBuffer.append("## Properties from Page:" + pageArray[i].getName());
            stringBuffer.append(newLine);
            for (int j = 0; j < ((Object)object).length; ++j) {
                String string3;
                InputField inputField;
                if (object[j] instanceof SecretPropertyField) {
                    inputField = (InputField)object[j];
                    string3 = inputField.getInputResult();
                    stringBuffer.append("# Property hidden " + this.printClass(object[j].getClass()));
                    stringBuffer.append(newLine);
                    string = this.convert(inputField.getProperty(), true);
                    stringBuffer.append("#" + string + "=XXXXXXXX");
                    stringBuffer.append(newLine);
                    continue;
                }
                if (!(object[j] instanceof InputField)) continue;
                inputField = (InputField)object[j];
                string3 = inputField.getInputResult();
                stringBuffer.append("# " + this.printClass(object[j].getClass()));
                stringBuffer.append(newLine);
                string = this.convert(inputField.getProperty(), true);
                string2 = this.convert(string3, false);
                stringBuffer.append(string + " = " + string2);
                stringBuffer.append(newLine);
            }
        }
        try {
            File file2 = new File(file.getAbsolutePath(), "ant.install.properties");
            object = new FileWriter(file2);
            BufferedWriter bufferedWriter = new BufferedWriter((Writer)object);
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.flush();
            ((OutputStreamWriter)object).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String printClass(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return string.substring(n, string.length());
    }

    private String convert(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block12: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block12;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block12;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block12;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block12;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block12;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block12;
                }
                case '=': {
                    stringBuffer.append("\\=");
                    continue block12;
                }
                case ':': {
                    stringBuffer.append("\\:");
                    continue block12;
                }
                case '#': {
                    stringBuffer.append("\\#");
                    continue block12;
                }
                case '!': {
                    stringBuffer.append("\\!");
                    continue block12;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuffer.append("\\u").append(this.hex(c >> 12 & 0xF)).append(this.hex(c >> 8 & 0xF)).append(this.hex(c >> 4 & 0xF)).append(this.hex(c & 0xF));
                        continue block12;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private char hex(int n) {
        return hexidecimals[n & 0xF];
    }
}

