/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.InputField;

public class LargeSelectInput
extends InputField {
    private Option[] options;

    public Option[] getOptions() {
        return this.options;
    }

    public void setOptions(Option[] optionArray) {
        this.options = optionArray;
    }

    public Option getNewOption() {
        return new Option();
    }

    public void setValue(String string) {
        this.setInputResult(string);
    }

    public boolean validate(InstallerContext installerContext) throws ValidationException {
        if (this.getInputResult() == null) {
            return false;
        }
        String string = this.getInputResult();
        boolean bl = false;
        for (int i = 0; i < this.options.length; ++i) {
            bl |= this.options[i].value.equals(string);
        }
        return bl;
    }

    public boolean validateObject() {
        int n;
        if (this.getDisplayText() == null) {
            System.out.println("LargeSelect:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            System.out.println("LargeSelect:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            System.out.println("LargeSelect:defaultValue must be set");
            return false;
        }
        if (this.getOptions() == null) {
            System.out.println("LargeSelect:option must have at least two options");
            return false;
        }
        if (this.getOptions().length < 2) {
            System.out.println("LargeSelect:option must have at least two options");
            return false;
        }
        for (n = 0; n < this.getOptions().length; ++n) {
            Option option = this.getOptions()[n];
            if (option.text == null) {
                System.out.println("LargeSelect:option:text must be set");
                return false;
            }
            if (option.value != null) continue;
            System.out.println("LargeSelect:option:value must be set");
            return false;
        }
        n = 0;
        for (int i = 0; i < this.getOptions().length; ++i) {
            Option option = this.getOptions()[i];
            if (!option.value.equals(this.getDefaultValue())) continue;
            n = 1;
        }
        if (n == 0) {
            System.out.println("LargeSelect:option:Default must be one of the options");
            return false;
        }
        return true;
    }

    public class Option {
        public String text;
        public String value;
    }
}

