/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.tp23.antinstaller.input.DirectoryInput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.swing.AIButton;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.AIShortTextField;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;
import org.tp23.gui.widget.DefaultingDirectoryChooser;

public class DirectoryInputRenderer
extends SwingOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    protected DirectoryInput inputField;
    private boolean createMode;
    private DefaultingDirectoryChooser chooser = null;
    protected AILabel fieldLabel = new AILabel();
    protected AIShortTextField jTextField = new AIShortTextField();
    protected AIButton browseButton = new AIButton();
    protected JPanel browsePanel = new JPanel();
    private JPanel parent;

    public void initComponent(JPanel jPanel) {
        this.parent = jPanel;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setOutputField(OutputField outputField) {
        this.inputField = (DirectoryInput)outputField;
        this.inputField.setValue(this.inputField.getDefaultValue(true));
        this.createMode = OutputField.isTrue(this.inputField.getCreate());
    }

    public void updateInputField() {
        if (!this.inputField.getDefaultValue(true).equals(this.jTextField.getText())) {
            this.inputField.setEditted(true);
        }
        this.inputField.setValue(this.jTextField.getText());
    }

    public void updateDefaultValue() {
        if (!this.inputField.isEditted()) {
            this.jTextField.setText(this.inputField.getDefaultValue(true));
        }
    }

    private void jbInit() throws Exception {
        BorderLayout borderLayout = new BorderLayout();
        this.browsePanel.setLayout(borderLayout);
        this.fieldLabel.setText(this.inputField.getDisplayText());
        this.jTextField.setText(this.inputField.getDefaultValue(true));
        this.browsePanel.add((Component)this.jTextField, "Center");
        this.browsePanel.add((Component)this.browseButton, "East");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = null;
                if (DirectoryInputRenderer.this.chooser == null) {
                    DirectoryInputRenderer.this.chooser = new DefaultingDirectoryChooser(DirectoryInputRenderer.this.createMode);
                    DirectoryInputRenderer.this.chooser.setFileHidingEnabled(false);
                }
                if (DirectoryInputRenderer.this.jTextField.getText() != null) {
                    DirectoryInputRenderer.this.chooser.setDefaultDirectory(new File(DirectoryInputRenderer.this.jTextField.getText()));
                } else {
                    DirectoryInputRenderer.this.chooser.setDefaultDirectory(new File(DirectoryInputRenderer.this.inputField.getDefaultValue()));
                }
                int n = DirectoryInputRenderer.this.chooser.showDialog((Component)DirectoryInputRenderer.this.parent, actionEvent.getActionCommand());
                if (n == 0) {
                    file = DirectoryInputRenderer.this.chooser.getSelectedFile();
                }
                if (file != null) {
                    DirectoryInputRenderer.this.jTextField.setText(file.getAbsolutePath());
                    DirectoryInputRenderer.this.inputField.setValue(file.getAbsolutePath());
                    DirectoryInputRenderer.this.inputField.setEditted(true);
                }
            }
        });
        this.browseButton.setText(res.getString("selectFolder"));
        this.browseButton.setPreferredSize(new Dimension(150, 20));
        this.jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectoryInputRenderer.this.updateInputField();
            }
        });
    }

    public int addSelf(JPanel jPanel, GBCF gBCF, int n, boolean bl) {
        jPanel.add((Component)this.fieldLabel, gBCF.getCell(n, 0));
        jPanel.add((Component)this.browsePanel, gBCF.getCell(n, 1));
        if (bl) {
            this.jTextField.setOverflow(SwingOutputFieldRenderer.OVERFLOW_SHORT_FIELD_SIZE);
        }
        return ++n;
    }

    public void renderError() {
    }
}

