/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tp23.antinstaller.input.LargeSelectInput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;

public class LargeSelectInputRenderer
extends SwingOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    protected LargeSelectInput inputField;
    protected JLabel fieldLabel = new AILabel();
    protected JComboBox optionCombo = new JComboBox();

    public void initComponent(JPanel jPanel) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setOutputField(OutputField outputField) {
        this.inputField = (LargeSelectInput)outputField;
    }

    public void updateInputField() {
        int n = this.optionCombo.getSelectedIndex();
        if (n != -1) {
            this.inputField.setValue(this.inputField.getOptions()[n].value);
        } else {
            this.inputField.setValue(this.inputField.getDefaultValue());
        }
    }

    public void updateDefaultValue() {
        if (!this.inputField.isEditted()) {
            String string = this.inputField.getDefaultValue();
            for (int i = 0; i < this.optionCombo.getItemCount(); ++i) {
                if (!string.equals(this.inputField.getOptions()[i].value)) continue;
                this.optionCombo.setSelectedIndex(i);
                break;
            }
        }
    }

    private void jbInit() throws Exception {
        this.fieldLabel.setText(this.inputField.getDisplayText());
        LargeSelectInput.Option[] optionArray = this.inputField.getOptions();
        for (int i = 0; i < optionArray.length; ++i) {
            this.optionCombo.addItem(optionArray[i].text);
            if (!optionArray[i].value.equals(this.inputField.getDefaultValue())) continue;
            this.optionCombo.setSelectedIndex(i);
        }
        this.optionCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                LargeSelectInputRenderer.this.inputField.setEditted(true);
            }
        });
    }

    public int addSelf(JPanel jPanel, GBCF gBCF, int n, boolean bl) {
        jPanel.add((Component)this.fieldLabel, gBCF.getCell(n, 0));
        jPanel.add((Component)this.optionCombo, gBCF.getCell(n, 1));
        if (bl) {
            this.optionCombo.setPreferredSize(SwingOutputFieldRenderer.OVERFLOW_FIELD_SIZE);
        }
        return ++n;
    }

    public void renderError() {
        this.ctx.getMessageRenderer().printMessage(res.getString("notValidSelection"));
        this.optionCombo.requestFocus();
    }
}

