/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.renderer.RendererFactory;
import org.tp23.antinstaller.renderer.swing.DisplayTextArea;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.antinstaller.renderer.swing.SwingPageRenderer;
import org.tp23.gui.GBCF;

public class SimpleInputPageRenderer
extends SwingPageRenderer {
    private JPanel contentPanel = new JPanel();
    private GridBagLayout gridLayout = new GridBagLayout();
    private GBCF cf = new GBCF();
    private boolean overflow = false;
    JScrollPane scroller = null;
    private ArrayList renderers = new ArrayList();

    public boolean validateFields() throws ValidationException {
        OutputField[] outputFieldArray = this.page.getOutputField();
        for (int i = 0; i < outputFieldArray.length; ++i) {
            if (outputFieldArray[i].validate(this.ctx)) continue;
            SwingOutputFieldRenderer swingOutputFieldRenderer = (SwingOutputFieldRenderer)this.renderers.get(i);
            swingOutputFieldRenderer.renderError();
            return false;
        }
        return true;
    }

    public void updateInputFields() {
        for (int i = 0; i < this.renderers.size(); ++i) {
            ((SwingOutputFieldRenderer)this.renderers.get(i)).updateInputField();
        }
    }

    public void updateDefaultValues() {
        for (int i = 0; i < this.renderers.size(); ++i) {
            ((SwingOutputFieldRenderer)this.renderers.get(i)).updateDefaultValue();
        }
    }

    public void instanceInit() throws Exception {
        this.overflow = ((SimpleInputPage)this.page).isOverflow();
        if (this.overflow) {
            this.contentPanel.setMaximumSize(new Dimension(SwingPageRenderer.PAGE_WIDTH - 50, SwingPageRenderer.PAGE_HEIGHT));
            this.scroller = new JScrollPane();
            this.scroller.setHorizontalScrollBarPolicy(30);
            this.scroller.setVerticalScrollBarPolicy(20);
            this.scroller.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
            this.add((Component)this.scroller, "Center");
            this.scroller.getViewport().add(this.contentPanel);
        } else {
            this.add((Component)this.contentPanel, "Center");
            this.contentPanel.setBorder(BorderFactory.createEmptyBorder(8, 4, 4, 4));
        }
        OutputField[] outputFieldArray = this.page.getOutputField();
        this.contentPanel.setDoubleBuffered(true);
        this.contentPanel.setLayout(this.gridLayout);
        int n = 0;
        for (int i = 0; i < outputFieldArray.length; ++i) {
            SwingOutputFieldRenderer swingOutputFieldRenderer = RendererFactory.getSwingRenderer(outputFieldArray[i]);
            String string = outputFieldArray[i].getExplanatoryText();
            if (outputFieldArray[i].getExplanatoryText() != null) {
                DisplayTextArea displayTextArea = new DisplayTextArea(this.contentPanel.getBackground(), this.contentPanel.getForeground());
                displayTextArea.setIgnoreRepaint(true);
                displayTextArea.setText(string);
                this.contentPanel.add((Component)displayTextArea, this.cf.getSpan(n++));
            }
            swingOutputFieldRenderer.setOutputField(outputFieldArray[i]);
            swingOutputFieldRenderer.setInstallerContext(this.ctx);
            swingOutputFieldRenderer.initComponent(this.contentPanel);
            n = swingOutputFieldRenderer.addSelf(this.contentPanel, this.cf, n, this.overflow);
            this.renderers.add(swingOutputFieldRenderer);
        }
        this.contentPanel.add((Component)new JPanel(), this.cf.getVertGlue(n++));
    }
}

