/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import javax.swing.JFrame;
import javax.swing.JLabel;
import org.apache.tools.ant.BuildEvent;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.renderer.swing.ProgressPanel;
import org.tp23.antinstaller.runtime.SwingRunner;

public class SwingInstallerContext {
    private static JFrame masterFrame;
    private SwingRunner swingRunner;
    private JLabel feedBackPanel;
    private ProgressPanel progressPanel;
    private InstallerContext ctx;

    public SwingInstallerContext(InstallerContext installerContext, JFrame jFrame) {
        this.ctx = installerContext;
        masterFrame = jFrame;
    }

    public JFrame getMasterFrame() {
        return masterFrame;
    }

    public SwingRunner getSwingRunner() {
        return (SwingRunner)this.ctx.getRunner();
    }

    public void setFeedBackLabel(JLabel jLabel) {
        this.feedBackPanel = jLabel;
    }

    public void setProgressPanel(ProgressPanel progressPanel) {
        this.progressPanel = progressPanel;
    }

    public void buildStarted(BuildEvent buildEvent) {
        this.provideAntFeedBack(buildEvent.getMessage());
        if (this.progressPanel != null) {
            this.progressPanel.prepareCalledTargets();
        }
    }

    public void buildFinished(BuildEvent buildEvent) {
        if (this.progressPanel != null) {
            this.progressPanel.buildFinished(buildEvent);
        }
    }

    public void targetStarted(BuildEvent buildEvent) {
        if (this.progressPanel != null) {
            this.progressPanel.targetStarted(buildEvent);
        }
    }

    public void targetFinished(BuildEvent buildEvent) {
        if (this.progressPanel != null) {
            this.progressPanel.targetFinished(buildEvent);
        }
    }

    public void provideAntFeedBack(String string) {
        if (this.feedBackPanel != null) {
            this.feedBackPanel.setText(string);
        }
    }

    public InstallerContext getInstallerContext() {
        return this.ctx;
    }
}

