/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.swing.PageCompletionListener;
import org.tp23.antinstaller.renderer.swing.SwingInstallerContext;

public abstract class SwingPageRenderer
extends JPanel {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    public static int PAGE_WIDTH = 472;
    public static int PAGE_HEIGHT = 400;
    public static int TITLE_IMAGE_HEIGHT = 100;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel controlPanel = new JPanel();
    private JButton backButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton nextButton = new JButton();
    private JButton finishButton = new JButton();
    private JPanel titlePanel = new JPanel();
    private JLabel titleLabel = new JLabel();
    private JLabel imagePanel = new JLabel();
    private GridLayout titleLayout = new GridLayout();
    protected Page page;
    protected SwingInstallerContext swingCtx;
    protected InstallerContext ctx;
    protected PageCompletionListener listener;
    private Border emptyBorder;
    private Border bevelBorder;
    private static Font titleFont = new JLabel().getFont();

    public void setPage(Page page) {
        this.page = page;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setContext(SwingInstallerContext swingInstallerContext) {
        this.ctx = swingInstallerContext.getInstallerContext();
        this.swingCtx = swingInstallerContext;
    }

    private void jbInit() throws Exception {
        this.setDoubleBuffered(true);
        this.emptyBorder = BorderFactory.createEmptyBorder(2, 5, 2, 2);
        this.bevelBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black, 1), BorderFactory.createEmptyBorder(2, 15, 2, 2));
        this.bevelBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 15, 2, 2));
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 4, 1, 4), this.bevelBorder);
        this.setLayout(this.borderLayout1);
        this.titleLabel.setBorder(compoundBorder);
        this.controlPanel.setBorder(compoundBorder);
        this.add((Component)this.titlePanel, "North");
        this.add((Component)this.controlPanel, "South");
        this.titlePanel.add((Component)this.imagePanel, null);
        this.titlePanel.add((Component)this.titleLabel, null);
        this.titlePanel.setLayout(this.titleLayout);
        this.titleLayout.setColumns(1);
        this.titleLayout.setHgap(0);
        this.titleLayout.setRows(2);
        this.titleLayout.setVgap(2);
        this.titlePanel.setMinimumSize(new Dimension(PAGE_WIDTH, 75));
        this.titlePanel.setMaximumSize(new Dimension(PAGE_WIDTH, 75));
        this.titlePanel.setPreferredSize(new Dimension(PAGE_WIDTH, 75));
        this.titleLabel.setText(this.page.getDisplayText());
        this.titleLabel.setFont(titleFont);
        this.setImage(this.page.getImageResource());
        this.imagePanel.setMinimumSize(new Dimension(PAGE_WIDTH, TITLE_IMAGE_HEIGHT));
        this.imagePanel.setMaximumSize(new Dimension(PAGE_WIDTH, TITLE_IMAGE_HEIGHT));
        this.imagePanel.setPreferredSize(new Dimension(PAGE_WIDTH, TITLE_IMAGE_HEIGHT));
        this.controlPanel.add((Component)this.cancelButton, null);
        this.controlPanel.add((Component)this.backButton, null);
        this.controlPanel.add((Component)this.nextButton, null);
        this.controlPanel.add((Component)this.finishButton, null);
        this.backButton.setText(res.getString("backButton"));
        this.cancelButton.setText(res.getString("cancelButton"));
        this.nextButton.setText(res.getString("nextButton"));
        this.finishButton.setText(this.ctx.getInstaller().getFinishButtonText());
        this.finishButton.setEnabled(false);
        this.setEventListeners();
    }

    public abstract void instanceInit() throws Exception;

    public abstract void updateInputFields();

    public abstract void updateDefaultValues();

    public abstract boolean validateFields() throws ValidationException;

    public void setPageCompletionListener(PageCompletionListener pageCompletionListener) {
        this.listener = pageCompletionListener;
    }

    private void setImage(String string) throws Exception {
        block5: {
            if (string == null) {
                string = this.ctx.getInstaller().getDefaultImageResource();
            }
            try {
                if (string != null) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    InputStream inputStream = this.getClass().getResourceAsStream(string);
                    byte[] byArray = new byte[2048];
                    int n = -1;
                    while ((n = inputStream.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    ImageIcon imageIcon = new ImageIcon(byteArrayOutputStream.toByteArray());
                    this.imagePanel.setIcon(imageIcon);
                }
            }
            catch (Exception exception) {
                this.ctx.log("Can't load image resource:" + string);
                if (!this.ctx.getInstaller().isVerbose()) break block5;
                this.ctx.log(exception);
            }
        }
    }

    private void setEventListeners() {
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingPageRenderer.this.listener.pageBack(SwingPageRenderer.this.page);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingPageRenderer.this.page.setAbort(true);
                SwingPageRenderer.this.listener.pageComplete(SwingPageRenderer.this.page);
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingPageRenderer.this.listener.pageComplete(SwingPageRenderer.this.page);
            }
        });
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SwingPageRenderer.this.finishButton.getText().equals(res.getString("exit"))) {
                    System.exit(0);
                }
                SwingPageRenderer.this.listener.pageComplete(SwingPageRenderer.this.page);
            }
        });
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public InstallerContext getCtx() {
        return this.ctx;
    }

    public JPanel getControlPanel() {
        return this.controlPanel;
    }

    public JLabel getImagePanel() {
        return this.imagePanel;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public JButton getFinishButton() {
        return this.finishButton;
    }

    public JButton getBackButton() {
        return this.backButton;
    }

    static {
        try {
            titleFont = new Font(titleFont.getFamily(), 1, 14);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

