/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class SelectInputRenderer
implements TextOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    protected InstallerContext ctx;

    public void setContext(InstallerContext installerContext) {
        this.ctx = installerContext;
    }

    public void renderOutput(OutputField outputField, InputStream inputStream, PrintStream printStream) throws IOException {
        SelectInput selectInput = (SelectInput)outputField;
        this.printText(selectInput, printStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        printStream.println();
        if (string == null || string.equals("")) {
            string = selectInput.getDefaultValue();
        } else {
            try {
                int n = Integer.parseInt(string.trim());
                string = selectInput.getOptions()[n - 1].value;
            }
            catch (Exception exception) {
                return;
            }
        }
        selectInput.setInputResult(string);
    }

    public boolean isAbort() {
        return false;
    }

    private void printText(SelectInput selectInput, PrintStream printStream) throws IOException {
        printStream.println(selectInput.getDisplayText());
        SelectInput.Option[] optionArray = selectInput.getOptions();
        printStream.print("  ");
        printStream.println(res.getString("enterNumber"));
        for (int i = 0; i < optionArray.length; ++i) {
            printStream.print("  ");
            printStream.print(i + 1);
            printStream.print(") ");
            printStream.print(optionArray[i].text);
            if (selectInput.getDefaultValue().equals(optionArray[i].value)) {
                printStream.print(" [");
                printStream.print(res.getString("_default_"));
                printStream.print("]");
            }
            printStream.println();
        }
    }

    public void renderError(OutputField outputField, InputStream inputStream, PrintStream printStream) throws IOException {
        this.ctx.getMessageRenderer().printMessage("Not a valid selection");
        this.renderOutput(outputField, inputStream, printStream);
    }
}

