/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.IOException;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.renderer.RendererFactory;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;
import org.tp23.antinstaller.renderer.text.TextPageRenderer;

public class SimpleInputPageRenderer
extends TextPageRenderer {
    public boolean renderPage(Page page) throws InstallException {
        if (page instanceof SimpleInputPage) {
            try {
                return this.renderSimpleInputPage((SimpleInputPage)page);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InstallException("Cant find acceptable TextField renderer in SimpleInputPageRenderer.renderPage:" + classNotFoundException.getMessage(), classNotFoundException);
            }
        }
        throw new InstallException("Wrong Renderer in SimpleInputPageRenderer.renderPage");
    }

    private boolean renderSimpleInputPage(SimpleInputPage simpleInputPage) throws InstallException, ClassNotFoundException, ValidationException {
        try {
            this.printHeader(simpleInputPage);
            OutputField[] outputFieldArray = simpleInputPage.getOutputField();
            for (int i = 0; i < outputFieldArray.length; ++i) {
                String string = outputFieldArray[i].getExplanatoryText();
                if (string != null) {
                    this.out.println(string);
                    this.out.println();
                }
                TextOutputFieldRenderer textOutputFieldRenderer = RendererFactory.getTextRenderer(outputFieldArray[i]);
                textOutputFieldRenderer.setContext(this.getContext());
                textOutputFieldRenderer.renderOutput(outputFieldArray[i], this.in, this.out);
                if (textOutputFieldRenderer.isAbort()) {
                    return false;
                }
                while (!outputFieldArray[i].validate(this.ctx)) {
                    textOutputFieldRenderer.renderError(outputFieldArray[i], this.in, this.out);
                }
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InstallException("Classes missing", classNotFoundException);
        }
        catch (IOException iOException) {
            throw new InstallException("IOException", iOException);
        }
    }
}

