/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.StringTokenizer;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.runtime.Runner;
import org.tp23.antinstaller.runtime.SwingRunner;
import org.tp23.antinstaller.runtime.TextRunner;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;

public class CreateUIFilter
implements ExecuteFilter {
    public void exec(InstallerContext installerContext) throws InstallException {
        try {
            if (installerContext.getInstaller().isVerbose()) {
                installerContext.log("Creating UI classes");
            }
            installerContext.setRunner(this.getRunner(installerContext));
            installerContext.log("Created UI classes");
        }
        catch (IOException iOException) {
            throw new InstallException("Not to create the user interface", iOException);
        }
        catch (InstallException installException) {
            throw new InstallException("Not to create the user interface", installException);
        }
    }

    private Runner getRunner(InstallerContext installerContext) throws IOException, InstallException {
        boolean bl = true;
        if (installerContext.getUIOverride() != null) {
            if (installerContext.getUIOverride().equalsIgnoreCase("swing")) {
                if (this.isUi("swing", installerContext.getInstaller().getUi())) {
                    return new SwingRunner(installerContext);
                }
                throw new InstallException("Not a permited UI override, swing is not allowed");
            }
            if (installerContext.getUIOverride().equalsIgnoreCase("text")) {
                if (this.isUi("text", installerContext.getInstaller().getUi())) {
                    return new TextRunner(installerContext);
                }
                throw new InstallException("Not a permited UI override, text is not allowed");
            }
        }
        try {
            GraphicsEnvironment.getLocalGraphicsEnvironment();
        }
        catch (Throwable throwable) {
            System.out.println("No graphics environment available, reverting to text");
            System.out.println();
            return new TextRunner(installerContext);
        }
        return new SwingRunner(installerContext);
    }

    private boolean isUi(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().equals(string)) continue;
            return true;
        }
        return false;
    }
}

