/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.TemporaryFilesystem;

class SafariDriverExtension {
    private static final Logger logger = Logger.getLogger(SafariDriverExtension.class.getName());
    public static final String EXTENSION_LOCATION_PROPERTY = "webdriver.safari.driver";
    public static final String NO_INSTALL_EXTENSION_PROPERTY = "webdriver.safari.noinstall";
    private static final String EXTENSION_RESOURCE_PATH = String.format("/%s/SafariDriver.safariextz", SafariDriverExtension.class.getPackage().getName().replace('.', '/'));
    private static final String EXTENSION_PLIST_LINES = Joiner.on((String)"\n").join((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", (Object)"<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">", new Object[]{"<plist version=\"1.0\">", "<dict>", "\t<key>Available Updates</key>", "\t<dict>", "\t\t<key>Last Update Check Time</key>", "\t\t<real>370125644.75941497</real>", "\t\t<key>Updates List</key>", "\t\t<array/>", "\t</dict>", "\t<key>Installed Extensions</key>", "\t<array>", "\t\t<dict>", "\t\t\t<key>Added Non-Default Toolbar Items</key>", "\t\t\t<array/>", "\t\t\t<key>Archive File Name</key>", "\t\t\t<string>WebDriver.safariextz</string>", "\t\t\t<key>Bundle Directory Name</key>", "\t\t\t<string>WebDriver.safariextension</string>", "\t\t\t<key>Enabled</key>", "\t\t\t<true/>", "\t\t\t<key>Hidden Bars</key>", "\t\t\t<array/>", "\t\t\t<key>Removed Default Toolbar Items</key>", "\t\t\t<array/>", "\t\t</dict>", "\t</array>", "\t<key>Version</key>", "\t<integer>1</integer>", "</dict>", "</plist>"});
    private final Runtime runtime = Runtime.getRuntime();
    private final Backup backup = new Backup();
    private final Optional<File> customDataDir;
    private final boolean installExtension;
    private UninstallThread uninstallThread;
    private File installedExtension;

    SafariDriverExtension(Optional<File> customDataDir, boolean installExtension) {
        this.customDataDir = customDataDir;
        this.installExtension = !Boolean.getBoolean(NO_INSTALL_EXTENSION_PROPERTY) && installExtension;
    }

    private static File getSafariDataDirectory() {
        Platform current = Platform.getCurrent();
        if (Platform.MAC.is(current)) {
            return new File("/Users/" + System.getenv("USER"), "Library/Safari");
        }
        if (Platform.WINDOWS.is(current)) {
            return new File(System.getenv("APPDATA"), "Apple Computer/Safari");
        }
        throw new IllegalStateException("The current platform is not supported: " + (Object)((Object)current));
    }

    private static File getInstallDirectory(Optional<File> customDataDir) throws IOException {
        File dataDir = (File)customDataDir.or((Object)SafariDriverExtension.getSafariDataDirectory());
        Preconditions.checkState((boolean)dataDir.isDirectory(), (String)"The expected Safari data directory does not exist: %s", (Object[])new Object[]{dataDir.getAbsolutePath()});
        File extensionsDir = new File(dataDir, "Extensions");
        if (!extensionsDir.isDirectory()) {
            extensionsDir.mkdir();
        }
        return extensionsDir;
    }

    public synchronized void install() throws IOException {
        if (this.uninstallThread != null) {
            return;
        }
        if (!this.installExtension) {
            logger.info("Use of prebuilt extension requested; skipping installation");
            return;
        }
        InputSupplier extensionSrc = (InputSupplier)SafariDriverExtension.getExtensionFromSystemProperties().or(SafariDriverExtension.getExtensionResource());
        File installDirectory = SafariDriverExtension.getInstallDirectory(this.customDataDir);
        this.installedExtension = new File(installDirectory, "WebDriver.safariextz");
        if (this.installedExtension.exists()) {
            this.backup.backup(this.installedExtension);
        }
        Files.copy((InputSupplier)extensionSrc, (File)this.installedExtension);
        File extensionPlist = new File(installDirectory, "Extensions.plist");
        if (extensionPlist.exists()) {
            this.backup.backup(extensionPlist);
        }
        Files.write((CharSequence)EXTENSION_PLIST_LINES, (File)extensionPlist, (Charset)Charsets.UTF_8);
        this.uninstallThread = new UninstallThread();
        this.runtime.addShutdownHook(this.uninstallThread);
    }

    private static Optional<InputSupplier<? extends InputStream>> getExtensionFromSystemProperties() throws FileNotFoundException {
        String extensionPath = System.getProperty(EXTENSION_LOCATION_PROPERTY);
        if (Strings.isNullOrEmpty((String)extensionPath)) {
            return Optional.absent();
        }
        File extensionSrc = new File(extensionPath);
        Preconditions.checkState((boolean)extensionSrc.isFile(), (String)"The SafariDriver extension specified through the %s system property does not exist: %s", (Object[])new Object[]{EXTENSION_LOCATION_PROPERTY, extensionPath});
        Preconditions.checkState((boolean)extensionSrc.canRead(), (String)"The SafariDriver extension specified through the %s system property is not readable: %s", (Object[])new Object[]{EXTENSION_LOCATION_PROPERTY, extensionPath});
        logger.info("Using extension " + extensionSrc.getAbsolutePath());
        InputSupplier supplier = Files.newInputStreamSupplier((File)extensionSrc);
        return Optional.of((Object)supplier);
    }

    private static InputSupplier<? extends InputStream> getExtensionResource() {
        URL url = SafariDriverExtension.class.getResource(EXTENSION_RESOURCE_PATH);
        Preconditions.checkNotNull((Object)url, (String)"Unable to locate extension resource, %s", (Object[])new Object[]{EXTENSION_RESOURCE_PATH});
        return Resources.newInputStreamSupplier((URL)url);
    }

    public synchronized void uninstall() throws IOException {
        if (this.uninstallThread != null) {
            try {
                this.runtime.removeShutdownHook(this.uninstallThread);
            }
            catch (IllegalStateException illegalStateException) {}
            this.uninstallThread = null;
            this.installedExtension.delete();
            this.backup.restoreAll();
        }
    }

    private static class Backup {
        private final TemporaryFilesystem filesystem = TemporaryFilesystem.getDefaultTmpFS();
        private final Map<File, File> backups = Maps.newHashMap();
        private File backupDir;

        private Backup() {
        }

        File backup(File file) throws IOException {
            if (this.backupDir == null) {
                this.backupDir = this.filesystem.createTempDir("SafariBackups", "webdriver");
            }
            File backup = new File(this.backupDir, file.getName());
            Files.copy((File)file, (File)backup);
            this.backups.put(file, backup);
            return backup;
        }

        void restoreAll() throws IOException {
            for (Map.Entry<File, File> entry : this.backups.entrySet()) {
                File originalLocation = entry.getKey();
                File backup = entry.getValue();
                Files.copy((File)backup, (File)originalLocation);
            }
        }
    }

    private class UninstallThread
    extends Thread {
        private UninstallThread() {
        }

        @Override
        public void run() {
            try {
                SafariDriverExtension.this.uninstall();
            }
            catch (IOException e) {
                throw new WebDriverException("Unable to uninstall extension", e);
            }
        }
    }
}

