/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.jalopy.language.ClassRepository;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

public class ClassRepositoryEntry {
    Info info;
    Set data = Collections.EMPTY_SET;

    public ClassRepositoryEntry(Info info, Set data) {
        this.data = data;
        this.info = info;
    }

    public ClassRepositoryEntry(File location, long lastModified, Set data) {
        this(new Info(location), data);
    }

    ClassRepositoryEntry() {
    }

    public static Info getInfo(File file) throws IOException {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            Info info = (Info)in.readObject();
            return info;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        finally {
            in.close();
        }
    }

    public void setData(Set data) {
        this.data = data;
    }

    public Set getData() {
        return this.data;
    }

    public Info getInfo() {
        return this.info;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClassRepositoryEntry)) {
            return false;
        }
        return this.data.equals(((ClassRepositoryEntry)o).data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public String toString() {
        return "ClassRepositoryEntry: " + this.info.getLocation();
    }

    public static final class Info
    implements Serializable,
    Comparable {
        static final long serialVersionUID = 6093443653626639672L;
        transient String filename;
        transient String location;
        transient boolean loaded;

        public Info(File location) {
            if (!location.exists()) {
                throw new IllegalArgumentException("location does not exist -- " + location);
            }
            this.location = location.getAbsolutePath();
            if (!(location.isDirectory() || this.location.endsWith(".jar") || this.location.endsWith(".zip"))) {
                throw new IllegalArgumentException(location + " does denote archive or directory");
            }
            Info info = ClassRepository.getInstance().get(location);
            this.filename = info == null ? (location.isDirectory() ? String.valueOf(String.valueOf(System.currentTimeMillis()) + ".repository") : this.genFilename(String.valueOf(location.getName().substring(0, location.getName().lastIndexOf(46))) + ".repository")) : info.getFilename();
        }

        public String getFilename() {
            return this.filename;
        }

        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public File getLocation() {
            return new File(this.location);
        }

        public boolean isRefreshable() {
            return new File(this.location).exists();
        }

        public int compareTo(Object o) {
            if (o instanceof Info) {
                return this.location.compareToIgnoreCase(((Info)o).location);
            }
            if (o instanceof String) {
                return this.location.compareToIgnoreCase((String)o);
            }
            throw new ClassCastException(o.getClass().getName());
        }

        public boolean equals(Object o) {
            if (o instanceof Info) {
                return this.location.equals(((Info)o).location);
            }
            if (o instanceof String) {
                return this.location.equals(o);
            }
            return false;
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public String toString() {
            return String.valueOf(this.location) + " [" + this.filename + "]";
        }

        private String genFilename(String newFilename) {
            File file = new File(String.valueOf(Convention.getInstance().get(ConventionKeys.CLASS_REPOSITORY_DIRECTORY, Convention.getRepositoryDirectory().getAbsolutePath())) + newFilename);
            if (file.exists()) {
                int paren = newFilename.indexOf(40);
                if (paren > -1) {
                    String number = newFilename.substring(paren + 1, newFilename.lastIndexOf(41));
                    try {
                        int n = Integer.parseInt(number);
                        newFilename = String.valueOf(newFilename.substring(0, newFilename.lastIndexOf(40))) + "(" + ++n + ")" + ".repository";
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("error creating filename for " + newFilename);
                    }
                } else {
                    newFilename = String.valueOf(newFilename.substring(0, newFilename.lastIndexOf(46))) + "(1)" + ".repository";
                }
                newFilename = this.genFilename(newFilename);
            }
            return newFilename;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.location = (String)in.readObject();
            this.filename = (String)in.readObject();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(this.location);
            out.writeObject(this.filename);
        }
    }
}

