/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import antlr.CharBuffer;
import antlr.CharStreamException;
import antlr.InputBuffer;
import antlr.LexerSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import de.hunsicker.io.FileFormat;
import de.hunsicker.jalopy.language.CompositeFactory;
import de.hunsicker.jalopy.language.Lexer;
import de.hunsicker.jalopy.language.Parser;
import de.hunsicker.jalopy.language.Recognizer;
import de.hunsicker.jalopy.language.antlr.ExtendedToken;
import de.hunsicker.jalopy.language.antlr.InternalJavadocLexer;
import de.hunsicker.jalopy.language.antlr.JavadocParser;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class JavadocLexer
extends InternalJavadocLexer
implements Lexer {
    private Logger _logger = Logger.getLogger((String)"de.hunsicker.jalopy.language.javadoc");
    static final int UNDEFINED_TOKEN = -10;
    private Position _mark;
    private Position _position = new Position(1, 1);
    private String _tabString;
    private JavadocParser _parser;
    private final CompositeFactory factory;
    Recognizer recognizer = null;
    private int _tabSize = 4;

    public JavadocLexer(CompositeFactory factory) {
        this(new StringReader(""), factory);
        this._parser = new JavadocParser((TokenStream)this, factory.getJavaNodeFactory());
        this._parser.setASTFactory(factory.getNodeFactory());
        this._parser.setLexer(this);
    }

    public JavadocLexer(Reader in, CompositeFactory factory) {
        this(new CharBuffer(in), factory);
    }

    public JavadocLexer(InputBuffer ib, CompositeFactory factory) {
        this(new MyLexerSharedInputState(ib), factory);
    }

    public JavadocLexer(LexerSharedInputState state, CompositeFactory factory) {
        super(state);
        this.factory = factory;
    }

    public Parser getParser() {
        return this._parser;
    }

    public void panic() {
        if (this.inputState != null) {
            Object[] args = new Object[]{this.getFilename(), new Integer(this.getLine()), new Integer(this.getColumn()), "JavadocLexer: panic"};
            this._logger.l7dlog((Priority)Level.FATAL, "PARSER_ERROR", args, null);
        } else {
            if (this._logger == null) {
                this._logger = Logger.getLogger((String)"de.hunsicker.jalopy.language.java");
            }
            Object[] args = new Object[]{"???", new Integer(0), new Integer(0), "JavaLexer: panic"};
            this._logger.l7dlog((Priority)Level.FATAL, "PARSER_ERROR", args, null);
        }
    }

    public void panic(String message) {
        if (this.inputState != null) {
            Object[] args = new Object[]{this.getFilename(), new Integer(this.getLine()), new Integer(this.getColumn()), message};
            this._logger.l7dlog((Priority)Level.FATAL, "PARSER_ERROR", args, null);
        } else {
            if (this._logger == null) {
                this._logger = Logger.getLogger((String)"de.hunsicker.jalopy.language.java");
            }
            Object[] args = new Object[]{"???", new Integer(0), new Integer(0), message};
            this._logger.l7dlog((Priority)Level.FATAL, "PARSER_ERROR", args, null);
        }
    }

    public void reportError(RecognitionException ex) {
        ex.printStackTrace();
        Integer line = new Integer((this.recognizer != null ? this.recognizer.getStartLine() : 0) + this.getLine());
        Integer column = new Integer((this.recognizer != null ? this.recognizer.getStartColumn() : 0) + this.getColumn());
        Object[] args = new Object[]{this.getFilename(), line, column, ex.getMessage()};
        this._logger.l7dlog((Priority)Level.ERROR, "PARSER_ERROR", args, (Throwable)ex);
    }

    public void reportError(String message) {
        Integer line = new Integer((this.recognizer != null ? this.recognizer.getStartLine() : 0) + this.getLine());
        Integer column = new Integer((this.recognizer != null ? this.recognizer.getStartColumn() : 0) + this.getColumn());
        Object[] args = new Object[]{this.getFilename(), line, column, message};
        this._logger.l7dlog((Priority)Level.ERROR, "PARSER_ERROR", args, null);
    }

    public void reportWarning(String message) {
        Object[] args = new Object[]{this.getFilename(), new Integer(this.getLine()), new Integer(this.getColumn()), message};
        this._logger.l7dlog((Priority)Level.WARN, "PARSER_ERROR", args, null);
    }

    public FileFormat getFileFormat() {
        return this._fileFormat;
    }

    public void setTokenObjectClass(String clazz) {
        super.setTokenObjectClass("de.hunsicker.jalopy.language.antlr.ExtendedToken");
    }

    private Position getPosition() {
        this._position.line = this.getLine();
        this._position.column = this.getColumn();
        return this._position;
    }

    private void setPosition(Position pos) {
        this.setColumn(pos.column);
        this.setLine(pos.line);
    }

    public void setInputBuffer(InputBuffer buf) {
        if (this.inputState != null) {
            ((MyLexerSharedInputState)this.inputState).setInputBuffer(buf);
        }
    }

    public void setInputBuffer(Reader in) {
        this.setInputBuffer(new CharBuffer(in));
    }

    public void reset() {
        if (this.inputState != null) {
            this.inputState.reset();
        }
        this.setFilename("<unknown>");
        this._tabString = null;
        this._fileFormat = FileFormat.UNKNOWN;
        this._mark = null;
    }

    protected Token makeToken(int t) {
        if (this._mark != null) {
            Position cur = this.getPosition();
            this.setPosition(this._mark);
            ExtendedToken newToken = this.factory.getExtendedTokenFactory().create(t, null);
            newToken.setLine(this.getLine());
            newToken.setColumn(this.getColumn());
            this._mark = null;
            this.setPosition(cur);
            return newToken;
        }
        ExtendedToken newToken = this.factory.getExtendedTokenFactory().create(t, null);
        newToken.setLine(this.getLine());
        newToken.setColumn(this.getColumn());
        return newToken;
    }

    public int getTabSize() {
        return this._tabSize;
    }

    public void setTabSize(int size) {
        this._tabSize = size;
    }

    protected void replaceTab() throws CharStreamException {
        if (this._tabString == null) {
            int tabSize = this.getTabSize();
            StringBuffer indent = new StringBuffer(tabSize);
            int i = 0;
            while (i < tabSize) {
                indent.append(' ');
                ++i;
            }
            this._tabString = indent.toString();
        }
        this.text.setLength(this.text.length() - 1);
        this.text.append(this._tabString);
    }

    protected void replaceNewline(int length) throws CharStreamException {
        this.text.setLength(this.text.length() - length);
        this.newline();
        if (this.LA(1) != ' ') {
            if (this.text.length() > 0) {
                switch (this.text.charAt(this.text.length() - 1)) {
                    case ' ': 
                    case '(': 
                    case '-': 
                    case '[': 
                    case '{': {
                        break;
                    }
                    default: {
                        this.text.append(' ');
                        break;
                    }
                }
            } else {
                this.text.append(' ');
            }
        }
    }

    public void newline() {
        this.newline(true);
    }

    public void newline(boolean skipAllLeadingWhitespace) {
        this._mark = this.getPosition();
        super.newline();
        try {
            this.skipLeadingSpaceAndAsterix(skipAllLeadingWhitespace);
        }
        catch (CharStreamException charStreamException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void skipLeadingSpaceAndAsterix(boolean skipAllLeadingWhitespace) throws CharStreamException {
        try {
            this.saveConsumedInput = false;
            char next = this.LA(1);
            boolean newline = false;
            while (next != '\uffff') {
                switch (next) {
                    case '\n': 
                    case '\r': {
                        this.consume();
                        if (!newline) {
                            this.setLine(this.getLine() + 1);
                            newline = true;
                        }
                        this.setColumn(1);
                        next = this.LA(1);
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        switch (this.LA(2)) {
                            case '\t': 
                            case ' ': {
                                this.consume();
                            }
                            case '*': {
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        this.consume();
                        next = this.LA(1);
                        break;
                    }
                    case '*': {
                        if (skipAllLeadingWhitespace) {
                            if (this.LA(2) == '/') {
                                if (this.LA(2) != ' ') return;
                                this.consume();
                                this.consume();
                                return;
                            }
                            this.consume();
                            next = this.LA(1);
                            break;
                        }
                        switch (this.LA(2)) {
                            case '\r': {
                                if (this.LA(3) == '\n') {
                                    this.consume();
                                    return;
                                }
                            }
                            case '\n': 
                            case ' ': {
                                this.consume();
                                this.consume();
                                return;
                            }
                        }
                        if (this.LA(2) == '/') return;
                        this.consume();
                        next = this.LA(1);
                        break;
                    }
                    default: {
                        this.text.append(' ');
                        return;
                    }
                }
            }
            return;
        }
        finally {
            this.saveConsumedInput = true;
        }
    }

    public void setRecognizer(Recognizer recognizer2) {
        this.recognizer = recognizer2;
    }

    static class MyLexerSharedInputState
    extends LexerSharedInputState {
        public MyLexerSharedInputState(InputBuffer inbuf) {
            super(inbuf);
        }

        public MyLexerSharedInputState() {
            this((InputBuffer)null);
        }

        public void setInputBuffer(InputBuffer inbuf) {
            this.reset();
            this.input = inbuf;
        }
    }

    private static class Position
    implements Comparable {
        int line;
        int column;

        public Position(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public int compareTo(Object o) {
            if (o == this) {
                return 0;
            }
            Position other = (Position)o;
            if (this.line > other.line) {
                return -1;
            }
            if (this.line < other.line) {
                return 1;
            }
            if (this.column > other.column) {
                return -1;
            }
            if (this.column < other.column) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(20);
            buf.append("[");
            buf.append("line=");
            buf.append(this.line);
            buf.append(",col=");
            buf.append(this.column);
            buf.append("]");
            return buf.toString();
        }
    }
}

