/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.jalopy.language.Type;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class ModifierType
implements Comparable,
Type {
    static final int PUBLIC_INT = 1;
    static final int PROTECTED_INT = 4;
    static final int PRIVATE_INT = 2;
    static final int STATIC_INT = 8;
    static final int FINAL_INT = 16;
    static final int TRANSIENT_INT = 128;
    static final int ABSTRACT_INT = 1024;
    static final int NATIVE_INT = 256;
    static final int SYNCHRONIZED_INT = 32;
    static final int VOLATILE_INT = 64;
    static final int STRICTFP_INT = 2048;
    private static final String DELIMETER = "|";
    private static String _sortOrder;
    private static List _order;
    public static final ModifierType PUBLIC;
    public static final ModifierType PROTECTED;
    public static final ModifierType PRIVATE;
    public static final ModifierType STATIC;
    public static final ModifierType FINAL;
    public static final ModifierType TRANSIENT;
    public static final ModifierType NATIVE;
    public static final ModifierType ABSTRACT;
    public static final ModifierType SYNCHRONIZED;
    public static final ModifierType VOLATILE;
    public static final ModifierType STRICTFP;
    private final String _name;
    private boolean sortOption = true;
    private final int _key;
    public static final int MASK = -1;

    static {
        _order = new ArrayList(7);
        PUBLIC = new ModifierType("public", 1);
        PROTECTED = new ModifierType("protected", 4);
        PRIVATE = new ModifierType("private", 2);
        STATIC = new ModifierType("static", 8);
        FINAL = new ModifierType("final", 16);
        TRANSIENT = new ModifierType("transient", 128);
        NATIVE = new ModifierType("native", 256);
        ABSTRACT = new ModifierType("abstract", 1024);
        SYNCHRONIZED = new ModifierType("synchronized", 32);
        VOLATILE = new ModifierType("volatile", 64);
        STRICTFP = new ModifierType("strictfp", 2048);
        _order.add(PUBLIC);
        _order.add(PROTECTED);
        _order.add(PRIVATE);
        _order.add(ABSTRACT);
        _order.add(STATIC);
        _order.add(FINAL);
        _order.add(SYNCHRONIZED);
        _order.add(TRANSIENT);
        _order.add(VOLATILE);
        _order.add(NATIVE);
        _order.add(STRICTFP);
        StringBuffer buf = new StringBuffer(100);
        int i = 0;
        int size = _order.size();
        while (i < size) {
            buf.append(((ModifierType)ModifierType._order.get((int)i))._name);
            buf.append(DELIMETER);
            ++i;
        }
        buf.setLength(buf.length() - 1);
        _sortOrder = buf.toString();
    }

    private ModifierType(String name, int key) {
        this._name = name;
        this._key = key;
    }

    public String getName() {
        return this._name;
    }

    public static synchronized void setOrder(String str) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("order == " + str);
        }
        StringTokenizer tokens = new StringTokenizer(str, DELIMETER);
        ArrayList<ModifierType> temp = new ArrayList<ModifierType>(_order.size());
        StringBuffer buf = new StringBuffer(50);
        while (tokens.hasMoreElements()) {
            ModifierType type;
            String token;
            String name = token = tokens.nextToken();
            if (token.indexOf("=") > -1) {
                name = token.substring(0, token.indexOf("="));
            }
            if (temp.contains(type = ModifierType.valueOf(name))) {
                throw new IllegalArgumentException("invalid order string " + temp);
            }
            temp.add(type);
            if (token.indexOf("=") > -1) {
                name = token.substring(token.indexOf("=") + 1);
                type.setSort(Boolean.valueOf(name));
            } else {
                type.setSort(true);
            }
            buf.append(token);
            buf.append(DELIMETER);
        }
        if (_order.size() != temp.size()) {
            throw new IllegalArgumentException("invalid order string " + temp);
        }
        if (!(temp.contains(PUBLIC) && temp.contains(PROTECTED) && temp.contains(PRIVATE) && temp.contains(STATIC) && temp.contains(FINAL) && temp.contains(ABSTRACT) && temp.contains(SYNCHRONIZED) && temp.contains(TRANSIENT) && temp.contains(VOLATILE) && temp.contains(STRICTFP) && temp.contains(NATIVE))) {
            throw new IllegalArgumentException("invalid order string " + temp);
        }
        _order = Collections.unmodifiableList(temp);
        buf.deleteCharAt(buf.length() - 1);
        _sortOrder = buf.toString();
    }

    private void setSort(boolean sortOption) {
        this.sortOption = sortOption;
    }

    public boolean getSort() {
        return this.sortOption;
    }

    public static synchronized String getOrder() {
        return _sortOrder;
    }

    public int compareTo(Object other) {
        if (other == this) {
            return 0;
        }
        if (other instanceof ModifierType) {
            int otherIndex;
            int thisIndex = _order.indexOf(this);
            if (thisIndex > (otherIndex = _order.indexOf(other))) {
                return 1;
            }
            if (thisIndex < otherIndex) {
                return -1;
            }
            return 0;
        }
        throw new ClassCastException(other == null ? "null" : other.getClass().getName());
    }

    public String toString() {
        return this._name;
    }

    public boolean shouldSort(int mod) {
        boolean result = true;
        ModifierType mt = ModifierType.valueOf(mod);
        while (mt != null) {
            result = mt.getSort();
            mt = (mod = mt.getChildModifierType(mod)) > -1 ? ModifierType.valueOf(mod) : null;
        }
        return result;
    }

    private int getChildModifierType(int mod) {
        int result = -1;
        switch (this._key) {
            case 16: {
                result = mod & 0xFFFFFFEF;
                break;
            }
            case 8: {
                result = mod & 0xFFFFFFF7;
                break;
            }
            case 1024: {
                result = mod & 0xFFFFFBFF;
                break;
            }
            case 32: {
                result = mod & 0xFFFFFFDF;
                break;
            }
            case 128: {
                result = mod & 0xFFFFFF7F;
                break;
            }
            case 64: {
                result = mod & 0xFFFFFFBF;
                break;
            }
            case 256: {
                result = mod & 0xFFFFFEFF;
                break;
            }
            case 2048: {
                result = mod & 0xFFFFF7FF;
                break;
            }
            case 2: {
                result = mod & 0xFFFFFFFD;
                break;
            }
            case 1: {
                result = mod & 0xFFFFFFFE;
                break;
            }
            case 4: {
                result = mod & 0xFFFFFFFB;
                break;
            }
            default: {
                result = -1;
            }
        }
        return result;
    }

    public static final ModifierType valueOf(int mod) {
        if (Modifier.isFinal(mod)) {
            return FINAL;
        }
        if (Modifier.isStatic(mod)) {
            return STATIC;
        }
        if (Modifier.isAbstract(mod)) {
            return ABSTRACT;
        }
        if (Modifier.isSynchronized(mod)) {
            return SYNCHRONIZED;
        }
        if (Modifier.isTransient(mod)) {
            return TRANSIENT;
        }
        if (Modifier.isVolatile(mod)) {
            return VOLATILE;
        }
        if (Modifier.isNative(mod)) {
            return NATIVE;
        }
        if (Modifier.isStrict(mod)) {
            return STRICTFP;
        }
        if (Modifier.isPublic(mod)) {
            return PUBLIC;
        }
        if (Modifier.isProtected(mod)) {
            return PROTECTED;
        }
        if (Modifier.isPrivate(mod)) {
            return PRIVATE;
        }
        return null;
    }

    public static ModifierType valueOf(String name) {
        boolean value = true;
        if (name.indexOf("=") > -1) {
            String svalue = name.substring(name.indexOf("=") + 1);
            value = Boolean.valueOf(svalue);
            name = name.substring(0, name.indexOf("="));
        }
        ModifierType returnValue = ModifierType.valueOfm(name);
        returnValue.setSort(value);
        return returnValue;
    }

    private static ModifierType valueOfm(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("invalid modifier -- " + name);
        }
        if (ModifierType.PUBLIC._name.equals(name = name.trim())) {
            return PUBLIC;
        }
        if (ModifierType.PRIVATE._name.equals(name)) {
            return PRIVATE;
        }
        if (ModifierType.PROTECTED._name.equals(name)) {
            return PROTECTED;
        }
        if (ModifierType.FINAL._name.equals(name)) {
            return FINAL;
        }
        if (ModifierType.STATIC._name.equals(name)) {
            return STATIC;
        }
        if (ModifierType.ABSTRACT._name.equals(name)) {
            return ABSTRACT;
        }
        if (ModifierType.SYNCHRONIZED._name.equals(name)) {
            return SYNCHRONIZED;
        }
        if (ModifierType.TRANSIENT._name.equals(name)) {
            return TRANSIENT;
        }
        if (ModifierType.VOLATILE._name.equals(name)) {
            return VOLATILE;
        }
        if (ModifierType.STRICTFP._name.equals(name)) {
            return STRICTFP;
        }
        if (ModifierType.NATIVE._name.equals(name)) {
            return NATIVE;
        }
        throw new IllegalArgumentException("invalid modifier -- " + name);
    }
}

