/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import antlr.RecognitionException;
import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import antlr.collections.AST;
import de.hunsicker.io.FileFormat;
import de.hunsicker.jalopy.language.Lexer;
import de.hunsicker.jalopy.language.Parser;
import de.hunsicker.util.ChainingRuntimeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class Recognizer {
    public static final String UNKNOWN_FILE = "<unknown>";
    protected Lexer lexer;
    protected Parser parser;
    boolean finished;
    boolean running;
    private int _startColumn;
    private int _startLine;

    public Recognizer(Parser parser, Lexer lexer) {
        this.parser = parser;
        this.lexer = lexer;
    }

    protected Recognizer() {
    }

    public void setColumn(int column) {
        this.lexer.setColumn(column);
    }

    public int getColumn() {
        return this.lexer.getColumn();
    }

    public FileFormat getFileFormat() {
        if (!this.finished) {
            throw new IllegalStateException("nothing parsed yet");
        }
        return this.lexer.getFileFormat();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public void setLine(int line) {
        this.lexer.setLine(line);
    }

    public int getLine() {
        return this.lexer.getLine();
    }

    public AST getParseTree() {
        return this.parser.getParseTree();
    }

    public Parser getParser() {
        return this.parser;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void parse(Reader in, String filename) {
        if (this.running) {
            throw new IllegalStateException("parser already running");
        }
        this.finished = false;
        this.running = true;
        this._startLine = this.lexer.getLine();
        this._startColumn = this.lexer.getColumn();
        this.lexer.setInputBuffer(in);
        this.lexer.setFilename(filename);
        this.parser.setTokenBuffer(new TokenBuffer(this.lexer));
        this.parser.setFilename(filename);
        try {
            try {
                this.parser.parse();
            }
            catch (RecognitionException ex) {
                throw new ParseException(ex);
            }
            catch (TokenStreamRecognitionException ex) {
                throw new ParseException(ex);
            }
            catch (TokenStreamException ex) {
                throw new ParseException(ex);
            }
        }
        finally {
            this.finished = true;
            this.running = false;
        }
    }

    public void parse(File file) {
        block15: {
            if (file.exists() && file.isFile()) {
                BufferedReader in = null;
                try {
                    try {
                        in = new BufferedReader(new FileReader(file));
                        this.parse(in, file.getAbsolutePath());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void parse(String str, String filename) throws IOException {
        BufferedReader in = new BufferedReader(new StringReader(str));
        this.parse(in, filename);
        in.close();
    }

    public void reset() {
        this.running = false;
        this.finished = false;
        this.lexer.reset();
        this.parser.reset();
    }

    public int getStartColumn() {
        return this._startColumn;
    }

    public int getStartLine() {
        return this._startLine;
    }

    public void set_startLine(int line) {
        this._startLine = line;
    }

    public static final class ParseException
    extends ChainingRuntimeException {
        public ParseException(Throwable cause) {
            super(cause);
        }
    }
}

