/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.OperatorPrinter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

class InfixOperatorPrinter
extends OperatorPrinter {
    protected InfixOperatorPrinter() {
    }

    public void print(AST node, NodeWriter out) throws IOException {
        this.print(node, true, out);
    }

    public void print(AST node, boolean paddOperator, NodeWriter out) throws IOException {
        AST lhsLeftParen = null;
        AST lhsRightParen = null;
        JavaNode lhs = null;
        JavaNode rhs = null;
        int count = 0;
        AST child = node.getFirstChild();
        block8: while (child != null) {
            switch (child.getType()) {
                case 108: {
                    if (count == 0) {
                        lhsLeftParen = child;
                    }
                    ++count;
                    break;
                }
                case 109: {
                    if (--count != 0) break;
                    lhsRightParen = child;
                    rhs = (JavaNode)child.getNextSibling();
                    break block8;
                }
                default: {
                    lhs = (JavaNode)child;
                    if (count != 0) break;
                    rhs = (JavaNode)child.getNextSibling();
                    break block8;
                }
            }
            child = child.getNextSibling();
        }
        JavaNode rhsLeftParen = null;
        AST rhsRightParen = null;
        count = 0;
        AST child2 = rhs;
        while (child2 != null) {
            switch (child2.getType()) {
                case 108: {
                    if (count == 0) {
                        rhsLeftParen = child2;
                    }
                    ++count;
                    break;
                }
                case 109: {
                    if (--count != 0) break;
                    rhsRightParen = child2;
                    break;
                }
                default: {
                    rhs = child2;
                }
            }
            child2 = child2.getNextSibling();
        }
        boolean wrapLines = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP, true);
        boolean wrap = false;
        if (lhsLeftParen != null && rhsLeftParen != null) {
            wrap = InfixOperatorPrinter.canWrap(node, out);
            this.printImpl((JavaNode)node, lhs, rhs, lhsLeftParen, lhsRightParen, rhsLeftParen, rhsRightParen, wrapLines && wrap, paddOperator, out);
        } else {
            boolean insertParentheses = AbstractPrinter.settings.getBoolean(ConventionKeys.INSERT_EXPRESSION_PARENTHESIS, true);
            if (insertParentheses) {
                if (lhsLeftParen == null && this.getPrecedence(lhs) > this.getPrecedence(node)) {
                    if (out.mode == 1) {
                        this.addParentheses(lhs, out);
                        lhsLeftParen = lhs.getPreviousSibling();
                        lhsRightParen = lhs.getNextSibling();
                    } else {
                        out.print("(", out.last);
                        out.print(")", out.last);
                    }
                }
                if (rhsLeftParen == null && this.getPrecedence(rhs) > this.getPrecedence(node)) {
                    if (out.mode == 1) {
                        this.addParentheses(rhs, out);
                        rhsLeftParen = rhs.getPreviousSibling();
                        rhsRightParen = rhs.getNextSibling();
                    } else {
                        out.print("(", out.last);
                        out.print(")", out.last);
                    }
                }
            }
            if (wrapLines) {
                wrap = InfixOperatorPrinter.canWrap(node, out);
            }
            this.printImpl((JavaNode)node, lhs, rhs, lhsLeftParen, lhsRightParen, rhsLeftParen, rhsRightParen, wrapLines && wrap, paddOperator, out);
        }
    }

    private void printImpl(JavaNode operator, JavaNode lhs, JavaNode rhs, AST lhsLeftParen, AST lhsRightParen, AST rhsLeftParen, AST rhsRightParen, boolean wrapLines, boolean paddOperator, NodeWriter out) throws IOException {
        boolean wrapBeforeOperator;
        boolean wrapped;
        boolean continuationIndent;
        boolean continuation;
        block36: {
            TestNodeWriter tester;
            block37: {
                block35: {
                    if (lhsLeftParen == null) {
                        PrinterFactory.create(lhs, out).print(lhs, out);
                    } else {
                        this.printWithParentheses(lhs, lhsLeftParen, lhsRightParen, out);
                    }
                    continuation = out.continuation;
                    continuationIndent = AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_CONTINUATION_OPERATOR, false);
                    if (continuationIndent && !continuation) {
                        switch (operator.getType()) {
                            case 157: 
                            case 158: {
                                break;
                            }
                            default: {
                                out.continuation = true;
                            }
                        }
                    }
                    wrapped = false;
                    if (out.newline) {
                        wrapped = true;
                        this.printIndentation(out);
                    }
                    wrapBeforeOperator = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_OPERATOR, false);
                    boolean commentAfter = operator.hasCommentsAfter();
                    if (!wrapBeforeOperator) {
                        if (this.printCommentsBefore(operator, false, out) && out.newline) {
                            this.printIndentation(out);
                        }
                        if (paddOperator) {
                            out.print(" ", 175);
                            out.print(operator.getText(), operator.getType());
                        } else {
                            out.print(operator.getText(), operator.getType());
                        }
                    }
                    if (!commentAfter) break block35;
                    this.printCommentsAfter(operator, false, true, out);
                    wrapped = true;
                    this.printIndentation(out);
                    break block36;
                }
                if (!wrapLines) break block36;
                boolean wrapAll = false;
                if (!out.state.parenScope.isEmpty()) {
                    ParenthesesScope scope = (ParenthesesScope)out.state.parenScope.getFirst();
                    wrapAll = scope.wrap;
                }
                if (!wrapAll) break block37;
                switch (operator.getType()) {
                    case 157: 
                    case 158: {
                        if (!wrapped) {
                            tester = out.testers.get();
                            PrinterFactory.create(rhs, out).print(rhs, tester);
                            wrapped = this.performWrap(tester.length + (rhsLeftParen != null ? 2 : 0), operator, wrapBeforeOperator, paddOperator, out);
                            out.testers.release(tester);
                            break;
                        }
                        break block36;
                    }
                    default: {
                        out.printNewline();
                        this.printIndentation(out);
                        wrapped = true;
                        break;
                    }
                }
                break block36;
            }
            if (!wrapped) {
                tester = out.testers.get();
                PrinterFactory.create(rhs, out).print(rhs, tester);
                wrapped = this.performWrap(tester.length + (rhsLeftParen != null ? 2 : 0), operator, wrapBeforeOperator, paddOperator, out);
                out.testers.release(tester);
            }
        }
        if (wrapBeforeOperator) {
            if (this.printCommentsBefore(operator, false, out) && out.newline) {
                this.printIndentation(out);
            }
            if (paddOperator) {
                if (!wrapped) {
                    out.print(" ", 175);
                }
                out.print(operator.getText(), operator.getType());
                out.print(" ", 175);
            } else {
                out.print(operator.getText(), operator.getType());
            }
        } else if (paddOperator && !wrapped) {
            out.print(" ", 175);
        }
        if (rhsLeftParen == null) {
            PrinterFactory.create(rhs, out).print(rhs, out);
        } else {
            this.printWithParentheses(rhs, rhsLeftParen, rhsRightParen, out);
        }
        if (rhs.hasCommentsAfter()) {
            JavaNode parent = operator.getParent();
            block6 : switch (parent.getType()) {
                case 33: {
                    AST next = parent.getNextSibling();
                    if (next != null) {
                        switch (next.getType()) {
                            case 109: {
                                break block6;
                            }
                        }
                        this.printIndentation(out);
                        break;
                    }
                    this.printIndentation(out);
                }
            }
        }
        if (continuationIndent && !continuation) {
            out.continuation = false;
        }
    }
}

