/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.CommonHiddenStreamToken;
import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.antlr.ExtendedToken;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Environment;
import de.hunsicker.jalopy.storage.History;
import de.hunsicker.util.StringHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

final class JavaPrinter
extends AbstractPrinter {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Printer INSTANCE = new JavaPrinter();
    private static final String DELIMETER = "|";

    protected JavaPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        out.environment.set(Environment.Variable.CONVENTION.getName(), AbstractPrinter.settings.get(ConventionKeys.CONVENTION_NAME, "Sun"));
        try {
            History.Policy historyPolicy = History.Policy.valueOf(AbstractPrinter.settings.get(ConventionKeys.HISTORY_POLICY, ConventionDefaults.HISTORY_POLICY));
            boolean useCommentHistory = historyPolicy == History.Policy.COMMENT;
            boolean useHeader = AbstractPrinter.settings.getBoolean(ConventionKeys.HEADER, false);
            boolean ignoreHeaderIfExists = AbstractPrinter.settings.getBoolean(ConventionKeys.HEADER_IGNORE_IF_EXISTS, true);
            if (useHeader && !ignoreHeaderIfExists || useCommentHistory) {
                this.removeHeader(node, useCommentHistory);
            }
            if (!(!useHeader || ignoreHeaderIfExists && this.headerExists(node))) {
                this.printHeader(out);
            }
            boolean useFooter = AbstractPrinter.settings.getBoolean(ConventionKeys.FOOTER, false);
            boolean ignoreFooterIfExists = AbstractPrinter.settings.getBoolean(ConventionKeys.FOOTER_IGNORE_IF_EXISTS, true);
            if (useFooter && !ignoreFooterIfExists) {
                this.removeFooter(node);
            }
            AST child = node.getFirstChild();
            while (child != null) {
                PrinterFactory.create(child, out).print(child, out);
                child = child.getNextSibling();
            }
            if (!(!useFooter || ignoreFooterIfExists && this.footerExists(node))) {
                this.printFooter(out);
            }
        }
        finally {
            out.environment.unset(Environment.Variable.CONVENTION.getName());
        }
    }

    private String[] getConventionKeys(Convention.Key key) {
        ArrayList<Object> keys = new ArrayList<Object>();
        String str = AbstractPrinter.settings.get(key, EMPTY_STRING);
        StringTokenizer tokens = new StringTokenizer(str, DELIMETER);
        while (tokens.hasMoreElements()) {
            keys.add(tokens.nextElement());
        }
        return keys.toArray(EMPTY_STRING_ARRAY);
    }

    private JavaNode getLastElement(AST root) {
        AST declaration = root.getFirstChild();
        while (declaration != null) {
            if (declaration.getNextSibling() == null) {
                switch (declaration.getType()) {
                    case 19: 
                    case 20: {
                        AST block = JavaNodeHelper.getFirstChild(declaration, 11);
                        AST element = block.getFirstChild();
                        while (element != null) {
                            if (element.getNextSibling() == null) {
                                switch (element.getType()) {
                                    case 8: {
                                        return (JavaNode)element;
                                    }
                                }
                            }
                            element = element.getNextSibling();
                        }
                        break;
                    }
                    case 1: 
                    case 74: {
                        return (JavaNode)declaration;
                    }
                    case 21: 
                    case 35: {
                        return (JavaNode)declaration;
                    }
                }
            }
            declaration = declaration.getNextSibling();
        }
        throw new IllegalStateException("invalid AST -- " + root);
    }

    private void printFooter(NodeWriter out) throws IOException {
        String text = out.environment.interpolate(AbstractPrinter.settings.get(ConventionKeys.FOOTER_TEXT, EMPTY_STRING));
        String[] footer = StringHelper.split(text, DELIMETER);
        if (footer.length > 0) {
            switch (out.last) {
                case 8: 
                case 11: 
                case 19: 
                case 20: {
                    out.printNewline();
                }
            }
            out.printBlankLines(AbstractPrinter.settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_FOOTER, 1));
            int i = 0;
            while (i < footer.length) {
                out.print(footer[i], 178);
                if (i < footer.length - 1) {
                    out.printNewline();
                }
                ++i;
            }
            int blankLinesAfter = AbstractPrinter.settings.getInt(ConventionKeys.BLANK_LINES_AFTER_FOOTER, 1);
            if (blankLinesAfter == 0) {
                blankLinesAfter = 1;
            }
            out.printBlankLines(blankLinesAfter);
        }
    }

    private void printHeader(NodeWriter out) throws IOException {
        String text = out.environment.interpolate(AbstractPrinter.settings.get(ConventionKeys.HEADER_TEXT, EMPTY_STRING));
        String[] header = StringHelper.split(text, DELIMETER);
        if (header.length > 0) {
            out.printBlankLines(AbstractPrinter.settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_HEADER, 0));
            int i = 0;
            while (i < header.length) {
                out.print(header[i], 178);
                out.printNewline();
                ++i;
            }
            out.printBlankLines(AbstractPrinter.settings.getInt(ConventionKeys.BLANK_LINES_AFTER_HEADER, 0));
            out.last = 178;
        }
    }

    private void removeFooter(AST root) {
        JavaNode eofNode = this.getLastElement(root);
        if (eofNode.hasCommentsBefore()) {
            String[] keys = this.getConventionKeys(ConventionKeys.FOOTER_KEYS);
            int count = 0;
            int smartModeLines = AbstractPrinter.settings.getInt(ConventionKeys.FOOTER_SMART_MODE_LINES, 0);
            boolean smartMode = smartModeLines > 0;
            CommonHiddenStreamToken comment = eofNode.getHiddenBefore();
            while (comment != null) {
                switch (comment.getType()) {
                    case 69: 
                    case 72: 
                    case 176: {
                        if (smartMode && count < smartModeLines) {
                            this.removeFooterComment(comment, eofNode);
                        }
                        ++count;
                        break;
                    }
                    default: {
                        int j = 0;
                        while (j < keys.length) {
                            if (comment.getText().indexOf(keys[j]) > -1) {
                                this.removeFooterComment(comment, eofNode);
                            }
                            ++j;
                        }
                        break block0;
                    }
                }
                comment = comment.getHiddenBefore();
            }
        }
    }

    private void removeFooterComment(CommonHiddenStreamToken comment, JavaNode node) {
        CommonHiddenStreamToken before = comment.getHiddenBefore();
        CommonHiddenStreamToken after = comment.getHiddenAfter();
        if (after != null) {
            ((ExtendedToken)after).setHiddenBefore(before);
            if (before != null) {
                ((ExtendedToken)before).setHiddenAfter(after);
            } else {
                node.setHiddenBefore(after);
            }
        } else if (before != null && comment != node.getHiddenAfter()) {
            ((ExtendedToken)before).setHiddenAfter(after);
            if (after != null) {
                ((ExtendedToken)after).setHiddenBefore(before);
            }
        } else {
            node.setHiddenBefore(null);
        }
    }

    private boolean footerExists(AST root) {
        JavaNode eofNode = this.getLastElement(root);
        return eofNode.hasCommentsBefore();
    }

    private boolean headerExists(AST node) {
        JavaNode first = (JavaNode)node.getFirstChild();
        return first.hasCommentsBefore();
    }

    private void removeHeader(AST node, boolean useCommentHistory) {
        JavaNode first = (JavaNode)node.getFirstChild();
        String[] keys = this.getConventionKeys(ConventionKeys.HEADER_KEYS);
        int smartModeLines = AbstractPrinter.settings.getInt(ConventionKeys.HEADER_SMART_MODE_LINES, 0);
        boolean smartMode = smartModeLines > 0;
        int count = 0;
        CommonHiddenStreamToken token = first.getHiddenBefore();
        while (token != null) {
            if (token.getHiddenBefore() == null) {
                CommonHiddenStreamToken comment = token;
                while (comment != null && count <= smartModeLines) {
                    switch (comment.getType()) {
                        case 6: 
                        case 178: {
                            int j = 0;
                            while (j < keys.length) {
                                if (comment.getText().indexOf(keys[j]) > -1) {
                                    this.removeHeaderComment(comment, first);
                                }
                                ++j;
                            }
                            break;
                        }
                        case 176: {
                            if (comment.getText().indexOf(37) > -1) {
                                this.removeHeaderComment(comment, first);
                                break;
                            }
                            if (!smartMode || count >= smartModeLines) break;
                            this.removeHeaderComment(comment, first);
                        }
                    }
                    ++count;
                    comment = comment.getHiddenAfter();
                }
                break;
            }
            token = token.getHiddenBefore();
        }
    }

    private void removeHeaderComment(CommonHiddenStreamToken comment, JavaNode node) {
        CommonHiddenStreamToken before = comment.getHiddenBefore();
        CommonHiddenStreamToken after = comment.getHiddenAfter();
        if (after != null) {
            ((ExtendedToken)after).setHiddenBefore(before);
            if (before != null) {
                ((ExtendedToken)before).setHiddenAfter(after);
            }
        } else if (before != null) {
            ((ExtendedToken)before).setHiddenAfter(after);
            if (after != null) {
                ((ExtendedToken)after).setHiddenBefore(before);
            }
        } else if (comment == node.getHiddenBefore()) {
            node.setHiddenBefore(null);
        }
    }
}

