/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.storage;

import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.util.ResourceBundleFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class Loggers {
    public static final Logger ALL = Logger.getLogger((String)"de.hunsicker.jalopy");
    public static final Logger IO = Logger.getLogger((String)"de.hunsicker.jalopy.io");
    public static final Logger PARSER = Logger.getLogger((String)"de.hunsicker.jalopy.language.java");
    public static final Logger PARSER_JAVADOC = Logger.getLogger((String)"de.hunsicker.jalopy.language.javadoc");
    public static final Logger PRINTER = Logger.getLogger((String)"de.hunsicker.jalopy.printer");
    public static final Logger PRINTER_JAVADOC = Logger.getLogger((String)"de.hunsicker.jalopy.printerjavadoc");
    public static final Logger TRANSFORM = Logger.getLogger((String)"de.hunsicker.jalopy.transform");
    private static Map _config;

    private Loggers() {
    }

    public static void setLocale(Locale locale) {
    }

    public static synchronized void disable() {
        if (_config == null) {
            _config = new HashMap();
        }
        Enumeration i = LogManager.getCurrentLoggers();
        while (i.hasMoreElements()) {
            Logger logger = (Logger)i.nextElement();
            if (logger == ALL) continue;
            ArrayList appenders = Collections.EMPTY_LIST;
            Enumeration j = logger.getAllAppenders();
            while (j.hasMoreElements()) {
                if (appenders == Collections.EMPTY_LIST) {
                    appenders = new ArrayList(4);
                }
                appenders.add(j.nextElement());
            }
            _config.put(logger, appenders);
            logger.removeAllAppenders();
        }
    }

    public static void dumpAppenders(Logger logger) {
        System.out.println("Appenders for " + logger.getName() + ":");
        Enumeration i = logger.getAllAppenders();
        while (i.hasMoreElements()) {
            System.out.println("    " + i.nextElement());
        }
    }

    public static synchronized void enable() {
        if (_config != null) {
            for (Map.Entry entry : _config.entrySet()) {
                Logger logger = (Logger)entry.getKey();
                List appenders = (List)entry.getValue();
                int j = 0;
                int size = appenders.size();
                while (j < size) {
                    Appender appender = (Appender)appenders.get(j);
                    logger.addAppender(appender);
                    ++j;
                }
            }
            _config.clear();
        }
    }

    public static synchronized void initialize(Appender appender) {
        Convention settings = Convention.getInstance();
        ResourceBundle bundle = ResourceBundleFactory.getBundle("de.hunsicker.jalopy.storage.Bundle");
        ALL.setResourceBundle(bundle);
        Loggers.initialize(IO, appender);
        Loggers.initialize(PARSER, appender);
        Loggers.initialize(PARSER_JAVADOC, appender);
        Loggers.initialize(TRANSFORM, appender);
        Loggers.initialize(PRINTER, appender);
        Loggers.initialize(PRINTER_JAVADOC, appender);
        IO.setLevel(Level.toLevel((int)settings.getInt(ConventionKeys.MSG_PRIORITY_IO, ConventionDefaults.MSG_PRIORITY_IO)));
        PARSER.setLevel(Level.toLevel((int)settings.getInt(ConventionKeys.MSG_PRIORITY_PARSER, ConventionDefaults.MSG_PRIORITY_PARSER)));
        PARSER_JAVADOC.setLevel(Level.toLevel((int)settings.getInt(ConventionKeys.MSG_PRIORITY_PARSER_JAVADOC, ConventionDefaults.MSG_PRIORITY_PARSER_JAVADOC)));
        TRANSFORM.setLevel(Level.toLevel((int)settings.getInt(ConventionKeys.MSG_PRIORITY_TRANSFORM, ConventionDefaults.MSG_PRIORITY_TRANSFORM)));
        PRINTER.setLevel(Level.toLevel((int)settings.getInt(ConventionKeys.MSG_PRIORITY_PRINTER_JAVADOC, ConventionDefaults.MSG_PRIORITY_PRINTER_JAVADOC)));
        PRINTER_JAVADOC.setLevel(Level.toLevel((int)settings.getInt(ConventionKeys.MSG_PRIORITY_PRINTER, ConventionDefaults.MSG_PRIORITY_PRINTER)));
    }

    private static void initialize(Logger logger, Appender appender) {
        logger.removeAllAppenders();
        logger.addAppender(appender);
        logger.setLevel(Level.WARN);
    }
}

