/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.swing.util.SwingHelper;
import de.hunsicker.util.ResourceBundleFactory;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class AddRemoveList
extends JList {
    protected DefaultListModel listModel;
    protected JButton addButton;
    protected JButton removeButton;
    protected ResourceBundle bundle;
    protected String text;
    protected String title;

    public AddRemoveList(String title, String text, Collection data) {
        this.listModel = new DefaultListModel();
        this.title = title;
        this.text = text;
        Iterator i = data.iterator();
        while (i.hasNext()) {
            this.listModel.addElement(i.next());
        }
        this.setModel(this.listModel);
        this.initialize();
    }

    public AddRemoveList(String title, Object[] data) {
        this.title = title;
        this.listModel = new DefaultListModel();
        int i = 0;
        while (i < data.length) {
            this.listModel.addElement(data[i]);
            ++i;
        }
        this.setModel(this.listModel);
        this.initialize();
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (!enable) {
            this.clearSelection();
        }
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public Object[] getValues() {
        return this.listModel.toArray();
    }

    public Object[] toArray() {
        return this.listModel.toArray();
    }

    protected JDialog getAddDialog(Dialog owner) {
        return new AddDialog(owner, this.title, this.text);
    }

    protected JDialog getAddDialog(Frame owner) {
        return new AddDialog(owner, this.title, this.text);
    }

    private void initialize() {
        this.bundle = ResourceBundleFactory.getBundle("de.hunsicker.jalopy.swing.Bundle");
        this.addButton = SwingHelper.createButton(this.bundle.getString("BTN_DLG_ADD"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDialog dialog = null;
                Window owner = SwingUtilities.windowForComponent(AddRemoveList.this);
                dialog = owner instanceof Dialog ? AddRemoveList.this.getAddDialog((Dialog)owner) : AddRemoveList.this.getAddDialog((Frame)owner);
                dialog.pack();
                dialog.setLocationRelativeTo(owner);
                dialog.setVisible(true);
                dialog.dispose();
            }
        });
        this.removeButton = SwingHelper.createButton(this.bundle.getString("BTN_REMOVE"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = AddRemoveList.this.getSelectedIndex();
                if (index > -1) {
                    AddRemoveList.this.listModel.remove(index);
                }
                if (AddRemoveList.this.listModel.isEmpty()) {
                    AddRemoveList.this.removeButton.setEnabled(false);
                } else if (index >= AddRemoveList.this.listModel.getSize()) {
                    AddRemoveList.this.setSelectedIndex(index - 1);
                } else {
                    AddRemoveList.this.setSelectedIndex(index);
                }
            }
        });
        this.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                if (ev.getValueIsAdjusting()) {
                    return;
                }
                if (ev.getFirstIndex() > -1) {
                    AddRemoveList.this.removeButton.setEnabled(true);
                } else {
                    AddRemoveList.this.removeButton.setEnabled(false);
                }
            }
        });
    }

    private class AddDialog
    extends JDialog {
        public AddDialog(Frame owner, String title, String text) {
            super(owner);
            this.initialize(title, text);
        }

        public AddDialog(Dialog owner, String title, String text) {
            super(owner);
            this.initialize(title, text);
        }

        private void initialize(String newTitle, String newText) {
            this.setTitle(newTitle);
            this.setModal(true);
            this.setDefaultCloseOperation(2);
            Container contentPane = this.getContentPane();
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            contentPane.setLayout(layout);
            JLabel valueLabel = new JLabel(newText);
            c.insets.top = 10;
            c.insets.left = 5;
            c.insets.right = 5;
            SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
            layout.setConstraints(valueLabel, c);
            contentPane.add(valueLabel);
            final JTextField valueTextField = new JTextField(20);
            valueLabel.setLabelFor(valueTextField);
            c.insets.top = 2;
            SwingHelper.setConstraints(c, 0, 1, 12, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
            layout.setConstraints(valueTextField, c);
            contentPane.add(valueTextField);
            JButton cancelButton = SwingHelper.createButton(AddRemoveList.this.bundle.getString("BTN_CANCEL"));
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AddDialog.this.setVisible(false);
                    AddDialog.this.dispose();
                }
            });
            JButton okButton = SwingHelper.createButton(AddRemoveList.this.bundle.getString("BTN_OK"));
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String value = valueTextField.getText();
                    if (((AddDialog)AddDialog.this).AddRemoveList.this.listModel.contains(value)) {
                        return;
                    }
                    try {
                        ((AddDialog)AddDialog.this).AddRemoveList.this.listModel.add(0, value);
                    }
                    catch (RuntimeException runtimeException) {
                        if (((AddDialog)AddDialog.this).AddRemoveList.this.listModel.contains(value)) {
                            ((AddDialog)AddDialog.this).AddRemoveList.this.listModel.remove(0);
                        }
                        return;
                    }
                    AddRemoveList.this.setSelectedValue(value, false);
                    AddDialog.this.dispose();
                }
            });
            this.getRootPane().setDefaultButton(okButton);
            c.insets.top = 15;
            c.insets.bottom = 5;
            SwingHelper.setConstraints(c, 9, 2, 1, 1, 1.0, 0.0, 13, 0, c.insets, 0, 0);
            layout.setConstraints(okButton, c);
            contentPane.add(okButton);
            c.insets.left = 0;
            SwingHelper.setConstraints(c, 11, 2, 0, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
            layout.setConstraints(cancelButton, c);
            contentPane.add(cancelButton);
        }
    }
}

