/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.NumberComboBoxPanel;
import de.hunsicker.jalopy.swing.NumberComboBoxPanelCheckBox;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.swing.EmptyButtonGroup;
import de.hunsicker.swing.util.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BracesSettingsPage
extends AbstractSettingsPage {
    private static final String STYLE_C = "c";
    private static final String STYLE_CUSTOM = "custom";
    private static final String STYLE_GNU = "gnu";
    private static final String STYLE_SUN = "sun";
    private static final String ZERO = "0";
    private static final String TWO = "2";
    private static final String ONE = "1";
    private JCheckBox _cStyleCheckBox;
    private JCheckBox _cuddleEmptyBracesCheckBox;
    private JCheckBox _customStyleCheckBox;
    private JCheckBox _gnuStyleCheckBox;
    private JCheckBox _insertDoWhileCheckBox;
    private JCheckBox _insertEmptyStatementCheckBox;
    private JCheckBox _insertForCheckBox;
    private JCheckBox _insertIfElseCheckBox;
    private JCheckBox _insertWhileCheckBox;
    JCheckBox _newlineLeftCheckBox;
    JCheckBox _newlineRightCheckBox;
    private JCheckBox _removeBlockCheckBox;
    private JCheckBox _removeDoWhileCheckBox;
    private JCheckBox _removeForCheckBox;
    private JCheckBox _removeIfElseCheckBox;
    private JCheckBox _removeWhileCheckBox;
    private JCheckBox _sunStyleCheckBox;
    JCheckBox _treatDifferentCheckBox;
    JCheckBox _treatDifferentIfWrappedCheckBox;
    private JComboBox _cuddleEmptyBracesComboBox;
    JComboBox _indentAfterRightBraceComboBox;
    JComboBox _indentLeftBraceComboBox;
    JComboBox _indentRightBraceComboBox;
    private JTabbedPane _tabbedPane;
    private NumberComboBoxPanel _indentAfterRightBraceComboBoxPnl;
    private NumberComboBoxPanel _indentLeftBraceComboBoxPnl;
    private NumberComboBoxPanel _indentRightBraceComboBoxPnl;

    public BracesSettingsPage() {
        this.initialize();
    }

    BracesSettingsPage(SettingsContainer container) {
        super(container);
        this.initialize();
    }

    public String getPreviewFileName() {
        switch (this._tabbedPane.getSelectedIndex()) {
            case 1: {
                return "bracesmisc";
            }
        }
        return super.getPreviewFileName();
    }

    public void updateSettings() {
        this.settings.putBoolean(ConventionKeys.BRACE_EMPTY_CUDDLE, this._cuddleEmptyBracesCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.BRACE_EMPTY_INSERT_STATEMENT, this._insertEmptyStatementCheckBox.isSelected());
        this.settings.put(ConventionKeys.INDENT_SIZE_BRACE_CUDDLED, (String)this._cuddleEmptyBracesComboBox.getSelectedItem());
        this.settings.putBoolean(ConventionKeys.BRACE_INSERT_IF_ELSE, this._insertIfElseCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.BRACE_INSERT_FOR, this._insertForCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.BRACE_INSERT_DO_WHILE, this._insertDoWhileCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.BRACE_INSERT_WHILE, this._insertWhileCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.BRACE_REMOVE_IF_ELSE, this._removeIfElseCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.BRACE_REMOVE_FOR, this._removeForCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.BRACE_REMOVE_DO_WHILE, this._removeDoWhileCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.BRACE_REMOVE_WHILE, this._removeWhileCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.BRACE_REMOVE_BLOCK, this._removeBlockCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, this._newlineLeftCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.BRACE_TREAT_DIFFERENT, this._treatDifferentCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.BRACE_TREAT_DIFFERENT_IF_WRAPPED, this._treatDifferentIfWrappedCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.BRACE_NEWLINE_RIGHT, this._newlineRightCheckBox.isSelected());
        this.settings.put(ConventionKeys.INDENT_SIZE_BRACE_RIGHT_AFTER, (String)this._indentAfterRightBraceComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.INDENT_SIZE_BRACE_RIGHT, (String)this._indentRightBraceComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.INDENT_SIZE_BRACE_LEFT, (String)this._indentLeftBraceComboBox.getSelectedItem());
    }

    private boolean isCStyle() {
        if (!this._newlineLeftCheckBox.isSelected()) {
            return false;
        }
        if (!this._newlineRightCheckBox.isSelected()) {
            return false;
        }
        if (!ZERO.equals(this._indentLeftBraceComboBox.getSelectedItem())) {
            return false;
        }
        if (!ZERO.equals(this._indentRightBraceComboBox.getSelectedItem())) {
            return false;
        }
        return ZERO.equals(this._indentAfterRightBraceComboBox.getSelectedItem());
    }

    void setCustomMode(boolean enable) {
        this._indentLeftBraceComboBoxPnl.setEnabled(enable);
        this._indentRightBraceComboBoxPnl.setEnabled(enable);
        this._indentAfterRightBraceComboBoxPnl.setEnabled(enable);
        this._newlineLeftCheckBox.setEnabled(enable);
        this._newlineRightCheckBox.setEnabled(enable);
        this._treatDifferentCheckBox.setEnabled(enable);
        this._treatDifferentIfWrappedCheckBox.setEnabled(enable);
    }

    private boolean isGnuStyle() {
        if (!this._newlineLeftCheckBox.isSelected()) {
            return false;
        }
        if (!this._newlineRightCheckBox.isSelected()) {
            return false;
        }
        if (!TWO.equals(this._indentLeftBraceComboBox.getSelectedItem())) {
            return false;
        }
        if (!TWO.equals(this._indentRightBraceComboBox.getSelectedItem())) {
            return false;
        }
        return ZERO.equals(this._indentAfterRightBraceComboBox.getSelectedItem());
    }

    private boolean isSunStyle() {
        if (this._newlineLeftCheckBox.isSelected()) {
            return false;
        }
        if (this._newlineRightCheckBox.isSelected()) {
            return false;
        }
        if (!ONE.equals(this._indentLeftBraceComboBox.getSelectedItem())) {
            return false;
        }
        if (!ZERO.equals(this._indentRightBraceComboBox.getSelectedItem())) {
            return false;
        }
        return ONE.equals(this._indentAfterRightBraceComboBox.getSelectedItem());
    }

    private JPanel createMiscPane() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        Object[] items = this.createItemList(nArray);
        NumberComboBoxPanelCheckBox emptyBraces = new NumberComboBoxPanelCheckBox(this.bundle.getString("CHK_CUDDLE"), this.settings.getBoolean(ConventionKeys.BRACE_EMPTY_CUDDLE, false), this.bundle.getString("LBL_SPACE_BEFORE"), items, this.settings.get(ConventionKeys.INDENT_SIZE_BRACE_CUDDLED, String.valueOf(1)));
        this._cuddleEmptyBracesCheckBox = emptyBraces.getCheckBox();
        this._cuddleEmptyBracesCheckBox.addActionListener(this.trigger);
        this._cuddleEmptyBracesComboBox = emptyBraces.getComboBoxPanel().getComboBox();
        this._cuddleEmptyBracesComboBox.addActionListener(this.trigger);
        JPanel emptyPanel = new JPanel();
        GridBagLayout emptyPanelLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        emptyPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_EMPTY_BRACES")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        emptyPanel.setLayout(emptyPanelLayout);
        this._insertEmptyStatementCheckBox = new JCheckBox(this.bundle.getString("CHK_INSERT_EMPTY"), this.settings.getBoolean(ConventionKeys.BRACE_EMPTY_INSERT_STATEMENT, false));
        this._insertEmptyStatementCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        emptyPanelLayout.setConstraints(this._insertEmptyStatementCheckBox, c);
        emptyPanel.add(this._insertEmptyStatementCheckBox);
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        emptyPanelLayout.setConstraints(emptyBraces, c);
        emptyPanel.add(emptyBraces);
        EmptyButtonGroup emptyButtonGroup = new EmptyButtonGroup();
        emptyButtonGroup.add(this._insertEmptyStatementCheckBox);
        emptyButtonGroup.add(this._cuddleEmptyBracesCheckBox);
        JPanel insertBracesSettingsPage = new JPanel();
        insertBracesSettingsPage.setLayout(new FlowLayout(0, 5, 0));
        insertBracesSettingsPage.setBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_INSERT_BRACES")));
        this._insertIfElseCheckBox = new JCheckBox(this.bundle.getString("CHK_IF_ELSE"), this.settings.getBoolean(ConventionKeys.BRACE_INSERT_IF_ELSE, true));
        this._insertIfElseCheckBox.addActionListener(this.trigger);
        insertBracesSettingsPage.add(this._insertIfElseCheckBox);
        this._insertForCheckBox = new JCheckBox(this.bundle.getString("CHK_FOR"), this.settings.getBoolean(ConventionKeys.BRACE_INSERT_FOR, false));
        this._insertForCheckBox.addActionListener(this.trigger);
        insertBracesSettingsPage.add(this._insertForCheckBox);
        this._insertWhileCheckBox = new JCheckBox(this.bundle.getString("CHK_WHILE"), this.settings.getBoolean(ConventionKeys.BRACE_INSERT_WHILE, false));
        this._insertWhileCheckBox.addActionListener(this.trigger);
        insertBracesSettingsPage.add(this._insertWhileCheckBox);
        this._insertDoWhileCheckBox = new JCheckBox(this.bundle.getString("CHK_DO_WHILE"), this.settings.getBoolean(ConventionKeys.BRACE_INSERT_DO_WHILE, false));
        this._insertDoWhileCheckBox.addActionListener(this.trigger);
        insertBracesSettingsPage.add(this._insertDoWhileCheckBox);
        JPanel removeBracesSettingsPage = new JPanel();
        removeBracesSettingsPage.setLayout(new FlowLayout(0, 5, 0));
        removeBracesSettingsPage.setBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_REMOVE_BRACES")));
        this._removeIfElseCheckBox = new JCheckBox(this.bundle.getString("CHK_IF_ELSE"), this.settings.getBoolean(ConventionKeys.BRACE_REMOVE_IF_ELSE, false));
        this._removeIfElseCheckBox.addActionListener(this.trigger);
        removeBracesSettingsPage.add(this._removeIfElseCheckBox);
        this._removeForCheckBox = new JCheckBox(this.bundle.getString("CHK_FOR"), this.settings.getBoolean(ConventionKeys.BRACE_REMOVE_FOR, false));
        this._removeForCheckBox.addActionListener(this.trigger);
        removeBracesSettingsPage.add(this._removeForCheckBox);
        this._removeWhileCheckBox = new JCheckBox(this.bundle.getString("CHK_WHILE"), this.settings.getBoolean(ConventionKeys.BRACE_REMOVE_WHILE, false));
        this._removeWhileCheckBox.addActionListener(this.trigger);
        removeBracesSettingsPage.add(this._removeWhileCheckBox);
        this._removeDoWhileCheckBox = new JCheckBox(this.bundle.getString("CHK_DO_WHILE"), this.settings.getBoolean(ConventionKeys.BRACE_REMOVE_DO_WHILE, false));
        this._removeDoWhileCheckBox.addActionListener(this.trigger);
        removeBracesSettingsPage.add(this._removeDoWhileCheckBox);
        this._removeBlockCheckBox = new JCheckBox(this.bundle.getString("CHK_BLOCKS"), this.settings.getBoolean(ConventionKeys.BRACE_REMOVE_BLOCK, true));
        this._removeBlockCheckBox.addActionListener(this.trigger);
        removeBracesSettingsPage.add(this._removeBlockCheckBox);
        EmptyButtonGroup ifElseButtonGroup = new EmptyButtonGroup();
        ((ButtonGroup)ifElseButtonGroup).add(this._insertIfElseCheckBox);
        ((ButtonGroup)ifElseButtonGroup).add(this._removeIfElseCheckBox);
        EmptyButtonGroup doWhileButtonGroup = new EmptyButtonGroup();
        ((ButtonGroup)doWhileButtonGroup).add(this._insertDoWhileCheckBox);
        ((ButtonGroup)doWhileButtonGroup).add(this._removeDoWhileCheckBox);
        EmptyButtonGroup forButtonGroup = new EmptyButtonGroup();
        ((ButtonGroup)forButtonGroup).add(this._insertForCheckBox);
        ((ButtonGroup)forButtonGroup).add(this._removeForCheckBox);
        EmptyButtonGroup whileButtonGroup = new EmptyButtonGroup();
        ((ButtonGroup)whileButtonGroup).add(this._insertWhileCheckBox);
        ((ButtonGroup)whileButtonGroup).add(this._removeWhileCheckBox);
        GridBagLayout miscPaneLayout = new GridBagLayout();
        JPanel miscPane = new JPanel();
        miscPane.setLayout(miscPaneLayout);
        c.insets.top = 10;
        c.insets.left = 5;
        c.insets.right = 5;
        c.insets.bottom = 0;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        miscPaneLayout.setConstraints(insertBracesSettingsPage, c);
        miscPane.add(insertBracesSettingsPage);
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        miscPaneLayout.setConstraints(removeBracesSettingsPage, c);
        miscPane.add(removeBracesSettingsPage);
        c.insets.bottom = 10;
        SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        miscPaneLayout.setConstraints(emptyPanel, c);
        miscPane.add(emptyPanel);
        return miscPane;
    }

    private JPanel createStylePane() {
        JPanel alignmentPanel = new JPanel();
        alignmentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_WRAPPING")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        alignmentPanel.setLayout(new BoxLayout(alignmentPanel, 1));
        this._newlineLeftCheckBox = new JCheckBox(this.bundle.getString("CHK_NEWLINE_BEFORE_LEFT"), this.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false));
        this._newlineLeftCheckBox.addActionListener(this.trigger);
        alignmentPanel.add(this._newlineLeftCheckBox);
        this._newlineRightCheckBox = new JCheckBox(this.bundle.getString("CHK_NEWLINE_AFTER_RIGHT"), this.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_RIGHT, false));
        this._newlineRightCheckBox.addActionListener(this.trigger);
        alignmentPanel.add(this._newlineRightCheckBox);
        this._treatDifferentCheckBox = new JCheckBox(this.bundle.getString("CHK_TREAT_DIFFERENT"), this.settings.getBoolean(ConventionKeys.BRACE_TREAT_DIFFERENT, false));
        this._treatDifferentCheckBox.addActionListener(this.trigger);
        alignmentPanel.add(this._treatDifferentCheckBox);
        this._treatDifferentIfWrappedCheckBox = new JCheckBox(this.bundle.getString("CHK_NEWLINE_BEFORE_LEFT_WRAPPED"), this.settings.getBoolean(ConventionKeys.BRACE_TREAT_DIFFERENT_IF_WRAPPED, false));
        this._treatDifferentIfWrappedCheckBox.addActionListener(this.trigger);
        alignmentPanel.add(this._treatDifferentIfWrappedCheckBox);
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        Object[] items = this.createItemList(nArray);
        this._indentLeftBraceComboBoxPnl = new NumberComboBoxPanel(this.bundle.getString("LBL_BEFORE_LEFT_BRACE"), items, this.settings.get(ConventionKeys.INDENT_SIZE_BRACE_LEFT, String.valueOf(1)));
        this._indentLeftBraceComboBox = this._indentLeftBraceComboBoxPnl.getComboBox();
        this._indentLeftBraceComboBox.addActionListener(this.trigger);
        this._indentRightBraceComboBoxPnl = new NumberComboBoxPanel(this.bundle.getString("LBL_BEFORE_RIGHT_BRACE"), items, this.settings.get(ConventionKeys.INDENT_SIZE_BRACE_RIGHT, String.valueOf(0)));
        this._indentRightBraceComboBox = this._indentRightBraceComboBoxPnl.getComboBox();
        this._indentRightBraceComboBox.addActionListener(this.trigger);
        this._indentAfterRightBraceComboBoxPnl = new NumberComboBoxPanel(this.bundle.getString("LBL_AFTER_RIGHT_BRACE"), items, this.settings.get(ConventionKeys.INDENT_SIZE_BRACE_RIGHT_AFTER, String.valueOf(1)));
        this._indentAfterRightBraceComboBox = this._indentAfterRightBraceComboBoxPnl.getComboBox();
        this._indentAfterRightBraceComboBox.addActionListener(this.trigger);
        JPanel stylesPanel = new JPanel();
        stylesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_STYLES")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout stylesLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        stylesPanel.setLayout(stylesLayout);
        this._cStyleCheckBox = new JCheckBox(this.bundle.getString("CHK_C_STYLE"));
        this._cStyleCheckBox.setActionCommand(STYLE_C);
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        stylesLayout.setConstraints(this._cStyleCheckBox, c);
        stylesPanel.add(this._cStyleCheckBox);
        this._sunStyleCheckBox = new JCheckBox(this.bundle.getString("CHK_SUN_STYLE"));
        this._sunStyleCheckBox.setActionCommand(STYLE_SUN);
        SwingHelper.setConstraints(c, 1, 0, 1, 0, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        stylesLayout.setConstraints(this._sunStyleCheckBox, c);
        stylesPanel.add(this._sunStyleCheckBox);
        this._gnuStyleCheckBox = new JCheckBox(this.bundle.getString("CHK_GNU_STYLE"));
        this._gnuStyleCheckBox.setActionCommand(STYLE_GNU);
        SwingHelper.setConstraints(c, 0, 1, 1, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        stylesLayout.setConstraints(this._gnuStyleCheckBox, c);
        stylesPanel.add(this._gnuStyleCheckBox);
        this._customStyleCheckBox = new JCheckBox(this.bundle.getString("CHK_CUSTOM_STYLE"));
        this._customStyleCheckBox.setActionCommand(STYLE_CUSTOM);
        SwingHelper.setConstraints(c, 1, 1, 1, 0, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        stylesLayout.setConstraints(this._customStyleCheckBox, c);
        stylesPanel.add(this._customStyleCheckBox);
        if (this.isSunStyle()) {
            this._sunStyleCheckBox.setSelected(true);
            this.setCustomMode(false);
            this._treatDifferentCheckBox.setEnabled(true);
            this._treatDifferentIfWrappedCheckBox.setEnabled(true);
        } else if (this.isCStyle()) {
            this._cStyleCheckBox.setSelected(true);
            this.setCustomMode(false);
            this._treatDifferentCheckBox.setEnabled(false);
            this._treatDifferentCheckBox.setSelected(false);
        } else if (this.isGnuStyle()) {
            this._gnuStyleCheckBox.setSelected(true);
            this.setCustomMode(false);
            this._treatDifferentCheckBox.setEnabled(true);
        } else {
            this._customStyleCheckBox.setSelected(true);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this._cStyleCheckBox);
        group.add(this._sunStyleCheckBox);
        group.add(this._gnuStyleCheckBox);
        group.add(this._customStyleCheckBox);
        ActionListener buttonHandler = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (ev.getActionCommand() == BracesSettingsPage.STYLE_SUN) {
                    BracesSettingsPage.this.setCustomMode(false);
                    BracesSettingsPage.this._newlineLeftCheckBox.setSelected(false);
                    BracesSettingsPage.this._newlineRightCheckBox.setSelected(false);
                    BracesSettingsPage.this._indentLeftBraceComboBox.setSelectedItem(BracesSettingsPage.ONE);
                    BracesSettingsPage.this._indentRightBraceComboBox.setSelectedItem(BracesSettingsPage.ZERO);
                    BracesSettingsPage.this._indentAfterRightBraceComboBox.setSelectedItem(BracesSettingsPage.ONE);
                    BracesSettingsPage.this._treatDifferentCheckBox.setEnabled(true);
                    BracesSettingsPage.this._treatDifferentIfWrappedCheckBox.setEnabled(true);
                } else if (ev.getActionCommand() == BracesSettingsPage.STYLE_C) {
                    BracesSettingsPage.this.setCustomMode(false);
                    BracesSettingsPage.this._newlineLeftCheckBox.setSelected(true);
                    BracesSettingsPage.this._newlineRightCheckBox.setSelected(true);
                    BracesSettingsPage.this._indentLeftBraceComboBox.setSelectedItem(BracesSettingsPage.ZERO);
                    BracesSettingsPage.this._indentRightBraceComboBox.setSelectedItem(BracesSettingsPage.ZERO);
                    BracesSettingsPage.this._indentAfterRightBraceComboBox.setSelectedItem(BracesSettingsPage.ZERO);
                    BracesSettingsPage.this._treatDifferentCheckBox.setSelected(false);
                    BracesSettingsPage.this._treatDifferentIfWrappedCheckBox.setSelected(false);
                } else if (ev.getActionCommand() == BracesSettingsPage.STYLE_GNU) {
                    BracesSettingsPage.this.setCustomMode(false);
                    BracesSettingsPage.this._newlineLeftCheckBox.setSelected(true);
                    BracesSettingsPage.this._newlineRightCheckBox.setSelected(true);
                    BracesSettingsPage.this._indentLeftBraceComboBox.setSelectedItem(BracesSettingsPage.TWO);
                    BracesSettingsPage.this._indentRightBraceComboBox.setSelectedItem(BracesSettingsPage.TWO);
                    BracesSettingsPage.this._indentAfterRightBraceComboBox.setSelectedItem(BracesSettingsPage.ZERO);
                    BracesSettingsPage.this._treatDifferentCheckBox.setEnabled(true);
                    BracesSettingsPage.this._treatDifferentIfWrappedCheckBox.setSelected(false);
                } else {
                    BracesSettingsPage.this.setCustomMode(true);
                }
            }
        };
        this._cStyleCheckBox.addActionListener(buttonHandler);
        this._sunStyleCheckBox.addActionListener(buttonHandler);
        this._gnuStyleCheckBox.addActionListener(buttonHandler);
        this._customStyleCheckBox.addActionListener(buttonHandler);
        JPanel whitespacePanel = new JPanel();
        whitespacePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_WHITESPACE")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout whitespacePanelLayout = new GridBagLayout();
        whitespacePanel.setLayout(whitespacePanelLayout);
        c.insets.top = 0;
        c.insets.bottom = 0;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        whitespacePanelLayout.setConstraints(this._indentLeftBraceComboBoxPnl, c);
        whitespacePanel.add(this._indentLeftBraceComboBoxPnl);
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        whitespacePanelLayout.setConstraints(this._indentRightBraceComboBoxPnl, c);
        whitespacePanel.add(this._indentRightBraceComboBoxPnl);
        SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        whitespacePanelLayout.setConstraints(this._indentAfterRightBraceComboBoxPnl, c);
        whitespacePanel.add(this._indentAfterRightBraceComboBoxPnl);
        JPanel stylePane = new JPanel();
        GridBagLayout styleLayout = new GridBagLayout();
        stylePane.setLayout(styleLayout);
        c.insets.top = 10;
        c.insets.bottom = 10;
        c.insets.left = 5;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        styleLayout.setConstraints(stylesPanel, c);
        stylePane.add(stylesPanel);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        styleLayout.setConstraints(alignmentPanel, c);
        stylePane.add(alignmentPanel);
        SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        styleLayout.setConstraints(whitespacePanel, c);
        stylePane.add(whitespacePanel);
        return stylePane;
    }

    private void initialize() {
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.add((Component)this.createStylePane(), this.bundle.getString("TAB_GENERAL"));
        this._tabbedPane.add((Component)this.createMiscPane(), this.bundle.getString("TAB_MISC"));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.add((Component)this._tabbedPane, "Center");
        if (this.getContainer() != null) {
            this._tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ev) {
                    String text = BracesSettingsPage.this.getContainer().loadPreview(BracesSettingsPage.this.getPreviewFileName());
                    BracesSettingsPage.this.getContainer().getPreview().setText(text);
                }
            });
        }
    }
}

