/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.AddRemoveList;
import de.hunsicker.jalopy.swing.ComboBoxPanel;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.jalopy.swing.ValidationException;
import de.hunsicker.swing.util.SwingHelper;
import de.hunsicker.util.StringHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class JavadocSettingsPage
extends AbstractSettingsPage {
    private static final int ROW_CLASS = 0;
    private static final int ROW_CTOR = 1;
    private static final int ROW_METHOD = 2;
    private static final int ROW_VARIABLE = 3;
    private static final int COL_PUBLIC = 1;
    private static final int COL_PROTECTED = 2;
    private static final int COL_DEFAULT = 3;
    private static final int COL_PRIVATE = 4;
    private static final String TPL_CLASS = "Class";
    private static final String TPL_INTERFACE = "Interface";
    private static final String TPL_CTOR = "Constructor";
    private static final String TPL_METHOD = "Method";
    private static final String TPL_FIELD = "Field";
    private static final String LINE_SEPARATOR = "\n";
    private AddRemoveList _inlineTagsList;
    private AddRemoveList _standardTagsList;
    private DataModel _tableModel;
    JCheckBox _checkTagsCheckBox;
    JCheckBox _checkThrowsTagsCheckBox;
    JCheckBox _checkDontJavadocIfMlBox;
    private JCheckBox _createInnerCheckBox;
    JCheckBox _parseCheckBox;
    JCheckBox _parseDescriptionCheckBox;
    JCheckBox _singleLineFieldCommentsCheckBox;
    JCheckBox _braceCommentsCheckBox;
    Pattern _bottomTextPattern;
    Pattern _exceptionPattern;
    Pattern _paramPattern;
    Pattern _returnPattern;
    Pattern _tagNamePattern = Pattern.compile("@[a-zA-Z]+");
    Pattern _templatePattern;
    Pattern _topTextPattern = Pattern.compile("\\/\\*\\*(?:.*)+\\n\\s*\\*\\s*(.*)(?:\\n)*");
    TemplateContainer _templatesContainer;
    boolean _disposed;

    public JavadocSettingsPage() {
        this._paramPattern = Pattern.compile("\\s*\\*\\s*@param\\s+\\$paramType\\$.*");
        this._returnPattern = Pattern.compile("\\s*\\*\\s*@return.*");
        this._exceptionPattern = Pattern.compile("\\s*\\*\\s*@(?:throws|exception)\\s+\\$exceptionType\\$.*");
        this._bottomTextPattern = Pattern.compile("\\s*(?:\\*)+/");
        this._templatePattern = Pattern.compile("\\/\\*\\*[^*]*\\*+([^//*][^*]*\\*+)*\\/");
        this.initialize();
    }

    JavadocSettingsPage(SettingsContainer container) {
        super(container);
        this._paramPattern = Pattern.compile("\\s*\\*\\s*@param\\s+\\$paramType\\$.*");
        this._returnPattern = Pattern.compile("\\s*\\*\\s*@return.*");
        this._exceptionPattern = Pattern.compile("\\s*\\*\\s*@(?:throws|exception)\\s+\\$exceptionType\\$.*");
        this._bottomTextPattern = Pattern.compile("\\s*(?:\\*)+/");
        this._templatePattern = Pattern.compile("\\/\\*\\*[^*]*\\*+([^//*][^*]*\\*+)*\\/");
        this.initialize();
    }

    public void dispose() {
        if (!this._disposed) {
            this._inlineTagsList = null;
            this._standardTagsList = null;
            this._tableModel = null;
            this._checkTagsCheckBox = null;
            this._createInnerCheckBox = null;
            this._parseCheckBox = null;
            this._parseDescriptionCheckBox = null;
            this._templatesContainer.dispose();
            this._disposed = true;
        }
    }

    public void updateSettings() {
        int classMask = 0;
        if (((Boolean)this._tableModel.data[0][1]).booleanValue()) {
            ++classMask;
        }
        if (((Boolean)this._tableModel.data[0][2]).booleanValue()) {
            classMask += 4;
        }
        if (((Boolean)this._tableModel.data[0][3]).booleanValue()) {
            classMask += 16;
        }
        if (((Boolean)this._tableModel.data[0][4]).booleanValue()) {
            classMask += 2;
        }
        int ctorMask = 0;
        if (((Boolean)this._tableModel.data[1][1]).booleanValue()) {
            ++ctorMask;
        }
        if (((Boolean)this._tableModel.data[1][2]).booleanValue()) {
            ctorMask += 4;
        }
        if (((Boolean)this._tableModel.data[1][3]).booleanValue()) {
            ctorMask += 16;
        }
        if (((Boolean)this._tableModel.data[1][4]).booleanValue()) {
            ctorMask += 2;
        }
        int methodMask = 0;
        if (((Boolean)this._tableModel.data[2][1]).booleanValue()) {
            ++methodMask;
        }
        if (((Boolean)this._tableModel.data[2][2]).booleanValue()) {
            methodMask += 4;
        }
        if (((Boolean)this._tableModel.data[2][3]).booleanValue()) {
            methodMask += 16;
        }
        if (((Boolean)this._tableModel.data[2][4]).booleanValue()) {
            methodMask += 2;
        }
        int variableMask = 0;
        if (((Boolean)this._tableModel.data[3][1]).booleanValue()) {
            ++variableMask;
        }
        if (((Boolean)this._tableModel.data[3][2]).booleanValue()) {
            variableMask += 4;
        }
        if (((Boolean)this._tableModel.data[3][3]).booleanValue()) {
            variableMask += 16;
        }
        if (((Boolean)this._tableModel.data[3][4]).booleanValue()) {
            variableMask += 2;
        }
        this.settings.putInt(ConventionKeys.COMMENT_JAVADOC_CTOR_MASK, ctorMask);
        this.settings.putInt(ConventionKeys.COMMENT_JAVADOC_METHOD_MASK, methodMask);
        this.settings.putInt(ConventionKeys.COMMENT_JAVADOC_CLASS_MASK, classMask);
        this.settings.putInt(ConventionKeys.COMMENT_JAVADOC_VARIABLE_MASK, variableMask);
        this.settings.putBoolean(ConventionKeys.COMMENT_JAVADOC_FIELDS_SHORT, this._singleLineFieldCommentsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.BRACE_ADD_COMMENT, this._braceCommentsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.COMMENT_JAVADOC_PARSE, this._parseCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.COMMENT_JAVADOC_PARSE_DESCRIPTION, this._parseDescriptionCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.COMMENT_JAVADOC_CHECK_TAGS, this._checkTagsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.COMMENT_JAVADOC_CHECK_TAGS_THROWS, this._checkThrowsTagsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.DONT_COMMENT_JAVADOC_WHEN_ML, this._checkDontJavadocIfMlBox.isSelected());
        this.settings.putBoolean(ConventionKeys.COMMENT_JAVADOC_INNER_CLASS, this._createInnerCheckBox.isSelected());
        this.settings.put(ConventionKeys.COMMENT_JAVADOC_TAGS_STANDARD, this.encodeTags(this._standardTagsList.getValues()));
        this.settings.put(ConventionKeys.COMMENT_JAVADOC_TAGS_INLINE, this.encodeTags(this._inlineTagsList.getValues()));
        this._templatesContainer.updateSettings();
    }

    public void validateSettings() throws ValidationException {
        this._templatesContainer.validateSettings();
    }

    private JPanel createGeneralPane() {
        JPanel generalPanel = new JPanel();
        GridBagLayout generalLayout = new GridBagLayout();
        generalPanel.setLayout(generalLayout);
        generalPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_GENERAL")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints c = new GridBagConstraints();
        this._parseCheckBox = new JCheckBox(this.bundle.getString("CHK_PARSE_COMMENTS"), this.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_PARSE, false));
        this._parseCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, -1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        generalLayout.setConstraints(this._parseCheckBox, c);
        generalPanel.add(this._parseCheckBox);
        this._checkDontJavadocIfMlBox = new JCheckBox("Dont addd if ML", this.settings.getBoolean(ConventionKeys.DONT_COMMENT_JAVADOC_WHEN_ML, false));
        this._checkDontJavadocIfMlBox.setToolTipText(this.bundle.getString("DONT_COMMENT_JAVADOC_WHEN_ML"));
        SwingHelper.setConstraints(c, 1, 0, 0, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        generalLayout.setConstraints(this._checkDontJavadocIfMlBox, c);
        generalPanel.add(this._checkDontJavadocIfMlBox);
        this._checkTagsCheckBox = new JCheckBox(this.bundle.getString("CHK_CORRECT_TAGS"), this.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_CHECK_TAGS, false));
        this._checkTagsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 1, 1, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        generalLayout.setConstraints(this._checkTagsCheckBox, c);
        generalPanel.add(this._checkTagsCheckBox);
        this._checkThrowsTagsCheckBox = new JCheckBox(this.bundle.getString("CHK_CORRECT_THROWS_TAGS"), this.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_CHECK_TAGS_THROWS, false));
        SwingHelper.setConstraints(c, 1, 1, 0, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        generalLayout.setConstraints(this._checkThrowsTagsCheckBox, c);
        generalPanel.add(this._checkThrowsTagsCheckBox);
        this._parseCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                JavadocSettingsPage.this._parseDescriptionCheckBox.setEnabled(JavadocSettingsPage.this._parseCheckBox.isSelected());
                JavadocSettingsPage.this._checkTagsCheckBox.setEnabled(JavadocSettingsPage.this._parseCheckBox.isSelected());
                JavadocSettingsPage.this._checkThrowsTagsCheckBox.setEnabled(JavadocSettingsPage.this._parseCheckBox.isSelected());
                JavadocSettingsPage.this._singleLineFieldCommentsCheckBox.setEnabled(JavadocSettingsPage.this._parseCheckBox.isSelected());
            }
        });
        this._parseDescriptionCheckBox = new JCheckBox("Parse javadoc description", this.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_PARSE, false));
        this._parseDescriptionCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 1, 1, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        generalLayout.setConstraints(this._checkTagsCheckBox, c);
        generalPanel.add(this._parseDescriptionCheckBox);
        this._tableModel = new DataModel();
        JTable table = new JTable(this._tableModel);
        table.getTableHeader().setResizingAllowed(false);
        table.getTableHeader().setReorderingAllowed(false);
        table.setSelectionMode(0);
        table.setCellSelectionEnabled(false);
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(false);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        int height = SwingHelper.getTableHeight(table);
        scrollPane.setPreferredSize(new Dimension(300, height + 17));
        JPanel createPanel = new JPanel();
        GridBagLayout createLayout = new GridBagLayout();
        createPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_GENERATION")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        createPanel.setLayout(createLayout);
        c.insets.top = 5;
        SwingHelper.setConstraints(c, 0, 0, 8, 8, 1.0, 1.0, 18, 1, c.insets, 0, 0);
        createLayout.setConstraints(scrollPane, c);
        createPanel.add(scrollPane);
        this._createInnerCheckBox = new JCheckBox(this.bundle.getString("CHK_INCLUDE_INNER"), this.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_INNER_CLASS, false));
        this._createInnerCheckBox.addActionListener(this.trigger);
        c.insets.bottom = 0;
        SwingHelper.setConstraints(c, 0, 9, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        createLayout.setConstraints(this._createInnerCheckBox, c);
        createPanel.add(this._createInnerCheckBox);
        JPanel miscPanel = new JPanel();
        miscPanel.setLayout(new BoxLayout(miscPanel, 1));
        miscPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_MISC")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this._singleLineFieldCommentsCheckBox = new JCheckBox(this.bundle.getString("CHK_FIELD_COMMENTS_IN_SINGLE_LINE"), this.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_FIELDS_SHORT, true));
        this._singleLineFieldCommentsCheckBox.addActionListener(this.trigger);
        miscPanel.add(this._singleLineFieldCommentsCheckBox);
        this._braceCommentsCheckBox = new JCheckBox("Add comments after closing braces", this.settings.getBoolean(ConventionKeys.BRACE_ADD_COMMENT, false));
        this._braceCommentsCheckBox.addActionListener(this.trigger);
        miscPanel.add(this._braceCommentsCheckBox);
        this._checkTagsCheckBox.setEnabled(this._parseCheckBox.isSelected());
        this._singleLineFieldCommentsCheckBox.setEnabled(this._parseCheckBox.isSelected());
        this._parseDescriptionCheckBox.setEnabled(this._parseCheckBox.isSelected());
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel();
        panel.setLayout(layout);
        c.insets.top = 10;
        c.insets.left = 5;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(generalPanel, c);
        panel.add(generalPanel);
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(createPanel, c);
        panel.add(createPanel);
        c.insets.bottom = 10;
        SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(miscPanel, c);
        panel.add(miscPanel);
        this._tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent ev) {
                JavadocSettingsPage.this.trigger.actionPerformed(null);
            }
        });
        return panel;
    }

    private JPanel createTagsPane() {
        GridBagLayout tagsPanelLayout = new GridBagLayout();
        JPanel tagsPanel = new JPanel();
        tagsPanel.setLayout(tagsPanelLayout);
        JPanel standardTagsPanel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout standardPanelLayout = new GridBagLayout();
        standardTagsPanel.setLayout(standardPanelLayout);
        standardTagsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_STANDARD_TAGS")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        String standardTagsString = this.settings.get(ConventionKeys.COMMENT_JAVADOC_TAGS_STANDARD, ConventionDefaults.COMMENT_JAVADOC_TAGS_STANDARD);
        Collection standardTags = this.decodeTags(standardTagsString);
        this._standardTagsList = new AddRemoveList(this.bundle.getString("TLE_ADD_NEW_STANDARD"), this.bundle.getString("LBL_ENTER_NAME"), standardTags);
        ListDataHandler dataHandler = new ListDataHandler();
        this._standardTagsList.getModel().addListDataListener(dataHandler);
        JScrollPane standardTagsScrollPane = new JScrollPane(this._standardTagsList);
        c.insets.top = 0;
        c.insets.bottom = 0;
        c.insets.left = 0;
        c.insets.right = 0;
        SwingHelper.setConstraints(c, 0, 0, 10, 5, 1.0, 1.0, 11, 1, c.insets, 0, 0);
        standardPanelLayout.setConstraints(standardTagsScrollPane, c);
        standardTagsPanel.add(standardTagsScrollPane);
        JButton standardTagsAddButton = this._standardTagsList.getAddButton();
        c.insets.left = 5;
        c.insets.bottom = 2;
        SwingHelper.setConstraints(c, 11, 0, 0, 1, 0.0, 0.0, 17, 2, c.insets, 0, 0);
        standardPanelLayout.setConstraints(standardTagsAddButton, c);
        standardTagsPanel.add(standardTagsAddButton);
        JButton standardTagsRemoveButton = this._standardTagsList.getRemoveButton();
        SwingHelper.setConstraints(c, 11, 1, 0, 1, 0.0, 0.0, 17, 2, c.insets, 0, 0);
        standardPanelLayout.setConstraints(standardTagsRemoveButton, c);
        standardTagsPanel.add(standardTagsRemoveButton);
        JPanel inlineTagsPanel = new JPanel();
        GridBagLayout inlinePanelLayout = new GridBagLayout();
        inlineTagsPanel.setLayout(inlinePanelLayout);
        inlineTagsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_INLINE_TAGS")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        String inlineTagsString = this.settings.get(ConventionKeys.COMMENT_JAVADOC_TAGS_INLINE, ConventionDefaults.COMMENT_JAVADOC_TAGS_INLINE);
        Collection inlineTags = this.decodeTags(inlineTagsString);
        this._inlineTagsList = new AddRemoveList(this.bundle.getString("TLE_ADD_NEW_INLINE"), this.bundle.getString("LBL_ENTER_NAME"), inlineTags);
        this._inlineTagsList.getModel().addListDataListener(dataHandler);
        c.insets.top = 0;
        c.insets.bottom = 0;
        c.insets.left = 0;
        c.insets.right = 0;
        JScrollPane inlineTagsScrollPane = new JScrollPane(this._inlineTagsList);
        SwingHelper.setConstraints(c, 0, 0, 10, 5, 1.0, 1.0, 11, 1, c.insets, 0, 0);
        inlinePanelLayout.setConstraints(inlineTagsScrollPane, c);
        inlineTagsPanel.add(inlineTagsScrollPane);
        JButton inlineTagsAddButton = this._inlineTagsList.getAddButton();
        c.insets.left = 5;
        c.insets.bottom = 2;
        SwingHelper.setConstraints(c, 11, 0, 0, 1, 0.0, 0.0, 17, 2, c.insets, 0, 0);
        inlinePanelLayout.setConstraints(inlineTagsAddButton, c);
        inlineTagsPanel.add(inlineTagsAddButton);
        JButton inlineTagsRemoveButton = this._inlineTagsList.getRemoveButton();
        SwingHelper.setConstraints(c, 11, 1, 0, 1, 0.0, 0.0, 17, 2, c.insets, 0, 0);
        inlinePanelLayout.setConstraints(inlineTagsRemoveButton, c);
        inlineTagsPanel.add(inlineTagsRemoveButton);
        c.insets.top = 10;
        c.insets.bottom = 10;
        c.insets.left = 5;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 1.0, 18, 1, c.insets, 0, 0);
        tagsPanelLayout.setConstraints(standardTagsPanel, c);
        tagsPanel.add(standardTagsPanel);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 1.0, 18, 1, c.insets, 0, 0);
        tagsPanelLayout.setConstraints(inlineTagsPanel, c);
        tagsPanel.add(inlineTagsPanel);
        return tagsPanel;
    }

    private JPanel createTemplatesPane() {
        JPanel templatesPanel = new JPanel();
        templatesPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagLayout templatesLayout = new GridBagLayout();
        templatesPanel.setLayout(templatesLayout);
        GridBagConstraints c = new GridBagConstraints();
        Object[] items = new String[]{TPL_CLASS, TPL_INTERFACE, TPL_CTOR, TPL_METHOD, TPL_FIELD};
        ComboBoxPanel chooseTemplateComboBoxPanel = new ComboBoxPanel(this.bundle.getString("LBL_SHOW_TEMPLATE_FOR"), items, TPL_CLASS);
        final JComboBox chooseTemplateComboBox = chooseTemplateComboBoxPanel.getComboBox();
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        templatesLayout.setConstraints(chooseTemplateComboBoxPanel, c);
        templatesPanel.add(chooseTemplateComboBoxPanel);
        this._templatesContainer = new TemplateContainer(TPL_METHOD);
        c.insets.top = 5;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 1.0, 18, 1, c.insets, 0, 0);
        templatesLayout.setConstraints(this._templatesContainer, c);
        templatesPanel.add(this._templatesContainer);
        chooseTemplateComboBox.addItemListener(new ItemListener(){
            int index = 3;

            public void itemStateChanged(ItemEvent ev) {
                switch (ev.getStateChange()) {
                    case 2: {
                        try {
                            JavadocSettingsPage.this.validateSettings();
                        }
                        catch (ValidationException validationException) {
                            chooseTemplateComboBox.setSelectedIndex(this.index);
                            return;
                        }
                        String name = (String)chooseTemplateComboBox.getSelectedItem();
                        if (name != null && name.length() > 0 && !name.equals(JavadocSettingsPage.this._templatesContainer.getCurrent())) {
                            JavadocSettingsPage.this._templatesContainer.switchPanels(name);
                            JavadocSettingsPage.this.invalidate();
                            JavadocSettingsPage.this.repaint();
                        }
                        this.index = chooseTemplateComboBox.getSelectedIndex();
                    }
                }
            }
        });
        chooseTemplateComboBox.setSelectedIndex(3);
        return templatesPanel;
    }

    private Collection decodeTags(String tags) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer i = new StringTokenizer(tags, "|");
        while (i.hasMoreElements()) {
            result.add(i.nextToken());
        }
        return result;
    }

    private String encodeTags(Object[] tags) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < tags.length) {
            buf.append(tags[i]);
            buf.append("|");
            ++i;
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    private void initialize() {
        JTabbedPane tabs = new JTabbedPane();
        tabs.add((Component)this.createGeneralPane(), this.bundle.getString("TAB_GENERAL"));
        tabs.add((Component)this.createTemplatesPane(), this.bundle.getString("TAB_TEMPLATES"));
        tabs.add((Component)this.createTagsPane(), this.bundle.getString("TAB_CUSTOM_TAGS"));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.add((Component)tabs, "Center");
    }

    private class CtorTemplatePanel
    extends JPanel
    implements TemplatePanel {
        Convention settings = Convention.getInstance();
        JTextArea bottomTextArea;
        JTextArea exceptionTextArea;
        JTextArea parameterTextArea;
        JTextArea topTextArea;
        ResourceBundle bundle;

        public CtorTemplatePanel() {
            GridBagLayout layout = new GridBagLayout();
            this.setLayout(layout);
            this.bundle = ResourceBundle.getBundle("de.hunsicker.jalopy.swing.Bundle");
            GridBagConstraints c = new GridBagConstraints();
            JLabel topLabel = new JLabel(this.bundle.getString("LBL_TOP"));
            SwingHelper.setConstraints(c, 0, 0, 0, 1, 0.0, 0.0, 18, 0, c.insets, 0, 0);
            layout.setConstraints(topLabel, c);
            this.add(topLabel);
            this.topTextArea = new JTextArea(this.getTopTemplate());
            JScrollPane topScrollPane = new JScrollPane(this.topTextArea);
            SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.2, 18, 1, c.insets, 0, 0);
            layout.setConstraints(topScrollPane, c);
            this.add(topScrollPane);
            JLabel paramLabel = new JLabel(this.bundle.getString("LBL_PARAMETER"));
            c.insets.top = 3;
            SwingHelper.setConstraints(c, 0, 2, 0, 1, 0.0, 0.0, 18, 0, c.insets, 0, 0);
            layout.setConstraints(paramLabel, c);
            this.add(paramLabel);
            this.parameterTextArea = new JTextArea(this.getParameterTemplate());
            JScrollPane parameterScrollPane = new JScrollPane(this.parameterTextArea);
            c.insets.top = 0;
            SwingHelper.setConstraints(c, 0, 3, 0, 1, 1.0, 0.1, 18, 1, c.insets, 0, 0);
            layout.setConstraints(parameterScrollPane, c);
            this.add(parameterScrollPane);
            JLabel exceptionLabel = new JLabel(this.bundle.getString("LBL_EXCEPTION"));
            c.insets.top = 3;
            SwingHelper.setConstraints(c, 0, 4, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
            layout.setConstraints(exceptionLabel, c);
            this.add(exceptionLabel);
            this.exceptionTextArea = new JTextArea(this.getExceptionTemplate());
            c.insets.top = 0;
            SwingHelper.setConstraints(c, 0, 5, 0, 1, 1.0, 0.1, 18, 1, c.insets, 0, 0);
            JScrollPane exceptionScrollPane = new JScrollPane(this.exceptionTextArea);
            layout.setConstraints(exceptionScrollPane, c);
            this.add(exceptionScrollPane);
            JLabel bottomLabel = new JLabel(this.bundle.getString("LBL_BOTTOM"));
            c.insets.top = 3;
            SwingHelper.setConstraints(c, 0, 8, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
            layout.setConstraints(bottomLabel, c);
            this.add(bottomLabel);
            this.bottomTextArea = new JTextArea(this.getBottomTemplate());
            c.insets.top = 0;
            SwingHelper.setConstraints(c, 0, 9, 0, 1, 1.0, 0.1, 18, 1, c.insets, 0, 0);
            JScrollPane bottomScrollPane = new JScrollPane(this.bottomTextArea);
            layout.setConstraints(bottomScrollPane, c);
            this.add(bottomScrollPane);
        }

        public void updateSettings() {
            this.settings.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_TOP, StringHelper.replace(this.topTextArea.getText(), JavadocSettingsPage.LINE_SEPARATOR, "|"));
            this.settings.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_PARAM, StringHelper.replace(this.parameterTextArea.getText(), JavadocSettingsPage.LINE_SEPARATOR, "|"));
            this.settings.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_EXCEPTION, StringHelper.replace(this.exceptionTextArea.getText(), JavadocSettingsPage.LINE_SEPARATOR, "|"));
            this.settings.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_BOTTOM, StringHelper.replace(this.bottomTextArea.getText(), JavadocSettingsPage.LINE_SEPARATOR, "|"));
        }

        public void validateSettings() throws ValidationException {
            String topText = this.topTextArea.getText();
            if (!JavadocSettingsPage.this._topTextPattern.matcher(topText).matches()) {
                Object[] args = new Object[]{JavadocSettingsPage.this._topTextPattern.pattern()};
                JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), MessageFormat.format(this.bundle.getString("MSG_INVALID_TOP_FRAGMENT"), args), this.bundle.getString("TLE_INVALID_TOP_FRAGMENT"), 0);
                throw new ValidationException();
            }
            String parameterText = this.parameterTextArea.getText();
            if (!JavadocSettingsPage.this._paramPattern.matcher(parameterText).matches()) {
                Object[] args = new Object[]{JavadocSettingsPage.this._paramPattern.pattern()};
                JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), MessageFormat.format(this.bundle.getString("MSG_INVALID_PARAMETER_FRAGMENT"), args), this.bundle.getString("TLE_INVALID_PARAMETER_FRAGMENT"), 0);
                throw new ValidationException();
            }
            String exceptionText = this.exceptionTextArea.getText();
            if (!JavadocSettingsPage.this._exceptionPattern.matcher(exceptionText).matches()) {
                Object[] args = new Object[]{JavadocSettingsPage.this._exceptionPattern.pattern()};
                JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), MessageFormat.format(this.bundle.getString("MSG_INVALID_EXCEPTION_FRAGMENT"), args), this.bundle.getString("TLE_INVALID_EXCEPTION_FRAGMENT"), 0);
                throw new ValidationException();
            }
            String bottomText = this.bottomTextArea.getText();
            if (!JavadocSettingsPage.this._bottomTextPattern.matcher(bottomText).matches()) {
                Object[] args = new Object[]{JavadocSettingsPage.this._bottomTextPattern.pattern()};
                JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), MessageFormat.format(this.bundle.getString("MSG_INVALID_BOTTOM_FRAGMENT"), args), this.bundle.getString("TLE_INVALID_BOTTOM_FRAGMENT"), 0);
                throw new ValidationException();
            }
        }

        protected String getBottomTemplate() {
            return StringHelper.replace(this.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_BOTTOM, " */"), "|", JavadocSettingsPage.LINE_SEPARATOR);
        }

        protected String getExceptionTemplate() {
            return StringHelper.replace(this.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_EXCEPTION, " * @throws $exceptionType$ DOCUMENT ME!"), "|", JavadocSettingsPage.LINE_SEPARATOR);
        }

        protected String getParameterTemplate() {
            return StringHelper.replace(this.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_PARAM, " * @param $paramType$ DOCUMENT ME!"), "|", JavadocSettingsPage.LINE_SEPARATOR);
        }

        protected String getTopTemplate() {
            return StringHelper.replace(this.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_TOP, "/**| * Creates a new $objectType$ object."), "|", JavadocSettingsPage.LINE_SEPARATOR);
        }
    }

    private class DataModel
    extends AbstractTableModel {
        final Convention settings = Convention.getInstance();
        final String[] columnNames = new String[]{"                      ", "public", "protected", "default", "private"};
        final Object[][] data;

        private DataModel() {
            this.data = new Object[][]{{JavadocSettingsPage.this.bundle.getString("LBL_CLASSES_INTERFACES"), new Boolean(Modifier.isPublic(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_CLASS_MASK, 0))), new Boolean(Modifier.isProtected(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_CLASS_MASK, 0))), new Boolean(Modifier.isFinal(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_CLASS_MASK, 0))), new Boolean(Modifier.isPrivate(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_CLASS_MASK, 0)))}, {JavadocSettingsPage.this.bundle.getString("LBL_CONSTRUCTORS"), new Boolean(Modifier.isPublic(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_CTOR_MASK, 0))), new Boolean(Modifier.isProtected(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_CTOR_MASK, 0))), new Boolean(Modifier.isFinal(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_CTOR_MASK, 0))), new Boolean(Modifier.isPrivate(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_CTOR_MASK, 0)))}, {JavadocSettingsPage.this.bundle.getString("LBL_METHODS"), new Boolean(Modifier.isPublic(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_METHOD_MASK, 0))), new Boolean(Modifier.isProtected(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_METHOD_MASK, 0))), new Boolean(Modifier.isFinal(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_METHOD_MASK, 0))), new Boolean(Modifier.isPrivate(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_METHOD_MASK, 0)))}, {JavadocSettingsPage.this.bundle.getString("LBL_VARIABLES"), new Boolean(Modifier.isPublic(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_VARIABLE_MASK, 0))), new Boolean(Modifier.isProtected(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_VARIABLE_MASK, 0))), new Boolean(Modifier.isFinal(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_VARIABLE_MASK, 0))), new Boolean(Modifier.isPrivate(this.settings.getInt(ConventionKeys.COMMENT_JAVADOC_VARIABLE_MASK, 0)))}};
        }

        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getRowCount() {
            return this.data.length;
        }

        public void setValueAt(Object value, int row, int col) {
            if (this.data[0][col] instanceof Integer) {
                try {
                    this.data[row][col] = new Integer((String)value);
                    this.fireTableCellUpdated(row, col);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.data[row][col] = value;
                this.fireTableCellUpdated(row, col);
            }
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }
    }

    private class ListDataHandler
    implements ListDataListener {
        private ListDataHandler() {
        }

        public void contentsChanged(ListDataEvent e) {
        }

        public void intervalAdded(ListDataEvent ev) {
            DefaultListModel model = (DefaultListModel)ev.getSource();
            String name = (String)model.get(ev.getIndex0());
            if (!JavadocSettingsPage.this._tagNamePattern.matcher(name).matches()) {
                Object[] args = new Object[]{name, JavadocSettingsPage.this._tagNamePattern.pattern()};
                JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(JavadocSettingsPage.this), MessageFormat.format(JavadocSettingsPage.this.bundle.getString("MSG_INVALID_TAG_NAME"), args), JavadocSettingsPage.this.bundle.getString("TLE_INVALID_TAG_NAME"), 0);
                throw new IllegalArgumentException();
            }
        }

        public void intervalRemoved(ListDataEvent e) {
        }
    }

    private class MethodTemplatePanel
    extends CtorTemplatePanel {
        JTextArea returnTextArea;

        public MethodTemplatePanel() {
            GridBagConstraints c = new GridBagConstraints();
            JLabel returnLabel = new JLabel(this.bundle.getString("LBL_RETURN"));
            GridBagLayout layout = (GridBagLayout)this.getLayout();
            c.insets.top = 3;
            SwingHelper.setConstraints(c, 0, 6, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
            layout.setConstraints(returnLabel, c);
            this.add(returnLabel);
            this.returnTextArea = new JTextArea(StringHelper.replace(this.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_RETURN, " * @return DOCUMENT ME!"), "|", JavadocSettingsPage.LINE_SEPARATOR));
            c.insets.top = 0;
            SwingHelper.setConstraints(c, 0, 7, 0, 1, 1.0, 0.1, 18, 1, c.insets, 0, 0);
            JScrollPane returnScrollPane = new JScrollPane(this.returnTextArea);
            layout.setConstraints(returnScrollPane, c);
            this.add(returnScrollPane);
        }

        public void updateSettings() {
            this.settings.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_TOP, StringHelper.replace(this.topTextArea.getText(), JavadocSettingsPage.LINE_SEPARATOR, "|"));
            this.settings.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_PARAM, StringHelper.replace(this.parameterTextArea.getText(), JavadocSettingsPage.LINE_SEPARATOR, "|"));
            this.settings.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_EXCEPTION, StringHelper.replace(this.exceptionTextArea.getText(), JavadocSettingsPage.LINE_SEPARATOR, "|"));
            this.settings.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_RETURN, StringHelper.replace(this.returnTextArea.getText(), JavadocSettingsPage.LINE_SEPARATOR, "|"));
            this.settings.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_BOTTOM, StringHelper.replace(this.bottomTextArea.getText(), JavadocSettingsPage.LINE_SEPARATOR, "|"));
        }

        public void validateSettings() throws ValidationException {
            super.validateSettings();
            String returnText = this.returnTextArea.getText();
            if (!JavadocSettingsPage.this._returnPattern.matcher(returnText).matches()) {
                Object[] args = new Object[]{JavadocSettingsPage.this._returnPattern.pattern()};
                JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), MessageFormat.format(this.bundle.getString("MSG_INVALID_RETURN_FRAGMENT"), args), this.bundle.getString("TLE_INVALID_RETURN_FRAGMENT"), 0);
                throw new ValidationException();
            }
        }

        protected String getBottomTemplate() {
            return StringHelper.replace(this.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_BOTTOM, " */"), "|", JavadocSettingsPage.LINE_SEPARATOR);
        }

        protected String getExceptionTemplate() {
            return StringHelper.replace(this.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_EXCEPTION, " * @throws $exceptionType$ DOCUMENT ME!"), "|", JavadocSettingsPage.LINE_SEPARATOR);
        }

        protected String getParameterTemplate() {
            return StringHelper.replace(this.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_PARAM, " * @param $paramType$ DOCUMENT ME!"), "|", JavadocSettingsPage.LINE_SEPARATOR);
        }

        protected String getTopTemplate() {
            return StringHelper.replace(this.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_TOP, "/**| * DOCUMENT ME!"), "|", JavadocSettingsPage.LINE_SEPARATOR);
        }
    }

    private class SimpleTemplatePanel
    extends JPanel
    implements TemplatePanel {
        JTextArea textArea;
        String name;

        public SimpleTemplatePanel(String name, String text) {
            this.name = name;
            this.setLayout(new BorderLayout());
            this.textArea = new JTextArea(StringHelper.replace(text, "|", JavadocSettingsPage.LINE_SEPARATOR));
            this.add((Component)new JScrollPane(this.textArea), "Center");
        }

        public String getText() {
            return this.textArea.getText();
        }

        public void updateSettings() {
            if (JavadocSettingsPage.TPL_CLASS.equals(this.name)) {
                JavadocSettingsPage.this.settings.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CLASS, StringHelper.replace(this.textArea.getText(), JavadocSettingsPage.LINE_SEPARATOR, "|"));
            } else if (JavadocSettingsPage.TPL_INTERFACE.equals(this.name)) {
                JavadocSettingsPage.this.settings.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_INTERFACE, StringHelper.replace(this.textArea.getText(), JavadocSettingsPage.LINE_SEPARATOR, "|"));
            } else if (JavadocSettingsPage.TPL_FIELD.equals(this.name)) {
                JavadocSettingsPage.this.settings.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_VARIABLE, StringHelper.replace(this.textArea.getText(), JavadocSettingsPage.LINE_SEPARATOR, "|"));
            }
        }

        public void validateSettings() throws ValidationException {
            String text = this.textArea.getText();
            if (!JavadocSettingsPage.this._templatePattern.matcher(text).matches()) {
                Object[] args = new Object[]{JavadocSettingsPage.this._templatePattern.pattern()};
                JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), MessageFormat.format(JavadocSettingsPage.this.bundle.getString("MSG_INVALID_TEMPLATE"), args), JavadocSettingsPage.this.bundle.getString("TLE_INVALID_TEMPLATE"), 0);
                throw new ValidationException();
            }
        }
    }

    private class TemplateContainer
    extends JPanel {
        Map panels = new HashMap();
        String name;
        boolean destroyed;

        public TemplateContainer(String name) {
            this.setLayout(new BorderLayout());
            this.add((Component)this.getTemplatePanel(name), "Center");
            this.name = name;
        }

        public String getCurrent() {
            return this.name;
        }

        public void dispose() {
            if (!JavadocSettingsPage.this._disposed) {
                this.panels.clear();
                JavadocSettingsPage.this._disposed = true;
            }
        }

        public void switchPanels(String newName) {
            this.remove(0);
            JPanel panel = this.getTemplatePanel(newName);
            this.add((Component)panel, "Center");
            this.name = newName;
        }

        public void updateSettings() {
            for (TemplatePanel panel : this.panels.values()) {
                panel.updateSettings();
            }
        }

        public void validateSettings() throws ValidationException {
            for (TemplatePanel panel : this.panels.values()) {
                panel.validateSettings();
            }
        }

        private JPanel getTemplatePanel(String newName) {
            if (this.panels.containsKey(newName)) {
                return (JPanel)this.panels.get(newName);
            }
            if (JavadocSettingsPage.TPL_CLASS.equals(newName)) {
                SimpleTemplatePanel panel = new SimpleTemplatePanel(newName, JavadocSettingsPage.this.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CLASS, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */"));
                this.panels.put(newName, panel);
                return panel;
            }
            if (JavadocSettingsPage.TPL_INTERFACE.equals(newName)) {
                SimpleTemplatePanel panel = new SimpleTemplatePanel(newName, JavadocSettingsPage.this.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_INTERFACE, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */"));
                this.panels.put(newName, panel);
                return panel;
            }
            if (JavadocSettingsPage.TPL_CTOR.equals(newName)) {
                CtorTemplatePanel panel = new CtorTemplatePanel();
                this.panels.put(newName, panel);
                return panel;
            }
            if (JavadocSettingsPage.TPL_METHOD.equals(newName)) {
                MethodTemplatePanel panel = new MethodTemplatePanel();
                this.panels.put(newName, panel);
                return panel;
            }
            if (JavadocSettingsPage.TPL_FIELD.equals(newName)) {
                SimpleTemplatePanel panel = new SimpleTemplatePanel(newName, JavadocSettingsPage.this.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_VARIABLE, "/**| * DOCUMENT ME!| */"));
                this.panels.put(newName, panel);
                return panel;
            }
            throw new IllegalArgumentException("unknown template name -- " + newName);
        }
    }

    private static interface TemplatePanel {
        public void updateSettings();

        public void validateSettings() throws ValidationException;
    }
}

