/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.swing;

import de.hunsicker.swing.util.SwingHelper;
import de.hunsicker.util.ResourceBundleFactory;
import de.hunsicker.util.StringHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class ErrorDialog
extends JDialog {
    private static final int DETAILS_HIDE = 2;
    private static final int DETAILS_SHOW = 1;
    private static final String BUNDLE_NAME = "de.hunsicker.swing.Bundle";
    JScrollPane _details;
    int _status = 2;

    protected ErrorDialog(Dialog owner, String title, boolean modal, Throwable ex) {
        super(owner, modal);
        this.initialize(ex, title, owner);
    }

    protected ErrorDialog(Frame owner, String title, boolean modal, Throwable ex) {
        super(owner, modal);
        this.initialize(ex, title, owner);
    }

    public static ErrorDialog create(Window owner, String title, boolean modal, Throwable ex) {
        if (owner instanceof Frame) {
            return new ErrorDialog((Frame)owner, title, modal, ex);
        }
        if (owner instanceof Dialog) {
            return new ErrorDialog((Dialog)owner, title, modal, ex);
        }
        throw new IllegalArgumentException("invalid owner type -- " + owner);
    }

    public static ErrorDialog create(Window owner, boolean modal, Throwable ex) {
        return ErrorDialog.create(owner, ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("TLE_ERROR"), modal, ex);
    }

    public static ErrorDialog create(Window parent, Throwable ex) {
        return ErrorDialog.create(parent, ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("TLE_ERROR"), true, ex);
    }

    private void initialize(final Throwable ex, String title, final Component parent) {
        this.setTitle(title);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        final Container pane = this.getContentPane();
        final GridBagLayout layout = new GridBagLayout();
        pane.setLayout(layout);
        StringBuffer buf = new StringBuffer(150);
        if (ex instanceof RuntimeException) {
            Object[] args = new Object[]{ex.getClass().getName()};
            buf.append(MessageFormat.format(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("MSG_UNEXPECTED_EXCEPTION"), args));
        } else {
            buf.append(String.valueOf(ex.getClass().getName()) + ':');
        }
        final JPanel messagePanel = new JPanel();
        GridBagLayout messageLayout = new GridBagLayout();
        messagePanel.setLayout(messageLayout);
        JLabel message = new JLabel(buf.toString());
        final GridBagConstraints c = new GridBagConstraints();
        c.insets.right = 15;
        JLabel icon = new JLabel(UIManager.getIcon("OptionPane.errorIcon"));
        SwingHelper.setConstraints(c, 0, 0, -1, 1, 0.0, 0.0, 18, 3, c.insets, 0, 0);
        messageLayout.setConstraints(icon, c);
        messagePanel.add(icon);
        c.insets.left = 0;
        SwingHelper.setConstraints(c, 1, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        messageLayout.setConstraints(message, c);
        messagePanel.add(message);
        String[] lines = StringHelper.wrapStringToArray(ex.getMessage() == null ? "" : ex.getMessage(), 55, "\r\n", true, 1);
        if (lines.length == 1 && lines[0].length() == 0) {
            lines = new String[]{ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("MSG_NO_FURTHER_INFO")};
        }
        int i = 0;
        while (i < lines.length) {
            JLabel line = new JLabel(lines[i]);
            SwingHelper.setConstraints(c, 1, i + 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
            messageLayout.setConstraints(line, c);
            messagePanel.add(line);
            ++i;
        }
        c.insets.left = 10;
        c.insets.right = 10;
        c.insets.top = 10;
        c.insets.bottom = 10;
        SwingHelper.setConstraints(c, 0, 0, 0, 4, 1.0, 1.0, 18, 1, c.insets, 0, 0);
        layout.setConstraints(messagePanel, c);
        pane.add(messagePanel);
        c.insets.top = 10;
        c.insets.left = 50;
        c.insets.bottom = 15;
        c.insets.right = 15;
        JButton okBtn = new JButton(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("BTN_OK"));
        okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ErrorDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(okBtn);
        SwingHelper.setConstraints(c, 3, 4, 0, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        layout.setConstraints(okBtn, c);
        pane.add(okBtn);
        final JButton toggleBtn = new JButton(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("BTN_SHOW_DETAILS"));
        toggleBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ErrorDialog.this.setVisible(false);
                switch (ErrorDialog.this._status) {
                    case 2: {
                        toggleBtn.setText(ResourceBundleFactory.getBundle(ErrorDialog.BUNDLE_NAME).getString("BTN_HIDE_DETAILS"));
                        ErrorDialog.this._status = 1;
                        if (ErrorDialog.this._details == null) {
                            StringWriter stringWriter = new StringWriter();
                            PrintWriter out = new PrintWriter(new BufferedWriter(stringWriter));
                            ex.printStackTrace(out);
                            out.close();
                            JTextArea textArea = new JTextArea(stringWriter.toString(), 10, 40);
                            ErrorDialog.this._details = new JScrollPane(textArea);
                            textArea.setCaretPosition(1);
                            Dimension size = new Dimension(400, 170);
                            ErrorDialog.this._details.setMinimumSize(size);
                            ErrorDialog.this._details.setPreferredSize(size);
                        }
                        pane.remove(messagePanel);
                        c.insets.top = 10;
                        c.insets.left = 10;
                        c.insets.bottom = 10;
                        c.insets.right = 10;
                        SwingHelper.setConstraints(c, 0, 0, 0, 4, 1.0, 1.0, 18, 1, c.insets, 0, 0);
                        layout.setConstraints(ErrorDialog.this._details, c);
                        pane.add(ErrorDialog.this._details);
                        break;
                    }
                    case 1: {
                        toggleBtn.setText(ResourceBundleFactory.getBundle(ErrorDialog.BUNDLE_NAME).getString("BTN_SHOW_DETAILS"));
                        ErrorDialog.this._status = 2;
                        pane.remove(ErrorDialog.this._details);
                        c.insets.top = 10;
                        c.insets.left = 10;
                        c.insets.bottom = 10;
                        c.insets.right = 10;
                        SwingHelper.setConstraints(c, 0, 0, 0, 4, 1.0, 1.0, 18, 1, c.insets, 0, 0);
                        layout.setConstraints(messagePanel, c);
                        pane.add(messagePanel);
                    }
                }
                ErrorDialog.this.pack();
                ErrorDialog.this.setLocationRelativeTo(parent);
                ErrorDialog.this.setVisible(true);
            }
        });
        c.insets.top = 10;
        c.insets.left = 10;
        c.insets.bottom = 15;
        c.insets.right = 50;
        SwingHelper.setConstraints(c, 0, 4, -1, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        layout.setConstraints(toggleBtn, c);
        pane.add(toggleBtn);
        this.pack();
        this.setLocationRelativeTo(parent);
    }
}

