/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.util;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class StringHelper {
    public static final int TRIM_ALL = 1;
    public static final int TRIM_LEADING = 4;
    public static final int TRIM_NONE = 0;
    private static final String EMPTY_STRING = "".intern();
    private static final String LINE_SEPARATOR = "\n";
    private static final String SPACE = " ";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    private StringHelper() {
    }

    public static String getClassName(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot > 0) {
            return qualifiedName.substring(lastDot + 1);
        }
        return qualifiedName;
    }

    public static boolean isNumber(String str) {
        if (str == null) {
            return false;
        }
        int letters = 0;
        int i = 0;
        int size = str.length();
        while (i < size) {
            if (str.charAt(i) < '0' || str.charAt(i) > '9') {
                ++letters;
            }
            ++i;
        }
        return letters <= 1 && (letters != true || str.length() != 1);
    }

    public static String getPackageName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot > 0) {
            return name.substring(0, lastDot);
        }
        return EMPTY_STRING;
    }

    public static boolean isUppercase(char letter) {
        return letter >= 'A' && letter <= 'Z';
    }

    public static boolean containsUppercase(String str) {
        if (str.length() == 0) {
            return false;
        }
        int i = 0;
        int size = str.length();
        while (i < size) {
            if (StringHelper.isUppercase(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int indexOf(char character, String str, int x) {
        int i = 1;
        int pos = -1;
        while ((pos = str.indexOf(character, pos + 1)) > -1) {
            if (i == x) {
                return pos;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfNonWhitespace(String str) {
        return StringHelper.indexOfNonWhitespace(str, 0);
    }

    public static int indexOfNonWhitespace(String str, int beginOffset) {
        if (beginOffset < 0) {
            throw new IllegalArgumentException("beginOffset < 0 -- " + beginOffset);
        }
        int i = beginOffset;
        int size = str.length();
        while (i < size) {
            switch (str.charAt(i)) {
                case '\t': 
                case ' ': {
                    break;
                }
                default: {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static String leftPad(String str, int size) {
        return StringHelper.leftPad(str, size, SPACE);
    }

    public static String leftPad(String str, int size, String delim) {
        if ((size = (size - str.length()) / delim.length()) > 0) {
            str = String.valueOf(StringHelper.repeat(delim, size)) + str;
        }
        return str;
    }

    public static String lowercaseFirst(String str) {
        if (str.length() == 0) {
            return str;
        }
        if (StringHelper.isUppercase(str.charAt(0))) {
            char[] letters = str.toCharArray();
            letters[0] = (char)(letters[0] + 32);
            return new String(letters);
        }
        return str;
    }

    public static int occurs(char character, char[] string) {
        int count = 0;
        int i = 0;
        while (i < string.length) {
            if (string[i] == character) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int occurs(char character, String string) {
        return StringHelper.occurs(character, string.toCharArray());
    }

    public static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        int i = 0;
        while (i < repeat) {
            buffer.append(str);
            ++i;
        }
        return buffer.toString();
    }

    public static String replace(String original, String replaceFrom, String replaceTo) {
        int pos;
        if (EMPTY_STRING.equals(replaceFrom)) {
            return original;
        }
        if (original.indexOf(replaceFrom) == -1) {
            return original;
        }
        StringBuffer buf = new StringBuffer(original.length());
        int index = 0;
        do {
            if ((pos = original.indexOf(replaceFrom, index)) == -1) {
                buf.append(original.substring(index));
                return buf.toString();
            }
            buf.append(original.substring(index, pos));
            buf.append(replaceTo);
        } while ((index = pos + replaceFrom.length()) != original.length());
        return buf.toString();
    }

    public static String[] split(String str, String delim) {
        int startOffset = 0;
        int endOffset = -1;
        int sepLength = delim.length();
        ArrayList<String> lines = new ArrayList<String>(15);
        while ((endOffset = str.indexOf(delim, startOffset)) > -1) {
            lines.add(str.substring(startOffset, endOffset));
            startOffset = endOffset + sepLength;
        }
        if (startOffset > 0) {
            lines.add(str.substring(startOffset));
        } else {
            lines.add(str);
        }
        return lines.toArray(EMPTY_STRING_ARRAY);
    }

    public static boolean startsWithUppercase(String str) {
        if (str.length() == 0) {
            return false;
        }
        return StringHelper.isUppercase(str.charAt(0));
    }

    public static String trimTrailing(String str) {
        int index = str.length();
        while (index > 0 && Character.isWhitespace(str.charAt(index - 1))) {
            --index;
        }
        if (index != str.length()) {
            return str.substring(0, index);
        }
        return str;
    }

    public static String wrapString(String str, int width, boolean removeNewLines) {
        String[] lines = StringHelper.wrapStringToArray(str, width, LINE_SEPARATOR, removeNewLines, 1);
        StringBuffer buf = new StringBuffer(str.length());
        int i = 0;
        while (i < lines.length) {
            buf.append(lines[i]);
            buf.append('\n');
            ++i;
        }
        return buf.toString();
    }

    public static String[] wrapStringToArray(String str, int width, String lineSeparator, boolean removeNewLines, int trimPolicy) {
        return StringHelper.wrapStringToArray(str, width, new SpaceBreakIterator(), lineSeparator, removeNewLines, trimPolicy);
    }

    public static String[] wrapStringToArray(String str, int width, BreakIterator breakIter, String lineSeparator, boolean removeNewLines, int trimPolicy) {
        String[] workingSet;
        block41: {
            if (str.length() == 0) {
                return new String[]{str};
            }
            workingSet = null;
            if (removeNewLines) {
                str = str.trim();
                str = StringHelper.replace(str, lineSeparator, SPACE);
                workingSet = new String[]{str};
            } else {
                StringTokenizer tokens = new StringTokenizer(str, lineSeparator);
                int len = tokens.countTokens();
                workingSet = new String[len];
                int leadingWhitespace = 0;
                int i = 0;
                while (i < len) {
                    String token = tokens.nextToken();
                    if (trimPolicy == 4) {
                        int j = 0;
                        block16: while (j < token.length()) {
                            switch (token.charAt(j)) {
                                case '\t': 
                                case ' ': {
                                    break;
                                }
                                default: {
                                    if (i == 1) {
                                        leadingWhitespace = j;
                                        break block16;
                                    }
                                    if (j >= leadingWhitespace) break block16;
                                    leadingWhitespace = j;
                                    break block16;
                                }
                            }
                            ++j;
                        }
                        if (StringHelper.isLeadingAsterix(token)) {
                            token = token.trim();
                            token = String.valueOf(' ') + token;
                        } else if (token.length() >= leadingWhitespace && i > 0) {
                            token = "   " + token.substring(leadingWhitespace);
                        }
                    }
                    workingSet[i] = token;
                    ++i;
                }
            }
            if (width < 1) {
                width = 1;
            }
            if (str.length() <= width) {
                return workingSet;
            }
            boolean ok = true;
            int i = 0;
            while (i < workingSet.length) {
                boolean bl = ok = ok && workingSet[i].length() < width;
                if (ok) {
                    ++i;
                    continue;
                }
                break block41;
            }
            return workingSet;
        }
        ArrayList<String> lines = new ArrayList<String>(workingSet.length);
        int lineStart = 0;
        int i = 0;
        while (i < workingSet.length) {
            if (workingSet[i].length() < width) {
                switch (trimPolicy) {
                    case 1: {
                        lines.add(workingSet[i].trim());
                        break;
                    }
                    default: {
                        lines.add(workingSet[i]);
                        break;
                    }
                }
            } else {
                breakIter.setText(workingSet[i]);
                int nextStart = breakIter.next();
                int prevStart = 0;
                while (true) {
                    if (nextStart - lineStart < width && nextStart != -1) {
                        prevStart = nextStart;
                        nextStart = breakIter.next();
                        continue;
                    }
                    if (prevStart == 0) {
                        prevStart = nextStart;
                    }
                    if (nextStart == -1) {
                        if (prevStart - lineStart + (workingSet[i].length() - prevStart) < width) {
                            switch (trimPolicy) {
                                case 1: {
                                    lines.add(workingSet[i].substring(lineStart, workingSet[i].length()).trim());
                                    break;
                                }
                                default: {
                                    lines.add(workingSet[i].substring(lineStart, workingSet[i].length()));
                                    break;
                                }
                            }
                        } else {
                            switch (trimPolicy) {
                                case 1: {
                                    if (prevStart > 0) {
                                        lines.add(workingSet[i].substring(lineStart, prevStart).trim());
                                        lines.add(workingSet[i].substring(prevStart).trim());
                                        break;
                                    }
                                    lines.add(workingSet[i].substring(lineStart).trim());
                                    break;
                                }
                                default: {
                                    if (prevStart > 0) {
                                        lines.add(workingSet[i].substring(lineStart, prevStart));
                                        lines.add(workingSet[i].substring(prevStart));
                                        break;
                                    }
                                    lines.add(workingSet[i].substring(lineStart).trim());
                                }
                            }
                        }
                        prevStart = workingSet[i].length();
                    } else {
                        switch (trimPolicy) {
                            case 1: {
                                lines.add(workingSet[i].substring(lineStart, prevStart).trim());
                                break;
                            }
                            default: {
                                lines.add(workingSet[i].substring(lineStart, prevStart));
                            }
                        }
                    }
                    lineStart = prevStart;
                    prevStart = 0;
                    if (lineStart >= workingSet[i].length()) break;
                }
                lineStart = 0;
            }
            ++i;
        }
        String[] s = new String[lines.size()];
        return lines.toArray(s);
    }

    private static boolean isLeadingAsterix(String line) {
        if (line == null) {
            return false;
        }
        int i = 0;
        int size = line.length();
        while (i < size) {
            char character = line.charAt(i);
            switch (character) {
                case '\t': 
                case ' ': {
                    break;
                }
                default: {
                    return character == '*';
                }
            }
            ++i;
        }
        return false;
    }

    private static class SpaceBreakIterator
    extends BreakIterator {
        static final String BR = "<br>";
        String text;
        boolean isBreak;
        int end = -1;
        int pos = -1;

        private SpaceBreakIterator() {
        }

        public boolean isBreak() {
            return this.isBreak;
        }

        public void setText(String text) {
            this.end = -1;
            this.pos = -1;
            this.text = text;
        }

        public void setText(CharacterIterator iter) {
            throw new UnsupportedOperationException();
        }

        public CharacterIterator getText() {
            throw new UnsupportedOperationException();
        }

        public int current() {
            throw new UnsupportedOperationException();
        }

        public int first() {
            throw new UnsupportedOperationException();
        }

        public int following(int offset) {
            throw new UnsupportedOperationException();
        }

        public int last() {
            throw new UnsupportedOperationException();
        }

        public int next() {
            this.isBreak = false;
            this.pos = this.text.indexOf(32, this.end + 1);
            int tab = this.text.indexOf(9, this.end + 1);
            int br = this.text.indexOf(BR, this.end + 1);
            if (this.pos > -1 && tab > -1 && tab < this.pos) {
                this.pos = tab;
            }
            if (this.pos > -1 && br > -1 && br < this.pos) {
                this.pos = br;
                this.isBreak = true;
            }
            if (this.pos == -1) {
                return -1;
            }
            this.end = this.pos;
            return this.pos;
        }

        public int next(int offset) {
            throw new UnsupportedOperationException();
        }

        public int previous() {
            throw new UnsupportedOperationException();
        }
    }
}

