/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.framework.Component;
import com.sun.jbi.management.common.LoggerMBean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentLoggerMBean
implements LoggerMBean {
    private Component mComponent;
    private String mDisplayName;
    private Logger mLogger;

    ComponentLoggerMBean(Component component, Logger logger, String displayName) {
        this.mComponent = component;
        this.mLogger = logger;
        this.mDisplayName = displayName;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public String getLogLevel() {
        Logger log = this.mLogger;
        Level level = this.mLogger.getLevel();
        while (null == level && null != (log = log.getParent())) {
            level = log.getLevel();
        }
        if (null != level) {
            return level.getLocalizedName();
        }
        return null;
    }

    public String getLoggerName() {
        return this.mLogger.getName();
    }

    public int setAll() {
        return this.setLevel(Level.ALL);
    }

    public int setConfig() {
        return this.setLevel(Level.CONFIG);
    }

    public int setDefault() {
        return this.setLevel(null);
    }

    public int setFine() {
        return this.setLevel(Level.FINE);
    }

    public int setFiner() {
        return this.setLevel(Level.FINER);
    }

    public int setFinest() {
        return this.setLevel(Level.FINEST);
    }

    public int setInfo() {
        return this.setLevel(Level.INFO);
    }

    public int setOff() {
        return this.setLevel(Level.OFF);
    }

    public int setSevere() {
        return this.setLevel(Level.SEVERE);
    }

    public int setWarning() {
        return this.setLevel(Level.WARNING);
    }

    private int setLevel(Level logLevel) {
        this.mLogger.setLevel(logLevel);
        this.mComponent.setLoggerLevel(this.mLogger.getName(), logLevel);
        return 0;
    }
}

