/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.messaging.MessagingStatistics;
import com.sun.jbi.monitoring.ComponentStatisticsBase;
import com.sun.jbi.monitoring.ComponentStatisticsMBean;
import com.sun.jbi.monitoring.StatisticsBase;
import com.sun.jbi.util.monitoring.StatisticsBaseImpl;
import java.util.Date;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;

public class ComponentStatistics
implements ComponentStatisticsBase,
ComponentStatisticsMBean {
    private StatisticsBase mStatisticsBase;
    private Date mLastRestartTime;
    private int mInitRequests;
    private int mStartRequests;
    private int mStopRequests;
    private int mShutDownRequests;
    private int mFailedRequests;
    private int mTimedOutRequests;
    private short mDeployedSUs;
    private int mDeploySURequests;
    private int mInitSURequests;
    private int mStartSURequests;
    private int mStopSURequests;
    private int mShutDownSURequests;
    private int mUndeploySURequests;
    private int mFailedSURequests;
    private int mTimedOutSURequests;
    private short mRegisteredServicesOrEndpoints;
    private MessagingStatistics mMessagingStatistics;
    private static final int ONE_HUNDRED = 100;
    private static final int MILLISECONDS_PER_HOUR = 3600000;

    public ComponentStatistics(String key) {
        this.mStatisticsBase = new StatisticsBaseImpl(key);
        this.mMessagingStatistics = new MessagingStatistics();
    }

    public boolean isEnabled() {
        return this.mStatisticsBase.isEnabled();
    }

    public void setDisabled() {
        this.mStatisticsBase.setDisabled();
    }

    public void setEnabled() {
        this.mStatisticsBase.setEnabled();
    }

    public StatisticsBase getStatisticsBase() {
        return this.mStatisticsBase;
    }

    public Object getMessagingStatisticsInstance() {
        return this.mMessagingStatistics;
    }

    public void decrementRegisteredServicesOrEndpoints() {
        this.mRegisteredServicesOrEndpoints = (short)(this.mRegisteredServicesOrEndpoints - 1);
    }

    public void incrementRegisteredServicesOrEndpoints() {
        this.mRegisteredServicesOrEndpoints = (short)(this.mRegisteredServicesOrEndpoints + 1);
    }

    public Date getLastRestartTime() {
        return this.mLastRestartTime;
    }

    public int getInitRequests() {
        return this.mInitRequests;
    }

    public int getStartRequests() {
        return this.mStartRequests;
    }

    public int getStopRequests() {
        return this.mStopRequests;
    }

    public int getShutDownRequests() {
        return this.mShutDownRequests;
    }

    public int getFailedRequests() {
        return this.mFailedRequests;
    }

    public int getTimedOutRequests() {
        return this.mTimedOutRequests;
    }

    public short getDeployedSUs() {
        return this.mDeployedSUs;
    }

    public int getDeploySURequests() {
        return this.mDeploySURequests;
    }

    public int getUndeploySURequests() {
        return this.mUndeploySURequests;
    }

    public int getInitSURequests() {
        return this.mInitSURequests;
    }

    public int getStartSURequests() {
        return this.mStartSURequests;
    }

    public int getStopSURequests() {
        return this.mStopSURequests;
    }

    public int getShutDownSURequests() {
        return this.mShutDownSURequests;
    }

    public int getFailedSURequests() {
        return this.mFailedSURequests;
    }

    public int getTimedOutSURequests() {
        return this.mTimedOutSURequests;
    }

    public short getRegisteredServicesOrEndpoints() {
        return this.mRegisteredServicesOrEndpoints;
    }

    public CompositeData getMessagingStatistics() {
        CompositeData mscd = null;
        try {
            mscd = this.mMessagingStatistics.toCompositeData();
        }
        catch (OpenDataException odEx) {
            odEx.printStackTrace();
        }
        return mscd;
    }

    void setLastRestartTime(Date startTime) {
        this.mLastRestartTime = startTime;
        this.mMessagingStatistics.setLastRestartTime(startTime);
    }

    void incrementInitRequests() {
        ++this.mInitRequests;
    }

    void incrementStartRequests() {
        ++this.mStartRequests;
    }

    void incrementStopRequests() {
        ++this.mStopRequests;
    }

    void incrementShutDownRequests() {
        ++this.mShutDownRequests;
    }

    void incrementFailedRequests() {
        ++this.mFailedRequests;
    }

    void incrementTimedOutRequests() {
        ++this.mTimedOutRequests;
    }

    void decrementDeployedSUs() {
        this.mDeployedSUs = (short)(this.mDeployedSUs - 1);
    }

    void incrementDeployedSUs() {
        this.mDeployedSUs = (short)(this.mDeployedSUs + 1);
    }

    void incrementDeploySURequests() {
        ++this.mDeploySURequests;
    }

    void incrementUndeploySURequests() {
        ++this.mUndeploySURequests;
    }

    void incrementInitSURequests() {
        ++this.mInitSURequests;
    }

    void incrementStartSURequests() {
        ++this.mStartSURequests;
    }

    void incrementStopSURequests() {
        ++this.mStopSURequests;
    }

    void incrementShutDownSURequests() {
        ++this.mShutDownSURequests;
    }

    void incrementFailedSURequests() {
        ++this.mFailedSURequests;
    }

    void incrementTimedOutSURequests() {
        ++this.mTimedOutSURequests;
    }

    void resetAllStatistics() {
        this.resetFrameworkStatistics();
        this.resetMessagingStatistics();
    }

    void resetFrameworkStatistics() {
        this.mInitRequests = 0;
        this.mStartRequests = 0;
        this.mStopRequests = 0;
        this.mShutDownRequests = 0;
        this.mFailedRequests = 0;
        this.mTimedOutRequests = 0;
        this.mDeployedSUs = 0;
        this.mDeploySURequests = 0;
        this.mInitSURequests = 0;
        this.mStartSURequests = 0;
        this.mStopSURequests = 0;
        this.mShutDownSURequests = 0;
        this.mUndeploySURequests = 0;
        this.mFailedSURequests = 0;
        this.mTimedOutSURequests = 0;
        this.mRegisteredServicesOrEndpoints = 0;
    }

    void resetMessagingStatistics() {
        this.mMessagingStatistics.resetStatistics();
    }
}

