/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.IdleRemover;
import org.firebirdsql.jca.PoolFiller;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class ManagedConnectionPool {
    private ManagedConnectionFactory mcf;
    private ConnectionRequestInfo defaultCri;
    private PoolParams poolParams;
    private final LinkedList mcs = new LinkedList();
    private FIFOSemaphore permits;
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jca$ManagedConnectionPool != null ? class$org$firebirdsql$jca$ManagedConnectionPool : (class$org$firebirdsql$jca$ManagedConnectionPool = ManagedConnectionPool.class$("org.firebirdsql.jca.ManagedConnectionPool")), false);
    private final Counter connectionCounter = new Counter();
    private boolean started = false;
    static /* synthetic */ Class class$org$firebirdsql$jca$ManagedConnectionPool;

    public ManagedConnectionPool(ManagedConnectionFactory mcf, ConnectionRequestInfo cri, PoolParams poolParams) {
        this.mcf = mcf;
        this.defaultCri = cri;
        this.poolParams = poolParams;
        this.permits = new FIFOSemaphore(this.poolParams.maxSize);
        IdleRemover.registerPool(this, poolParams.idleTimeout);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private ManagedConnection createConnection(ConnectionRequestInfo cri) throws ResourceException {
        try {
            this.connectionCounter.inc();
            return this.mcf.createManagedConnection(null, cri);
        }
        catch (ResourceException re) {
            this.connectionCounter.dec();
            throw re;
        }
    }

    private void doDestroy(ManagedConnection mc) {
        this.connectionCounter.dec();
        try {
            mc.destroy();
        }
        catch (ResourceException resourceException) {}
    }

    public void fillToMin() {
        ArrayList<ManagedConnection> newMCs = new ArrayList<ManagedConnection>();
        try {
            while (this.connectionCounter.getCount() < this.poolParams.minSize) {
                newMCs.add(this.getConnection(this.defaultCri));
            }
        }
        catch (ResourceException resourceException) {}
        Iterator i = ((AbstractList)newMCs).iterator();
        while (i.hasNext()) {
            this.returnConnection((ManagedConnection)i.next(), false);
        }
    }

    public ManagedConnection getConnection(ConnectionRequestInfo cri) throws ResourceException {
        cri = cri == null ? this.defaultCri : cri;
        try {
            if (this.permits.attempt(this.poolParams.blockingTimeout)) {
                ManagedConnection mc = null;
                LinkedList linkedList = this.mcs;
                synchronized (linkedList) {
                    if (this.mcs.size() > 0) {
                        mc = ((MCHolder)this.mcs.removeFirst()).getMC();
                    }
                }
                try {
                    if (mc != null) {
                        if ((mc = this.mcf.matchManagedConnections(new SetOfOne(mc), null, cri)) == null) {
                            throw new FBResourceException("Error in setting up ManagedConnectionPool: matchManagedConnection failed with ConnectionRequestInfo: " + cri);
                        }
                        return mc;
                    }
                    mc = this.createConnection(cri);
                    if (!this.started) {
                        this.started = true;
                        PoolFiller.fillPool(this);
                    }
                    return mc;
                }
                catch (ResourceException re) {
                    this.permits.release();
                    throw re;
                }
            }
            throw new FBResourceException("No ManagedConnections Available!");
        }
        catch (InterruptedException interruptedException) {
            throw new FBResourceException("Interrupted while requesting permit!");
        }
    }

    public int getConnectionCount() {
        return this.connectionCounter.getCount();
    }

    public void removeTimedOut() {
        if (log != null) {
            log.debug("Checking for timed out connections");
        }
        LinkedList linkedList = this.mcs;
        synchronized (linkedList) {
            Iterator i = this.mcs.iterator();
            while (i.hasNext()) {
                MCHolder mch = (MCHolder)i.next();
                if (!mch.isTimedOut()) break;
                if (log != null) {
                    log.debug("Removing a timed-out connection");
                }
                i.remove();
                this.doDestroy(mch.getMC());
            }
        }
        PoolFiller.fillPool(this);
    }

    public void returnConnection(ManagedConnection mc, boolean kill) {
        try {
            block8: {
                try {
                    mc.cleanup();
                    if (kill) {
                        this.doDestroy(mc);
                        break block8;
                    }
                    LinkedList linkedList = this.mcs;
                    synchronized (linkedList) {
                        this.mcs.addLast(new MCHolder(mc));
                    }
                }
                catch (ResourceException resourceException) {
                }
            }
            Object var4_4 = null;
            this.permits.release();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.permits.release();
            throw throwable;
        }
    }

    public void shutdown() {
        LinkedList linkedList = this.mcs;
        synchronized (linkedList) {
            Iterator i = this.mcs.iterator();
            while (i.hasNext()) {
                ManagedConnection mc = ((MCHolder)i.next()).getMC();
                i.remove();
                this.doDestroy(mc);
            }
        }
        IdleRemover.unregisterPool(this);
    }

    public static class PoolParams {
        public int minSize = 0;
        public int maxSize = 10;
        public int blockingTimeout = 5000;
        public long idleTimeout = 1800000L;
    }

    private class MCHolder {
        private final ManagedConnection mc;
        private final long age;

        MCHolder(ManagedConnection mc) {
            this.mc = mc;
            this.age = System.currentTimeMillis();
        }

        ManagedConnection getMC() {
            return this.mc;
        }

        boolean isTimedOut() {
            return System.currentTimeMillis() - this.age > ((ManagedConnectionPool)ManagedConnectionPool.this).poolParams.idleTimeout;
        }
    }

    private static class Counter {
        private int count = 0;

        Counter() {
        }

        synchronized void dec() {
            --this.count;
        }

        synchronized int getCount() {
            return this.count;
        }

        synchronized void inc() {
            ++this.count;
        }
    }

    public static class SetOfOne
    implements Set {
        private final Object object;

        public SetOfOne(Object object) {
            if (object == null) {
                throw new IllegalArgumentException("SetOfOne must contain a non-null object!");
            }
            this.object = object;
        }

        static /* synthetic */ Object access$0(SetOfOne $0) {
            return $0.object;
        }

        public boolean add(Object param1) {
            throw new UnsupportedOperationException("can't add to SetOfOne");
        }

        public boolean addAll(Collection param1) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException("can't clear SetOfOne");
        }

        public boolean contains(Object object) {
            return this.object.equals(object);
        }

        public boolean containsAll(Collection col) {
            if (col == null || col.size() != 1) {
                return false;
            }
            return this.object.equals(col.iterator().next());
        }

        public boolean equals(Object other) {
            if (other instanceof SetOfOne) {
                return this.object == ((SetOfOne)other).object;
            }
            return false;
        }

        public int hashCode() {
            return this.object.hashCode();
        }

        public boolean isEmpty() {
            return false;
        }

        public Iterator iterator() {
            return new Iterator(this){
                private final /* synthetic */ SetOfOne this$0;
                boolean done;
                {
                    this.this$0 = this$0;
                    this.done = false;
                }

                public boolean hasNext() {
                    return this.done ^ true;
                }

                public Object next() {
                    if (this.done) {
                        throw new NoSuchElementException();
                    }
                    this.done = true;
                    return SetOfOne.access$0(this.this$0);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean remove(Object param1) {
            throw new UnsupportedOperationException("can't remove from SetOfOne");
        }

        public boolean removeAll(Collection param1) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection param1) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return 1;
        }

        public Object[] toArray() {
            return new Object[]{this.object};
        }

        public Object[] toArray(Object[] array) {
            if (array.length < 1) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), 1);
            }
            array[0] = this.object;
            return array;
        }
    }
}

