/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.isc_stmt_handle;
import org.firebirdsql.jdbc.FBBlobField;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBField;
import org.firebirdsql.jdbc.FBFlushableField;
import org.firebirdsql.jdbc.FBLongVarCharField;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jgds.isc_stmt_handle_impl;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

class FBCachedFetcher
implements FBFetcher {
    private Object[] rowsArray;
    private FBStatement fbStatement;
    private FBResultSet rs;
    private int rowNum = 0;
    private boolean isEmpty = false;
    private boolean isBeforeFirst = false;
    private boolean isFirst = false;
    private boolean isLast = false;
    private boolean isAfterLast = false;
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jdbc$FBCachedFetcher != null ? class$org$firebirdsql$jdbc$FBCachedFetcher : (class$org$firebirdsql$jdbc$FBCachedFetcher = FBCachedFetcher.class$("org.firebirdsql.jdbc.FBCachedFetcher")), false);
    static /* synthetic */ Class class$org$firebirdsql$jdbc$FBCachedFetcher;

    FBCachedFetcher(ArrayList rows, FBResultSet rs) throws SQLException {
        this.rowsArray = rows.toArray();
        this.rs = rs;
        this.isEmpty = false;
        this.isBeforeFirst = false;
        this.isFirst = false;
        this.isLast = false;
        this.isAfterLast = false;
        if (this.rowsArray.length == 0) {
            this.isEmpty = true;
        } else {
            this.isBeforeFirst = true;
        }
    }

    FBCachedFetcher(FBConnection c, FBStatement fbStatement, isc_stmt_handle stmt_handle, FBResultSet rs) throws SQLException {
        ArrayList<Object[]> rowsSets = new ArrayList<Object[]>(100);
        ArrayList rows = new ArrayList(100);
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        byte[][] localRow = null;
        this.fbStatement = fbStatement;
        this.rs = rs;
        this.isEmpty = false;
        this.isBeforeFirst = false;
        this.isFirst = false;
        this.isLast = false;
        this.isAfterLast = false;
        boolean[] isBlob = new boolean[rs.xsqlvars.length];
        boolean hasBlobs = false;
        int i = 0;
        while (i < rs.xsqlvars.length) {
            boolean bl = isBlob[i] = FBField.isType(rs.xsqlvars[i], 2004) || FBField.isType(rs.xsqlvars[i], -2) || FBField.isType(rs.xsqlvars[i], -1);
            if (isBlob[i]) {
                hasBlobs = true;
            }
            ++i;
        }
        int rowsCount = 0;
        try {
            int fetchSize = fbStatement.fetchSize;
            if (fetchSize == 0) {
                fetchSize = 400;
            }
            if (!stmt.getAllRowsFetched() && stmt.size() == 0) {
                do {
                    if (fbStatement.maxRows != 0 && fetchSize > fbStatement.maxRows - stmt.size()) {
                        fetchSize = fbStatement.maxRows - stmt.size();
                    }
                    c.fetch(stmt, fetchSize);
                    if (stmt.size() <= 0) continue;
                    rowsSets.add(stmt.getRows());
                    rowsCount += stmt.size();
                    stmt.removeRows();
                } while (!stmt.getAllRowsFetched() && (fbStatement.maxRows == 0 || rowsCount < fbStatement.maxRows));
                int rowCount = 0;
                this.rowsArray = new Object[rowsCount];
                int i2 = 0;
                while (i2 < rowsSets.size()) {
                    Object[] oneSet = (Object[])rowsSets.get(i2);
                    if (oneSet.length > rowsCount - rowCount) {
                        System.arraycopy(oneSet, 0, this.rowsArray, rowCount, rowsCount - rowCount);
                        rowCount = rowsCount;
                    } else {
                        System.arraycopy(oneSet, 0, this.rowsArray, rowCount, oneSet.length);
                        rowCount += oneSet.length;
                    }
                    ++i2;
                }
                rowsSets.clear();
            } else {
                this.rowsArray = stmt.getRows();
                stmt.removeRows();
            }
            if (hasBlobs) {
                int i3 = 0;
                while (i3 < this.rowsArray.length) {
                    localRow = (byte[][])this.rowsArray[i3];
                    int j = 0;
                    while (j < localRow.length) {
                        if (isBlob[j] && localRow[j] != null) {
                            rs.row = localRow;
                            FBField localField = FBField.createField(rs.xsqlvars[j], rs, j, false);
                            FBFlushableField blob = (FBFlushableField)((Object)localField);
                            if (blob instanceof FBBlobField) {
                                ((FBBlobField)blob).setConnection(c);
                            } else if (blob instanceof FBLongVarCharField) {
                                ((FBLongVarCharField)blob).setConnection(c);
                            }
                            localRow[j] = blob.getCachedObject();
                            rs.row = null;
                        }
                        ++j;
                    }
                    ++i3;
                }
            }
            if (this.rowsArray.length == 0) {
                this.isEmpty = true;
            } else {
                this.isBeforeFirst = true;
            }
            c.closeStatement(stmt, false);
        }
        catch (GDSException ge) {
            throw new FBSQLException(ge);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() throws SQLException {
    }

    public boolean getIsAfterLast() {
        return this.isAfterLast;
    }

    public boolean getIsBeforeFirst() {
        return this.isBeforeFirst;
    }

    public boolean getIsEmpty() {
        return this.isEmpty;
    }

    public boolean getIsFirst() {
        return this.isFirst;
    }

    public boolean getIsLast() {
        return this.isLast;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public Statement getStatement() {
        return this.fbStatement;
    }

    public boolean next() throws SQLException {
        this.isBeforeFirst = false;
        this.isFirst = false;
        this.isLast = false;
        this.isAfterLast = false;
        if (log != null) {
            log.debug("FBResultSet next - FBCachedFetcher");
        }
        if (this.isEmpty) {
            return false;
        }
        if (this.rowNum == this.rowsArray.length) {
            this.rs.row = null;
            this.rowNum = 0;
            this.isAfterLast = true;
            return false;
        }
        ++this.rowNum;
        if (this.rowNum == 1) {
            this.isFirst = true;
        }
        if (this.rowNum == this.rowsArray.length) {
            this.isLast = true;
        }
        this.rs.row = (byte[][])this.rowsArray[this.rowNum - 1];
        this.rowsArray[this.rowNum - 1] = null;
        return true;
    }
}

