/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBTpb;
import org.firebirdsql.jca.FBTpbMapper;

public class FBConnectionHelper {
    public static final String TRANSACTION_SERIALIZABLE = "TRANSACTION_SERIALIZABLE";
    public static final String TRANSACTION_REPEATABLE_READ = "TRANSACTION_REPEATABLE_READ";
    public static final String TRANSACTION_READ_COMMITTED = "TRANSACTION_READ_COMMITTED";
    public static final String DPB_PREFIX = "isc_dpb_";
    public static final String TPB_PREFIX = "isc_tpb_";
    public static final String ISC_ENCODINGS_RESOURCE = "isc_encodings.properties";
    public static final String ISC_ENCODING_SIZE_RESOURCE = "isc_encoding_size.properties";
    private static final HashMap dpbTypes = new HashMap();
    private static final HashMap tpbTypes = new HashMap();
    private static final HashMap iscEncodings = new HashMap();
    private static final HashMap javaEncodings = new HashMap();
    private static final HashMap iscEncodingSizes = new HashMap();
    private static boolean encodingsLoaded = false;
    private static boolean encodingSizesLoaded = false;
    private static final int[][] CHARSET_MAXIMUM_SIZE;
    static /* synthetic */ Class class$org$firebirdsql$gds$ISCConstants;
    static /* synthetic */ Class class$org$firebirdsql$jdbc$FBConnectionHelper;

    static {
        Class iscClass = class$org$firebirdsql$gds$ISCConstants != null ? class$org$firebirdsql$gds$ISCConstants : (class$org$firebirdsql$gds$ISCConstants = FBConnectionHelper.class$("org.firebirdsql.gds.ISCConstants"));
        Field[] fields = iscClass.getFields();
        int i = 0;
        while (i < fields.length) {
            block7: {
                if (fields[i].getType().getName().equals("int")) {
                    Integer value;
                    String name = fields[i].getName();
                    try {
                        value = (Integer)fields[i].get(null);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        break block7;
                    }
                    if (name.startsWith(DPB_PREFIX)) {
                        dpbTypes.put(name.substring(DPB_PREFIX.length()), value);
                        dpbTypes.put(name, value);
                    } else if (name.startsWith(TPB_PREFIX)) {
                        tpbTypes.put(name.substring(TPB_PREFIX.length()), value);
                        tpbTypes.put(name, value);
                    }
                }
            }
            ++i;
        }
        int[][] nArrayArray = new int[44][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{1, 1};
        nArrayArray[2] = new int[]{2, 1};
        nArrayArray[3] = new int[]{3, 3};
        nArrayArray[4] = new int[]{5, 2};
        nArrayArray[5] = new int[]{6, 2};
        nArrayArray[6] = new int[]{9, 1};
        nArrayArray[7] = new int[]{10, 1};
        nArrayArray[8] = new int[]{11, 1};
        nArrayArray[9] = new int[]{12, 1};
        nArrayArray[10] = new int[]{13, 1};
        nArrayArray[11] = new int[]{14, 1};
        nArrayArray[12] = new int[]{15, 1};
        nArrayArray[13] = new int[]{16, 1};
        nArrayArray[14] = new int[]{17, 1};
        nArrayArray[15] = new int[]{18, 1};
        nArrayArray[16] = new int[]{19, 1};
        nArrayArray[17] = new int[]{21, 1};
        nArrayArray[18] = new int[]{22, 1};
        nArrayArray[19] = new int[]{23, 1};
        nArrayArray[20] = new int[]{34, 1};
        nArrayArray[21] = new int[]{35, 1};
        nArrayArray[22] = new int[]{36, 1};
        nArrayArray[23] = new int[]{37, 1};
        nArrayArray[24] = new int[]{38, 1};
        nArrayArray[25] = new int[]{39, 1};
        nArrayArray[26] = new int[]{40, 1};
        nArrayArray[27] = new int[]{44, 2};
        nArrayArray[28] = new int[]{45, 1};
        nArrayArray[29] = new int[]{46, 1};
        nArrayArray[30] = new int[]{47, 1};
        nArrayArray[31] = new int[]{48, 1};
        nArrayArray[32] = new int[]{49, 1};
        nArrayArray[33] = new int[]{50, 1};
        nArrayArray[34] = new int[]{51, 1};
        nArrayArray[35] = new int[]{52, 1};
        nArrayArray[36] = new int[]{53, 1};
        nArrayArray[37] = new int[]{54, 1};
        nArrayArray[38] = new int[]{55, 1};
        nArrayArray[39] = new int[]{56, 2};
        nArrayArray[40] = new int[]{57, 2};
        nArrayArray[41] = new int[]{58, 1};
        nArrayArray[42] = new int[]{59, 1};
        nArrayArray[43] = new int[]{60, 1};
        CHARSET_MAXIMUM_SIZE = nArrayArray;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static int getCharacterSetSize(int characterSetId) {
        int i = 0;
        while (i < CHARSET_MAXIMUM_SIZE.length) {
            if (CHARSET_MAXIMUM_SIZE[i][0] == characterSetId) {
                return CHARSET_MAXIMUM_SIZE[i][1];
            }
            ++i;
        }
        return 1;
    }

    public static FBConnectionRequestInfo getCri(Properties info, FBConnectionRequestInfo baseCri) {
        FBConnectionRequestInfo cri = baseCri != null ? new FBConnectionRequestInfo(baseCri) : new FBConnectionRequestInfo(FBConnectionHelper.getDefaultCri());
        Iterator keys = ((Hashtable)info).keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = info.getProperty(key);
            Integer type = (Integer)dpbTypes.get(key);
            if (type == null) continue;
            try {
                byte byteValue = Byte.parseByte(value);
                cri.setProperty((int)type, new byte[]{byteValue});
            }
            catch (NumberFormatException numberFormatException) {
                cri.setProperty((int)type, value);
            }
        }
        return cri;
    }

    public static FBConnectionRequestInfo getDefaultCri() {
        FBConnectionRequestInfo result = new FBConnectionRequestInfo();
        return result;
    }

    public static String getDefaultJavaEncoding() {
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(new byte[2]));
        return reader.getEncoding();
    }

    public static String getIscEncoding(String javaEncoding) {
        if (!encodingsLoaded) {
            FBConnectionHelper.loadEncodings();
        }
        return (String)javaEncodings.get(javaEncoding);
    }

    public static int getIscEncodingSize(String iscEncoding) {
        Byte result;
        if (!encodingSizesLoaded) {
            FBConnectionHelper.loadEncodingSizes();
        }
        if ((result = (Byte)iscEncodingSizes.get(iscEncoding)) == null) {
            return 1;
        }
        return result.byteValue();
    }

    public static String getJavaEncoding(String iscEncoding) {
        if (!encodingsLoaded) {
            FBConnectionHelper.loadEncodings();
        }
        String javaEncoding = (String)iscEncodings.get(iscEncoding);
        String defaultEncoding = FBConnectionHelper.getDefaultJavaEncoding();
        if (javaEncoding == null || javaEncoding.equalsIgnoreCase(defaultEncoding)) {
            return null;
        }
        return javaEncoding;
    }

    public static FBTpb getTpb(Properties info) {
        FBTpb tpb = new FBTpb(FBTpbMapper.DEFAULT_MAPPER);
        Iterator keys = ((Hashtable)info).keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Integer type = (Integer)tpbTypes.get(key);
            if (type == null) continue;
            tpb.add(type);
        }
        return tpb;
    }

    public static FBTpbMapper getTpbMapper(Properties info) throws FBResourceException {
        String tpbMapping = info.getProperty("tpb_mapping");
        FBTpbMapper tpbMapper = null;
        if (tpbMapping != null) {
            tpbMapper = new FBTpbMapper(tpbMapping, (class$org$firebirdsql$jdbc$FBConnectionHelper != null ? class$org$firebirdsql$jdbc$FBConnectionHelper : (class$org$firebirdsql$jdbc$FBConnectionHelper = FBConnectionHelper.class$("org.firebirdsql.jdbc.FBConnectionHelper"))).getClassLoader());
        } else {
            HashMap mapping = new HashMap();
            if (((Hashtable)info).containsKey(TRANSACTION_SERIALIZABLE)) {
                mapping.put(TRANSACTION_SERIALIZABLE, ((Hashtable)info).get(TRANSACTION_SERIALIZABLE));
            }
            if (((Hashtable)info).containsKey(TRANSACTION_REPEATABLE_READ)) {
                mapping.put(TRANSACTION_REPEATABLE_READ, ((Hashtable)info).get(TRANSACTION_REPEATABLE_READ));
            }
            if (((Hashtable)info).containsKey(TRANSACTION_READ_COMMITTED)) {
                mapping.put(TRANSACTION_READ_COMMITTED, ((Hashtable)info).get(TRANSACTION_READ_COMMITTED));
            }
            if (mapping.size() > 0) {
                tpbMapper = new FBTpbMapper(mapping);
            }
        }
        return tpbMapper;
    }

    public static Integer getTpbParam(String name) {
        return (Integer)tpbTypes.get(name);
    }

    private static void loadEncodingSizes() {
        ClassLoader cl = (class$org$firebirdsql$jdbc$FBConnectionHelper != null ? class$org$firebirdsql$jdbc$FBConnectionHelper : (class$org$firebirdsql$jdbc$FBConnectionHelper = FBConnectionHelper.class$("org.firebirdsql.jdbc.FBConnectionHelper"))).getClassLoader();
        InputStream in = null;
        in = cl == null ? ClassLoader.getSystemResourceAsStream(ISC_ENCODING_SIZE_RESOURCE) : cl.getResourceAsStream(ISC_ENCODING_SIZE_RESOURCE);
        if (in == null) {
            return;
        }
        Properties props = new Properties();
        try {
            try {
                props.load(in);
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
                Object var4_7 = null;
                try {
                    in.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return;
            }
            Object var4_8 = null;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            try {
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Iterator iterator = ((Hashtable)props).keySet().iterator();
        while (iterator.hasNext()) {
            String iscEncoding = (String)iterator.next();
            String size = (String)((Hashtable)props).get(iscEncoding);
            iscEncodingSizes.put(iscEncoding, new Byte(size));
        }
        encodingSizesLoaded = true;
    }

    private static void loadEncodings() {
        ClassLoader cl = (class$org$firebirdsql$jdbc$FBConnectionHelper != null ? class$org$firebirdsql$jdbc$FBConnectionHelper : (class$org$firebirdsql$jdbc$FBConnectionHelper = FBConnectionHelper.class$("org.firebirdsql.jdbc.FBConnectionHelper"))).getClassLoader();
        InputStream in = null;
        in = cl == null ? ClassLoader.getSystemResourceAsStream(ISC_ENCODINGS_RESOURCE) : cl.getResourceAsStream(ISC_ENCODINGS_RESOURCE);
        if (in == null) {
            return;
        }
        Properties props = new Properties();
        try {
            try {
                props.load(in);
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
                Object var4_7 = null;
                try {
                    in.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return;
            }
            Object var4_8 = null;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            try {
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        iscEncodings.putAll(props);
        Iterator iterator = ((Hashtable)props).keySet().iterator();
        while (iterator.hasNext()) {
            String iscEncoding = (String)iterator.next();
            String javaEncoding = (String)((Hashtable)props).get(iscEncoding);
            javaEncodings.put(javaEncoding, iscEncoding);
        }
        encodingsLoaded = true;
    }
}

