/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.text.BreakIterator;
import org.firebirdsql.jdbc.FBSQLParseException;

public class FBEscapedParser {
    protected static final int UNDEFINED_STATE = 0;
    protected static final int NORMAL_STATE = 1;
    protected static final int LITERAL_STATE = 2;
    protected static final int ESCAPE_STATE = 4;
    public static final String ESCAPE_CALL_KEYWORD = "call";
    public static final String ESCAPE_CALL_KEYWORD2 = "?=";
    public static final String ESCAPE_DATE_KEYWORD = "d";
    public static final String ESCAPE_TIME_KEYWORD = "t";
    public static final String ESCAPE_TIMESTAMP_KEYWORD = "ts";
    public static final String ESCAPE_FUNCTION_KEYWORD = "fn";
    public static final String ESCAPE_ESCAPE_KEYWORD = "escape";
    public static final String ESCAPE_OUTERJOIN_KEYWORS = "oj";
    protected static final String CHECK_CALL_1 = "{call";
    protected static final String CHECK_CALL_2 = "{?=";
    protected static final String CHECK_DATE = "{d";
    protected static final String CHECK_TIME = "{t";
    protected static final String CHECK_TIMESTAMP = "{ts";
    protected static final String CHECK_FUNCTION = "{fn";
    protected static final String CHECK_ESCAPE = "{escape";
    protected static final String CHECK_OUTERJOIN = "{oj";
    private int state = 1;
    private int lastState = 1;
    private int nestedEscaped = 0;

    protected boolean checkForEscapes(String sql) {
        return sql.indexOf(CHECK_CALL_1) != -1 || sql.indexOf(CHECK_CALL_2) != -1 || sql.indexOf(CHECK_DATE) != -1 || sql.indexOf(CHECK_ESCAPE) != -1 || sql.indexOf(CHECK_FUNCTION) != -1 || sql.indexOf(CHECK_OUTERJOIN) != -1 || sql.indexOf(CHECK_TIME) != -1 || sql.indexOf(CHECK_TIMESTAMP) != -1;
    }

    protected String convertOuterJoin(String outerJoin) throws FBSQLParseException {
        return outerJoin;
    }

    protected String convertProcedureCall(String procedureCall) throws FBSQLParseException {
        FBEscapedParser tempParser = new FBEscapedParser();
        return "EXECUTE PROCEDURE " + tempParser.parse(procedureCall);
    }

    protected String escapeToNative(String escaped) throws FBSQLParseException {
        StringBuffer keyword = new StringBuffer();
        StringBuffer payload = new StringBuffer();
        this.processEscaped(escaped, keyword, payload);
        if (keyword.toString().equalsIgnoreCase(ESCAPE_CALL_KEYWORD2)) {
            throw new FBSQLParseException("Escaped procedure calls {?=call ...} are not yet supported. Use native EXECUTE PROCEDURE <proc_name>, or  SELECT * FROM <proc_name> or {call ...} calls instead.");
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_CALL_KEYWORD)) {
            return this.convertProcedureCall(payload.toString().trim());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_DATE_KEYWORD)) {
            return this.toDateString(payload.toString().trim());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_ESCAPE_KEYWORD)) {
            throw new FBSQLParseException("Escaped escapes are not supported.");
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_FUNCTION_KEYWORD)) {
            throw new FBSQLParseException("Escaped functions are not supported.");
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_OUTERJOIN_KEYWORS)) {
            return this.convertOuterJoin(payload.toString().trim());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_TIME_KEYWORD)) {
            return this.toTimeString(payload.toString().trim());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_TIMESTAMP_KEYWORD)) {
            return this.toTimestampString(payload.toString().trim());
        }
        throw new FBSQLParseException("Unknown keyword " + keyword + " for escaped syntax.");
    }

    protected int getLastState() {
        return this.lastState;
    }

    protected int getState() {
        return this.state;
    }

    protected boolean isInState(int state) {
        return this.getState() == state;
    }

    public String parse(String sql) throws FBSQLParseException {
        if (!this.checkForEscapes(sql)) {
            return sql;
        }
        char[] sqlbuff = sql.toCharArray();
        StringBuffer buffer = new StringBuffer();
        StringBuffer escape = new StringBuffer();
        int i = 0;
        while (i < sqlbuff.length) {
            this.switchState(sqlbuff[i]);
            if (this.isInState(1) && (this.wasInState(1) || this.wasInState(2))) {
                buffer.append(sqlbuff[i]);
            } else if (this.isInState(1) && this.wasInState(4)) {
                buffer.append(this.escapeToNative(escape.substring(1, escape.length())));
                escape = new StringBuffer();
                this.setState(1);
            } else if (this.isInState(4)) {
                escape.append(sqlbuff[i]);
            } else if (this.isInState(2)) {
                buffer.append(sqlbuff[i]);
            }
            ++i;
        }
        return buffer.toString();
    }

    protected void processEscaped(String escaped, StringBuffer keyword, StringBuffer payload) {
        if (keyword.length() != 0) {
            keyword.delete(0, keyword.length());
        }
        if (payload.length() != 0) {
            payload.delete(0, payload.length());
        }
        BreakIterator iterator = BreakIterator.getWordInstance();
        iterator.setText(escaped);
        int keyStart = iterator.first();
        int keyEnd = iterator.next();
        keyword.append(escaped.substring(keyStart, keyEnd));
        payload.append(escaped.substring(keyEnd, escaped.length()));
    }

    protected void setState(int state) throws IllegalStateException {
        int tempState = this.getLastState();
        this.lastState = this.getState();
        if (state == 1) {
            this.state = 1;
        } else if (state == 2) {
            this.state = 2;
        } else if (state == 4) {
            this.state = 4;
        } else {
            this.lastState = tempState;
            throw new IllegalStateException("State " + state + " is unknown.");
        }
    }

    public static boolean supportsLikeEscapeClause() {
        return false;
    }

    public static boolean supportsStoredProcedures() {
        return true;
    }

    protected void switchState(char testChar) {
        switch (testChar) {
            case '\'': {
                if (this.isInState(1)) {
                    this.setState(2);
                    break;
                }
                if (!this.isInState(2)) break;
                this.setState(1);
                break;
            }
            case '{': {
                if (this.isInState(1)) {
                    this.setState(4);
                }
                ++this.nestedEscaped;
                break;
            }
            case '}': {
                if (this.isInState(4)) {
                    --this.nestedEscaped;
                }
                if (this.nestedEscaped != 0) break;
                this.setState(1);
                break;
            }
        }
    }

    protected String toDateString(String dateStr) throws FBSQLParseException {
        return dateStr;
    }

    protected String toTimeString(String timeStr) throws FBSQLParseException {
        return timeStr;
    }

    protected String toTimestampString(String timestampStr) throws FBSQLParseException {
        return timestampStr;
    }

    protected boolean wasInState(int state) {
        return this.getLastState() == state;
    }
}

