/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.isc_stmt_handle;
import org.firebirdsql.jdbc.FBCachedFetcher;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBField;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSetMetaData;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jdbc.FBStatementFetcher;
import org.firebirdsql.jdbc.FBUpdatableFetcher;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FBResultSet
implements ResultSet {
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jdbc$FBResultSet != null ? class$org$firebirdsql$jdbc$FBResultSet : (class$org$firebirdsql$jdbc$FBResultSet = FBResultSet.class$("org.firebirdsql.jdbc.FBResultSet")), false);
    private FBFetcher fbFetcher;
    protected FBConnection c;
    public XSQLVAR[] xsqlvars;
    public byte[][] row = null;
    private int maxRows = 0;
    private int fetchSize = 0;
    private boolean wasNull = false;
    private boolean wasNullValid = false;
    private boolean opened = false;
    private boolean closed = false;
    private boolean trimStrings;
    private SQLWarning firstWarning = null;
    private FBField[] fields = null;
    private HashMap colNames = new HashMap();
    private String cursorName;
    private FBObjectListener.ResultSetListener listener;
    static /* synthetic */ Class class$org$firebirdsql$jdbc$FBResultSet;

    FBResultSet(FBConnection c, FBStatement fbstatement, isc_stmt_handle stmt, FBObjectListener.ResultSetListener listener) throws SQLException {
        this.c = c;
        this.cursorName = fbstatement.getCursorName();
        this.listener = listener;
        this.xsqlvars = stmt.getOutSqlda().sqlvar;
        this.maxRows = fbstatement.getMaxRows();
        this.prepareVars(false);
        boolean updatableCursor = fbstatement.isUpdatableCursor();
        this.fbFetcher = updatableCursor ? new FBUpdatableFetcher(this.c, fbstatement, stmt, this) : new FBStatementFetcher(this.c, fbstatement, stmt, this);
    }

    FBResultSet(FBConnection c, FBStatement fbStatement, isc_stmt_handle stmt, boolean trimStrings, FBObjectListener.ResultSetListener listener) throws SQLException {
        this.c = c;
        this.trimStrings = trimStrings;
        this.listener = listener;
        this.maxRows = fbStatement.getMaxRows();
        this.xsqlvars = stmt.getOutSqlda().sqlvar;
        this.prepareVars(true);
        this.fbFetcher = new FBCachedFetcher(this.c, fbStatement, stmt, this);
        if (c.willEndTransaction()) {
            FBCachedFetcher fBCachedFetcher = (FBCachedFetcher)this.fbFetcher;
        }
    }

    FBResultSet(XSQLVAR[] xsqlvars, ArrayList rows) throws SQLException {
        this.maxRows = 0;
        this.fbFetcher = new FBCachedFetcher(rows, this);
        this.xsqlvars = xsqlvars;
        this.prepareVars(true);
    }

    public boolean absolute(int row) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    protected void addWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = warning;
        } else {
            SQLWarning lastWarning = this.firstWarning;
            while (lastWarning.getNextWarning() != null) {
                lastWarning = lastWarning.getNextWarning();
            }
            lastWarning.setNextWarning(warning);
        }
    }

    public void afterLast() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void beforeFirst() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    public void close() throws SQLException {
        if (this.closed) {
            throw new SQLException("The resultSet is closed");
        }
        this.wasNullValid = false;
        this.closed = true;
        try {
            int i = 0;
            while (i < this.fields.length) {
                this.fields[i].close();
                ++i;
            }
        }
        finally {
            Object var2_2 = null;
            this.fbFetcher.close();
        }
        if (this.listener != null) {
            this.listener.resultSetClosed(this);
        }
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public int findColumn(String columnName) throws SQLException {
        if (columnName == null || columnName.equals("")) {
            throw new SQLException("zero length identifiers not allowed");
        }
        if (columnName.startsWith("\"") && columnName.endsWith("\"")) {
            columnName = columnName.substring(1, columnName.length() - 1);
            int i = 0;
            while (i < this.xsqlvars.length) {
                if (columnName.equals(this.xsqlvars[i].aliasname)) {
                    return ++i;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.xsqlvars.length) {
                if (columnName.equals(this.xsqlvars[i2].sqlname)) {
                    return ++i2;
                }
                ++i2;
            }
        } else {
            int i = 0;
            while (i < this.xsqlvars.length) {
                if (columnName.equalsIgnoreCase(this.xsqlvars[i].aliasname)) {
                    return ++i;
                }
                ++i;
            }
            int i3 = 0;
            while (i3 < this.xsqlvars.length) {
                if (columnName.equalsIgnoreCase(this.xsqlvars[i3].sqlname)) {
                    return ++i3;
                }
                ++i3;
            }
        }
        throw new SQLException("column name " + columnName + " not found in result set.");
    }

    public boolean first() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public Array getArray(int i) throws SQLException {
        return this.getField(i).getArray();
    }

    public Array getArray(String columnName) throws SQLException {
        return this.getField(columnName).getArray();
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getAsciiStream();
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getField(columnName).getAsciiStream();
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBigDecimal();
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getField(columnIndex).getBigDecimal(scale);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getField(columnName).getBigDecimal();
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getField(columnName).getBigDecimal(scale);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBinaryStream();
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getField(columnName).getBinaryStream();
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBlob();
    }

    public Blob getBlob(String columnName) throws SQLException {
        return this.getField(columnName).getBlob();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBoolean();
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getField(columnName).getBoolean();
    }

    public byte getByte(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getByte();
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getField(columnName).getByte();
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBytes();
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getField(columnName).getBytes();
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getCharacterStream();
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getField(columnName).getCharacterStream();
    }

    public Clob getClob(int i) throws SQLException {
        return this.getField(i).getClob();
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.getField(columnName).getClob();
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public String getCursorName() throws SQLException {
        return this.cursorName;
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getDate();
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getField(columnIndex).getDate(cal);
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getField(columnName).getDate();
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getField(columnName).getDate(cal);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getDouble();
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getField(columnName).getDouble();
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    private FBField getField(int columnIndex) throws SQLException {
        if (this.closed) {
            throw new SQLException("The resultSet is closed");
        }
        if (!this.opened) {
            throw new SQLException("The resultSet is not in a row, use next");
        }
        if (columnIndex > this.xsqlvars.length) {
            throw new SQLException("invalid column index");
        }
        FBField field = this.fields[columnIndex - 1];
        this.wasNullValid = true;
        this.wasNull = field.isNull();
        return field;
    }

    private FBField getField(String columnName) throws SQLException {
        if (this.closed) {
            throw new SQLException("The resultSet is closed");
        }
        if (!this.opened) {
            throw new SQLException("The resultSet is not in a row, use next");
        }
        if (columnName == null) {
            throw new SQLException("column identifier must be not null");
        }
        FBField field = (FBField)this.colNames.get(columnName);
        if (field == null) {
            int colNum = this.findColumn(columnName);
            this.colNames.put(columnName, this.fields[colNum - 1]);
            field = this.fields[colNum - 1];
        }
        if (field == null) {
            throw new SQLException("column name " + columnName + " not found in result set.");
        }
        this.wasNullValid = true;
        this.wasNull = field.isNull();
        return field;
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getFloat();
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getField(columnName).getFloat();
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getInt();
    }

    public int getInt(String columnName) throws SQLException {
        return this.getField(columnName).getInt();
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getLong();
    }

    public long getLong(String columnName) throws SQLException {
        return this.getField(columnName).getLong();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new FBResultSetMetaData(this.xsqlvars, this.c);
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getObject();
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this.getField(i).getObject(map);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getField(columnName).getObject();
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        return this.getField(columnName).getObject(map);
    }

    public Ref getRef(int i) throws SQLException {
        return this.getField(i).getRef();
    }

    public Ref getRef(String columnName) throws SQLException {
        return this.getField(columnName).getRef();
    }

    public int getRow() throws SQLException {
        return this.fbFetcher.getRowNum();
    }

    public short getShort(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getShort();
    }

    public short getShort(String columnName) throws SQLException {
        return this.getField(columnName).getShort();
    }

    public Statement getStatement() {
        return this.fbFetcher.getStatement();
    }

    public String getString(int columnIndex) throws SQLException {
        if (this.trimStrings) {
            String result = this.getField(columnIndex).getString();
            return result != null ? result.trim() : null;
        }
        return this.getField(columnIndex).getString();
    }

    public String getString(String columnName) throws SQLException {
        if (this.trimStrings) {
            String result = this.getField(columnName).getString();
            return result != null ? result.trim() : null;
        }
        return this.getField(columnName).getString();
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getTime();
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getField(columnIndex).getTime(cal);
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getField(columnName).getTime();
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getField(columnName).getTime(cal);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getTimestamp();
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getField(columnIndex).getTimestamp(cal);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getField(columnName).getTimestamp();
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getField(columnName).getTimestamp(cal);
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public URL getURL(int param1) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public URL getURL(String param1) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getUnicodeStream();
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getField(columnName).getUnicodeStream();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    protected XSQLVAR getXsqlvar(int columnIndex) {
        return this.xsqlvars[columnIndex - 1];
    }

    public void insertRow() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public boolean isAfterLast() throws SQLException {
        return this.fbFetcher.getIsAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.fbFetcher.getIsBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        return this.fbFetcher.getIsFirst();
    }

    public boolean isLast() throws SQLException {
        return this.fbFetcher.getIsLast();
    }

    public boolean last() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public boolean next() throws SQLException {
        if (this.closed) {
            throw new SQLException("The resultSet is closed");
        }
        this.wasNullValid = false;
        this.opened = true;
        int i = 0;
        while (i < this.fields.length) {
            this.fields[i].close();
            ++i;
        }
        return this.fbFetcher.next();
    }

    private void prepareVars(boolean cached) throws SQLException {
        this.fields = new FBField[this.xsqlvars.length];
        this.colNames = new HashMap(this.xsqlvars.length, 1.0f);
        int i = 0;
        while (i < this.xsqlvars.length) {
            this.fields[i] = FBField.createField(this.xsqlvars[i], this, i, cached);
            this.fields[i].setConnection(this.c);
            ++i;
        }
    }

    public boolean previous() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void refreshRow() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public boolean relative(int rows) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public boolean rowDeleted() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public boolean rowInserted() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public boolean rowUpdated() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLException("can't set fetch direction");
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new SQLException("can't set negative fetch size");
        }
        if (this.maxRows > 0 && rows > this.maxRows) {
            throw new SQLException("can't set fetch size > maxRows");
        }
        this.fetchSize = rows;
    }

    public void updateArray(int param1, Array param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void updateArray(String param1, Array param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateBlob(int param1, Blob param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void updateBlob(String param1, Blob param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateClob(int param1, Clob param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void updateClob(String param1, Clob param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateInt(String columnName, int x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateLong(String columnName, long x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateNull(String columnName) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void updateRef(int param1, Ref param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void updateRef(String param1, Ref param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateShort(String columnName, short x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateString(String columnName, String x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public boolean wasNull() throws SQLException {
        if (!this.wasNullValid) {
            throw new SQLException("look at a column before testing null!");
        }
        if (this.row == null) {
            throw new SQLException("No row available for wasNull!");
        }
        return this.wasNull;
    }
}

