/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLWarning;
import org.firebirdsql.gds.GDSException;

public class FBSQLWarning
extends SQLWarning {
    private GDSException original;
    private String message;

    public FBSQLWarning(GDSException original) {
        super(original.getMessage());
        if (!original.isWarning()) {
            throw new IllegalArgumentException("Only warnings can be wrapped.");
        }
        this.original = original;
        this.message = original.getMessage();
    }

    public int getErrorCode() {
        if (this.original instanceof GDSException) {
            return this.original.getIntParam();
        }
        return 0;
    }

    public Exception getInternalException() {
        return this.original;
    }

    public String getMessage() {
        return this.message;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.original != null) {
            s.print("at ");
            this.original.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.original != null) {
            s.print("at ");
            this.original.printStackTrace(s);
        }
    }
}

