/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.sql.DataSource;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBPoolingConnectionManager;
import org.firebirdsql.jca.FBTpb;
import org.firebirdsql.jca.ManagedConnectionPool;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FBSimpleDataSource;

public class FBWrappingDataSource
extends FBSimpleDataSource
implements DataSource,
Serializable,
Referenceable {
    private transient FBPoolingConnectionManager cm;
    private boolean pooling = false;
    private final ManagedConnectionPool.PoolParams poolParams = new ManagedConnectionPool.PoolParams();

    public int getBlockingTimeout() {
        return this.poolParams.blockingTimeout;
    }

    public int getConnectionCount() {
        if (this.cm == null) {
            return 0;
        }
        return this.cm.getConnectionCount();
    }

    public FBConnectionRequestInfo getConnectionRequestInfo() {
        return this.mcf.getDefaultConnectionRequestInfo();
    }

    protected synchronized DataSource getDataSource() throws SQLException {
        if (this.ds == null) {
            try {
                if (this.getDatabase() == null) {
                    throw new SQLException("DataSource has no databaseName");
                }
                if (this.pooling) {
                    this.cm = new FBPoolingConnectionManager(this.poolParams, this.mcf);
                    this.ds = (FBDataSource)this.mcf.createConnectionFactory(this.cm);
                } else {
                    this.ds = (FBDataSource)this.mcf.createConnectionFactory();
                }
            }
            catch (ResourceException re) {
                throw new SQLException("Couldn't create ConnectionFactory! " + re);
            }
        }
        return this.ds;
    }

    public long getIdleTimeout() {
        return this.poolParams.idleTimeout;
    }

    public long getIdleTimeoutMinutes() {
        return this.poolParams.idleTimeout / 60000L;
    }

    public int getMaxSize() {
        return this.poolParams.maxSize;
    }

    public int getMinSize() {
        return this.poolParams.minSize;
    }

    public boolean getPooling() {
        return this.pooling;
    }

    public Integer getTransactionIsolation() throws ResourceException {
        return this.mcf.getTransactionIsolation();
    }

    public FBTpb getTransactionParameters() {
        return this.mcf.getTpb();
    }

    public void setBlockingTimeout(int blockingTimeout) {
        this.poolParams.blockingTimeout = blockingTimeout;
    }

    public void setConnectionRequestInfo(FBConnectionRequestInfo cri) {
        this.mcf.setConnectionRequestInfo(cri);
    }

    public void setIdleTimeout(long idleTimeout) {
        this.poolParams.idleTimeout = idleTimeout;
    }

    public void setIdleTimeoutMinutes(long idleTimeout) {
        this.poolParams.idleTimeout = idleTimeout * 1000L * 60L;
    }

    public void setMaxSize(int maxSize) {
        this.poolParams.maxSize = maxSize;
    }

    public void setMinSize(int minSize) {
        this.poolParams.minSize = minSize;
    }

    public void setPooling(boolean pooling) {
        this.pooling = pooling;
    }

    public void setTransactionIsolation(Integer level) throws ResourceException {
        this.mcf.setTransactionIsolation(level);
    }

    public void setTransactionParameters(FBTpb tpb) {
        this.mcf.setTpb(tpb);
    }
}

