/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.translators.NumericTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.VDNNumber;
import java.math.BigDecimal;
import java.sql.SQLException;

public class ShortNumericTranslator
extends NumericTranslator {
    protected ShortNumericTranslator(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
    }

    public BigDecimal getBigDecimal(int n, SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        BigDecimal bigDecimal = null;
        try {
            if (!this.isNull(sQLParamController, structuredMem)) {
                bigDecimal = VDNNumber.shortnumber2BigDecimal(structuredMem.getBytes(this.bufpos, this.physicalLength - 1));
                bigDecimal = bigDecimal.setScale(n);
            }
            return bigDecimal;
        }
        catch (ArithmeticException arithmeticException) {
            throw this.newParseException(bigDecimal + " scale: " + n, null);
        }
    }

    public BigDecimal getBigDecimal(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        BigDecimal bigDecimal = null;
        try {
            if (!this.isNull(sQLParamController, structuredMem)) {
                bigDecimal = VDNNumber.shortnumber2BigDecimal(structuredMem.getBytes(this.bufpos, this.physicalLength - 1));
                if (!this.isFloatingPoint) {
                    bigDecimal = bigDecimal.setScale(this.frac);
                }
            }
            return bigDecimal;
        }
        catch (ArithmeticException arithmeticException) {
            throw this.newParseException(bigDecimal + " scale: " + this.frac, null);
        }
    }

    public double getDouble(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        double d = 0.0;
        if (!this.isNull(sQLParamController, structuredMem)) {
            d = VDNNumber.shortnumber2Double(structuredMem.getBytes(this.bufpos, this.physicalLength - 1));
        }
        return d;
    }

    public float getFloat(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        double d = 0.0;
        if (!this.isNull(sQLParamController, structuredMem)) {
            d = VDNNumber.shortnumber2Double(structuredMem.getBytes(this.bufpos, this.physicalLength - 1));
        }
        if (d < 1.4E-45 && d > -1.4E-45) {
            return 0.0f;
        }
        if (d > 3.4028235E38 || d < -3.4028235E38) {
            throw this.newParseException(Double.toString(d), null);
        }
        return (float)d;
    }
}

