/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.authorize;

import com.ecyrd.jspwiki.auth.GroupPrincipal;
import java.security.Principal;
import java.util.Date;
import java.util.Vector;

public class Group {
    static final String[] RESTRICTED_GROUPNAMES = new String[]{"Anonymous", "All", "Asserted", "Authenticated"};
    private final Vector<Principal> m_members = new Vector();
    private String m_creator = null;
    private Date m_created = null;
    private String m_modifier = null;
    private Date m_modified = null;
    private final String m_name;
    private final Principal m_principal;
    private final String m_wiki;

    protected Group(String name, String wiki) {
        this.m_name = name;
        this.m_wiki = wiki;
        this.m_principal = new GroupPrincipal(name);
    }

    public synchronized boolean add(Principal user) {
        if (this.isMember(user)) {
            return false;
        }
        this.m_members.add(user);
        return true;
    }

    public synchronized void clear() {
        this.m_members.clear();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Group)) {
            return false;
        }
        Group g = (Group)o;
        if (g.m_members.size() != this.m_members.size()) {
            return false;
        }
        if (this.getName() != null && !this.getName().equals(g.getName())) {
            return false;
        }
        if (this.getName() == null && g.getName() != null) {
            return false;
        }
        for (Principal principal : this.m_members) {
            if (g.isMember(principal)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hc = 0;
        for (Principal member : this.m_members) {
            hc ^= ((Object)member).hashCode();
        }
        return hc;
    }

    public synchronized Date getCreated() {
        return this.m_created;
    }

    public final synchronized String getCreator() {
        return this.m_creator;
    }

    public synchronized Date getLastModified() {
        return this.m_modified;
    }

    public final synchronized String getModifier() {
        return this.m_modifier;
    }

    public String getName() {
        return this.m_name;
    }

    public Principal getPrincipal() {
        return this.m_principal;
    }

    public String getWiki() {
        return this.m_wiki;
    }

    public boolean isMember(Principal principal) {
        return this.findMember(principal.getName()) != null;
    }

    public Principal[] members() {
        return this.m_members.toArray(new Principal[this.m_members.size()]);
    }

    public synchronized boolean remove(Principal user) {
        if ((user = this.findMember(user.getName())) == null) {
            return false;
        }
        this.m_members.remove(user);
        return true;
    }

    public synchronized void setCreated(Date date) {
        this.m_created = date;
    }

    public final synchronized void setCreator(String creator) {
        this.m_creator = creator;
    }

    public synchronized void setLastModified(Date date) {
        this.m_modified = date;
    }

    public final synchronized void setModifier(String modifier) {
        this.m_modifier = modifier;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(Group " + this.getName() + ")");
        return sb.toString();
    }

    private Principal findMember(String name) {
        for (Principal member : this.m_members) {
            if (!member.getName().equals(name)) continue;
            return member;
        }
        return null;
    }
}

