/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.app;

import ise.library.LambdaLayout;
import ise.library.Log;
import ise.library.Nav;
import ise.library.Navable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class AboutDialog
extends JDialog
implements Navable {
    private JEditorPane editor;
    private JScrollPane scrollpane;
    private Nav nav;
    private URL initialURL = null;

    public AboutDialog(Frame frame, String string, String string2, String string3, boolean bl) {
        super(frame, string, true);
        this.editor = new JEditorPane(string2, string3);
        this.init(bl);
    }

    public AboutDialog(Frame frame, String string, URL uRL, boolean bl) throws Exception {
        super(frame, string, true);
        Log.log("AboutDialog, contents = " + uRL);
        Log.log("AboutDialog, content type = " + uRL.openConnection().getContentType());
        this.editor = new JEditorPane(uRL);
        this.initialURL = uRL;
        this.init(bl);
    }

    private void init(boolean bl) {
        this.editor.setEditable(false);
        this.editor.addHyperlinkListener(new LinkListener());
        BorderLayout borderLayout = new BorderLayout();
        JPanel jPanel = new JPanel(borderLayout);
        this.scrollpane = new JScrollPane(this.editor);
        jPanel.add((Component)this.scrollpane, "Center");
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.setVisible(false);
                AboutDialog.this.dispose();
            }
        });
        JPanel jPanel2 = new JPanel();
        if (bl) {
            jPanel2.setLayout(new LambdaLayout());
            this.nav = new Nav(this);
            jPanel2.add((Component)this.nav, "0, 0, 1, 1, W, , 5");
            jPanel2.add((Component)jButton, "1, 0, 1, 1, E, , 5");
            if (this.initialURL != null) {
                this.nav.update(this.initialURL);
            }
        } else {
            jPanel2.add(jButton);
        }
        jPanel.add((Component)jPanel2, "South");
        this.setContentPane(jPanel);
        this.pack();
        this.setSize(new Dimension(500, 400));
    }

    public void setVisible(boolean bl) {
        this.editor.getCaret().setDot(0);
        this.scrollpane.getViewport().scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        super.setVisible(bl);
    }

    public void setPosition(Object object) {
        if (object instanceof URL) {
            try {
                this.editor.setPage((URL)object);
            }
            catch (Exception exception) {}
        } else if (object instanceof String) {
            this.editor.scrollToReference((String)object);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        AboutDialog aboutDialog = new AboutDialog(jFrame, "About", "text/html", "<html>Here is an About Dialog.</html>", false);
        aboutDialog.setVisible(true);
    }

    class LinkListener
    implements HyperlinkListener {
        private Cursor hand_cursor = Cursor.getPredefinedCursor(12);
        private Cursor default_cursor = Cursor.getPredefinedCursor(0);

        LinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                    hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                } else {
                    try {
                        URL uRL = hyperlinkEvent.getURL();
                        if (uRL != null) {
                            jEditorPane.setPage(uRL);
                            if (AboutDialog.this.nav != null) {
                                AboutDialog.this.nav.update(uRL);
                            }
                        } else {
                            String string = hyperlinkEvent.getDescription();
                            string = string.substring(1);
                            jEditorPane.scrollToReference(string);
                            if (AboutDialog.this.nav != null) {
                                AboutDialog.this.nav.update(string);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        JOptionPane.showMessageDialog(AboutDialog.this, "Unable to open URL.", "Hyperlink Error", 0);
                    }
                }
            } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                jEditorPane.setCursor(this.hand_cursor);
            } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                jEditorPane.setCursor(this.default_cursor);
            }
        }
    }
}

