/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.common;

import ise.antelope.common.AntUtils;
import ise.library.PrivilegedAccessor;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JProgressBar;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.xml.sax.AttributeList;

public class AntProgressListener
extends JProgressBar
implements BuildListener {
    private int total;
    private Color errorColor = Color.red;
    private Color defaultColor = new Color(0, 153, 51);
    private double ant_version = 0.0;
    private HashMap project_cache = new HashMap();

    public AntProgressListener() {
        this.setStringPainted(true);
    }

    public void buildStarted(BuildEvent buildEvent) {
        this.setStringPainted(true);
        this.setValue(0);
        this.setString(null);
        this.total = 0;
        this.setForeground(this.defaultColor);
    }

    public void buildFinished(BuildEvent buildEvent) {
        if (buildEvent.getException() != null) {
            buildEvent.getException().printStackTrace();
            this.setForeground(this.errorColor);
            this.setString("Failed");
        } else {
            this.setString("Complete");
        }
        this.setIndeterminate(false);
        this.setValue(this.getMaximum());
    }

    public void setExecutingTarget(Project project, ArrayList arrayList) {
        if (project == null) {
            throw new IllegalArgumentException("project is null");
        }
        if (arrayList == null) {
            throw new IllegalArgumentException("target list is null");
        }
        Hashtable hashtable = project.getTargets();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Target target = (Target)hashtable.get(string);
            this.total += this.countTasks(target);
        }
        if (this.total == 1) {
            this.setIndeterminate(true);
        }
        this.setMaximum(this.total);
    }

    public void targetStarted(BuildEvent buildEvent) {
        this.setString(buildEvent.getTarget().getName());
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void taskStarted(BuildEvent buildEvent) {
    }

    public void taskFinished(BuildEvent buildEvent) {
        this.setValue(this.getValue() + 1);
        ++this.total;
    }

    public void messageLogged(BuildEvent buildEvent) {
    }

    public int countTasks(Target target) {
        if (target == null) {
            return 0;
        }
        int n = this.doCountTasks(target);
        return n;
    }

    private int doCountTasks(Target target) {
        int n = this.doCountDependencies(target);
        int n2 = this.doTasks(target);
        return n + n2;
    }

    private int doCountDependencies(Target target) {
        if (target == null) {
            return 0;
        }
        int n = 0;
        Enumeration enumeration = target.getDependencies();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Project project = target.getProject();
            Hashtable hashtable = project.getTargets();
            Target target2 = (Target)hashtable.get(e.toString());
            int n2 = this.doCountTasks(target2);
            n += n2;
        }
        return n;
    }

    private int doTasks(Target target) {
        if (target == null) {
            return 0;
        }
        int n = 0;
        Task[] taskArray = target.getTasks();
        for (int i = 0; i < taskArray.length; ++i) {
            Object object;
            Object object2;
            String string;
            String string2;
            Object object3;
            Task task = taskArray[i];
            String string3 = task.getTaskName();
            Hashtable hashtable = null;
            RuntimeConfigurable runtimeConfigurable = task.getRuntimeConfigurableWrapper();
            try {
                hashtable = AntUtils.getAntVersion() >= 1.6 ? (Hashtable)PrivilegedAccessor.getValue(runtimeConfigurable, "getAttributeMap") : this.makeMap((AttributeList)PrivilegedAccessor.getValue(runtimeConfigurable, "getAttributes"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (task instanceof TaskContainer) {
                if (hashtable == null) continue;
                n += hashtable.size();
                continue;
            }
            if (string3.equals("antcall") || string3.equals("call")) {
                if (hashtable == null) continue;
                object3 = hashtable.keySet().iterator();
                while (object3.hasNext()) {
                    string2 = (String)object3.next();
                    string = (String)hashtable.get(string2);
                    if (!string2.equals("target")) continue;
                    object2 = target.getProject().getTargets();
                    object = (Target)((Hashtable)object2).get(string);
                    n += this.doCountTasks((Target)object);
                }
                continue;
            }
            if (string3.equals("ant")) {
                String string4;
                if (hashtable == null) continue;
                object3 = "build.xml";
                string2 = "";
                string = "";
                object2 = hashtable.keySet().iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    string4 = (String)hashtable.get(object);
                    if (((String)object).equals("antfile")) {
                        object3 = string4;
                    }
                    if (((String)object).equals("dir")) {
                        string2 = string4;
                    }
                    if (!((String)object).equals("target")) continue;
                    string = string4;
                }
                object = string2.equals("") ? new File(target.getProject().getBaseDir(), (String)object3) : new File(string2, (String)object3);
                string4 = this.createProject((File)object, target.getProject().getProperties());
                if (string4 == null) continue;
                if (string.equals("")) {
                    string = string4.getDefaultTarget();
                }
                Hashtable hashtable2 = string4.getTargets();
                Target target2 = (Target)hashtable2.get(string);
                n += this.doCountTasks(target2);
                continue;
            }
            n += this.countSubTasks(target, runtimeConfigurable);
            ++n;
        }
        return n;
    }

    private int countSubTasks(Target target, RuntimeConfigurable runtimeConfigurable) {
        int n = 0;
        try {
            Cloneable cloneable;
            Enumeration enumeration = null;
            if (AntUtils.getAntVersion() == 1.5) {
                cloneable = (Vector)PrivilegedAccessor.getValue(runtimeConfigurable, "children");
                enumeration = ((Vector)cloneable).elements();
            } else {
                enumeration = (Enumeration)PrivilegedAccessor.invokeMethod((Object)runtimeConfigurable, "getChildren", null);
            }
            if (enumeration == null) {
                return 0;
            }
            cloneable = target.getProject().getTaskDefinitions();
            while (enumeration.hasMoreElements()) {
                RuntimeConfigurable runtimeConfigurable2 = (RuntimeConfigurable)enumeration.nextElement();
                String string = runtimeConfigurable2.getElementTag();
                if (!((Hashtable)cloneable).containsKey(string)) continue;
                ++n;
                n += this.countSubTasks(target, runtimeConfigurable2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    private Project createProject(File file, Hashtable hashtable) {
        Project project = (Project)this.project_cache.get(file);
        if (project == null) {
            project = new Project();
            this.project_cache.put(file, project);
            try {
                project.init();
                ProjectHelper projectHelper = ProjectHelper.getProjectHelper();
                projectHelper.parse(project, (Object)file);
                project.setUserProperty("ant.file", file.getAbsolutePath());
                if (hashtable == null) {
                    return project;
                }
                Iterator iterator = hashtable.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    project.setUserProperty((String)k, (String)hashtable.get(k));
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return project;
    }

    private Hashtable makeMap(AttributeList attributeList) {
        if (attributeList == null) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < attributeList.getLength(); ++i) {
            hashtable.put(attributeList.getName(i), attributeList.getValue(i));
        }
        return hashtable;
    }
}

