/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.common;

import ise.antelope.common.Constants;
import ise.library.Os;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.Main;

public class AntUtils {
    private static double ant_version = 0.0;

    public static double getAntVersion() {
        if (ant_version > 0.0) {
            return ant_version;
        }
        String string = Main.getAntVersion();
        Pattern pattern = Pattern.compile("\\d+[.]\\d+[.]\\d+");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            int n = matcher.start();
            int n2 = matcher.end();
            string = string.substring(n, n2 - n);
            String[] stringArray = string.split("[.]");
            string = stringArray[0] + "." + stringArray[1] + stringArray[2];
            ant_version = Float.parseFloat(string);
            return ant_version;
        }
        if (string.indexOf("1.7") > -1) {
            return 1.7;
        }
        if (string.indexOf("1.6") > -1) {
            return 1.6;
        }
        if (string.indexOf("1.5") > -1) {
            return 1.5;
        }
        if (string.indexOf("1.4") > -1) {
            return 1.4;
        }
        return 1.5;
    }

    public static String getAntHome() {
        String string = null;
        try {
            File file;
            string = Constants.PREFS.get("ANT_HOME", null);
            if (string != null && (file = new File(string)).exists()) {
                return string;
            }
            string = System.getProperty("ANT_HOME");
            if (string != null && (file = new File(string)).exists()) {
                Constants.PREFS.put("ANT_HOME", string);
                return string;
            }
            string = Os.getEnvironmentValue("ANT_HOME");
            if (string != null && (file = new File(string)).exists()) {
                Constants.PREFS.put("ANT_HOME", string);
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static String getAntLibDirs() {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        File file = new File(AntUtils.getAntHome(), "lib");
        if (file.exists() && file.isDirectory() && (stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".jar");
            }
        })).length > 0) {
            stringBuffer.append(file.getAbsolutePath());
        }
        if ((file = new File(System.getProperty("user.home") + ".ant", "lib")).exists() && file.isDirectory() && (stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".jar");
            }
        })).length > 0) {
            stringBuffer.append(File.pathSeparator).append(file.getAbsolutePath());
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }
}

