/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.common;

import ise.antelope.common.AntelopePanel;
import ise.antelope.common.Constants;
import ise.library.GUIUtils;
import ise.library.KappaLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;

public class AntelopeProperties {
    private AntelopePanel _parent;
    private HashMap _property_tfs;
    private File _build_file;
    private final String PROPS = "Properties";
    private final String REFS = "References";
    private final String USER = "User";
    private final String DESC = "Description";
    private final String ABOUT = "About";
    private final String ANTHOME = "Ant Home";
    private String lSep = System.getProperty("line.separator");
    private String antelopeVersion = null;
    private JButton _new_btn = null;

    public AntelopeProperties(AntelopePanel antelopePanel) {
        this._parent = antelopePanel;
    }

    public void showProperties(Project project) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        TreeMap treeMap = new TreeMap(project.getProperties());
        JTable jTable = new JTable();
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{"Name", "Value"}, treeMap.size());
        jTable.setModel(defaultTableModel);
        Iterator iterator = treeMap.keySet().iterator();
        for (int i = 0; i < treeMap.size(); ++i) {
            try {
                String string = (String)iterator.next();
                object5 = (String)treeMap.get(string);
                defaultTableModel.setValueAt(string, i, 0);
                defaultTableModel.setValueAt(object5, i, 1);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        jTable.addMouseListener(new TableCellViewer(jTable));
        treeMap = new TreeMap(project.getReferences());
        JTable jTable2 = new JTable();
        defaultTableModel = new DefaultTableModel(new String[]{"Name", "Value"}, treeMap.size());
        jTable2.setModel(defaultTableModel);
        iterator = treeMap.keySet().iterator();
        for (int i = 0; i < treeMap.size(); ++i) {
            try {
                object5 = iterator.next().toString();
                object4 = treeMap.get(object5).toString();
                defaultTableModel.setValueAt(object5, i, 0);
                defaultTableModel.setValueAt(object4, i, 1);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        jTable2.addMouseListener(new TableCellViewer(jTable2));
        Hashtable hashtable = project.getUserProperties();
        treeMap = new TreeMap(hashtable);
        object5 = new JTable();
        object4 = new DefaultTableModel(new String[]{"Name", "Value"}, treeMap.size());
        ((JTable)object5).setModel((TableModel)object4);
        iterator = treeMap.keySet().iterator();
        for (int i = 0; i < treeMap.size(); ++i) {
            try {
                object3 = iterator.next().toString();
                object2 = treeMap.get(object3).toString();
                ((DefaultTableModel)object4).setValueAt(object3, i, 0);
                ((DefaultTableModel)object4).setValueAt(object2, i, 1);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ((Component)object5).addMouseListener(new TableCellViewer((JTable)object5));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getProjectDescription(project)).append(this.lSep);
        stringBuffer.append(this.printTargets(project, true));
        object3 = new JEditorPane("text/html", "<html><pre>" + stringBuffer.toString());
        ((JComponent)object3).setBackground(Color.white);
        ((JTextComponent)object3).setCaretPosition(0);
        ((JComponent)object3).scrollRectToVisible(new Rectangle(0, 0, 0, 0));
        ((JTextComponent)object3).setEditable(false);
        object2 = new JEditorPane();
        try {
            object = this.getClass().getClassLoader().getResource("about.html");
            ((JEditorPane)object2).setPage((URL)object);
        }
        catch (IOException iOException) {
            ((JEditorPane)object2).setContentType("text/html");
            ((JEditorPane)object2).setText(this.getAntelopeVersion());
        }
        ((JComponent)object2).setBackground(Color.white);
        ((JTextComponent)object2).setEditable(false);
        object = project.getName();
        if (object == null) {
            object = project.getProperty("ant.project.name");
        }
        object = object == null ? "Ant Properties" : "Ant Properties: " + (String)object;
        final JDialog jDialog = new JDialog(GUIUtils.getRootJFrame(this._parent), (String)object, false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                if (n < 0 || AntelopeProperties.this._new_btn == null) {
                    return;
                }
                AntelopeProperties.this._new_btn.setEnabled("User".equals(jTabbedPane.getTitleAt(n)));
            }
        });
        jPanel.add((Component)jTabbedPane, "Center");
        jTabbedPane.add("Properties", new JScrollPane(jTable));
        jTabbedPane.add("References", new JScrollPane(jTable2));
        jTabbedPane.add("User", new JScrollPane((Component)object5));
        jTabbedPane.add("Description", new JScrollPane((Component)object3));
        jTabbedPane.add("About", new JScrollPane((Component)object2));
        KappaLayout kappaLayout = new KappaLayout();
        JPanel jPanel2 = new JPanel(kappaLayout);
        jPanel2.setBorder(new EmptyBorder(11, 0, 0, 0));
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener((DefaultTableModel)object4, project, jDialog){
            private final /* synthetic */ DefaultTableModel val$user_model;
            private final /* synthetic */ Project val$project;
            private final /* synthetic */ JDialog val$dialog;
            {
                this.val$user_model = defaultTableModel;
                this.val$project = project;
                this.val$dialog = jDialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences preferences = AntelopeProperties.this._parent.getPrefs().node("ant_user_props");
                for (int i = 0; i < this.val$user_model.getRowCount(); ++i) {
                    String string = (String)this.val$user_model.getValueAt(i, 0);
                    String string2 = (String)this.val$user_model.getValueAt(i, 1);
                    this.val$project.setUserProperty(string, string2);
                    if (string2 == null || string2.equals("")) {
                        preferences.remove(string);
                        continue;
                    }
                    preferences.put(string, string2);
                }
                AntelopeProperties.this._parent.reload();
                this.val$dialog.hide();
                this.val$dialog.dispose();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.hide();
                jDialog.dispose();
            }
        });
        this._new_btn = new JButton("New");
        this._new_btn.setEnabled(false);
        this._new_btn.addActionListener(new ActionListener((DefaultTableModel)object4){
            private final /* synthetic */ DefaultTableModel val$user_model;
            {
                this.val$user_model = defaultTableModel;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.val$user_model.addRow(new String[]{"", ""});
            }
        });
        jPanel2.add((Component)jButton, "0, 0, 1, 1, 0, w, 3");
        jPanel2.add((Component)jButton2, "1, 0, 1, 1, 0, w, 3");
        jPanel2.add((Component)this._new_btn, "2, 0, 1, 1, 0, w, 3");
        kappaLayout.makeColumnsSameWidth(new int[]{0, 1, 2});
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel2);
        jPanel.add((Component)jPanel3, "South");
        jDialog.setContentPane(jPanel);
        jDialog.pack();
        SwingUtilities.getRootPane(jButton).setDefaultButton(jButton);
        Dimension dimension = jDialog.getSize();
        jDialog.setSize(dimension.width, Math.min(400, dimension.height));
        GUIUtils.centerOnScreen(jDialog);
        jDialog.setVisible(true);
    }

    public String getAntelopeVersion() throws BuildException {
        if (this.antelopeVersion == null) {
            try {
                Properties properties = new Properties();
                InputStream inputStream = this.getClass().getResourceAsStream("/ise/antelope/common/version.txt");
                properties.load(inputStream);
                inputStream.close();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Antelope Version: ");
                stringBuffer.append(properties.getProperty("VERSION"));
                stringBuffer.append(", compiled on ");
                stringBuffer.append(properties.getProperty("DATE"));
                this.antelopeVersion = stringBuffer.toString();
            }
            catch (Exception exception) {
                this.antelopeVersion = "3.x.x";
            }
        }
        return this.antelopeVersion;
    }

    private String getProjectDescription(Project project) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Main.getAntVersion().trim() + this.lSep;
        stringBuffer.append(string == null ? "" : "Ant Version: " + string + this.lSep);
        String string2 = Constants.PREFS.get("ANT_HOME", null);
        if (string2 != null) {
            stringBuffer.append("Ant Home: " + string2 + this.lSep + this.lSep);
        }
        stringBuffer.append(this.getAntelopeVersion() + this.lSep + this.lSep);
        stringBuffer.append(project.getDescription() == null ? "" : "Project Description: " + this.lSep + " " + project.getDescription() + this.lSep);
        return stringBuffer.toString();
    }

    private String printTargets(Project project, boolean bl) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Enumeration enumeration = project.getTargets().elements();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            int n2;
            Target target = (Target)enumeration.nextElement();
            String string2 = target.getName();
            String string3 = target.getDescription();
            if (string3 == null) {
                n2 = AntelopeProperties.findTargetPosition(vector3, string2);
                vector3.insertElementAt(string2, n2);
                continue;
            }
            n2 = AntelopeProperties.findTargetPosition(vector, string2);
            vector.insertElementAt(string2, n2);
            vector2.insertElementAt(string3, n2);
            if (string2.length() <= n) continue;
            n = string2.length();
        }
        stringBuffer.append(this.printTargets(project, vector, vector2, "Main targets:", n)).append(this.lSep);
        if (vector.size() == 0) {
            bl = true;
        }
        if (bl) {
            stringBuffer.append(this.printTargets(project, vector3, null, "Subtargets:", 0)).append(this.lSep);
        }
        if ((string = project.getDefaultTarget()) != null && !"".equals(string)) {
            stringBuffer.append("Default target: ").append(string).append(this.lSep);
        }
        return stringBuffer.toString();
    }

    private String printTargets(Project project, Vector vector, Vector vector2, String string, int n) {
        String string2 = "    ";
        while (string2.length() < n) {
            string2 = string2 + string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + this.lSep + this.lSep);
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(vector.elementAt(i));
            if (vector2 != null) {
                stringBuffer.append(string2.substring(0, n - ((String)vector.elementAt(i)).length() + 2));
                stringBuffer.append(vector2.elementAt(i));
            }
            stringBuffer.append(this.lSep);
        }
        return stringBuffer.toString();
    }

    private static int findTargetPosition(Vector vector, String string) {
        int n = vector.size();
        for (int i = 0; i < vector.size() && n == vector.size(); ++i) {
            if (string.compareTo((String)vector.elementAt(i)) >= 0) continue;
            n = i;
        }
        return n;
    }

    public class TableCellViewer
    extends MouseAdapter {
        private JTable table = null;
        private JTextArea ta;
        private JPopupMenu pm;

        public TableCellViewer(JTable jTable) {
            this.table = jTable;
            this.ta = new JTextArea(10, 40);
            this.ta.setLineWrap(true);
            this.ta.setEditable(false);
            this.pm = new JPopupMenu();
            this.pm.add(new JScrollPane(this.ta));
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        private void doPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                Point point = mouseEvent.getPoint();
                int n = this.table.columnAtPoint(point);
                int n2 = this.table.rowAtPoint(point);
                Object object = this.table.getModel().getValueAt(n2, n);
                if (object != null) {
                    this.ta.setText(object.toString());
                    GUIUtils.showPopupMenu(this.pm, this.table, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }
}

