/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.common;

import ise.antelope.common.AntUtils;
import ise.library.PrivilegedAccessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.xml.sax.AttributeList;

public class TraceTarget {
    private static final String NL = System.getProperty("line.separator");
    private List unknown_properties = new ArrayList();

    public String traceTarget(Target target) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Tracing target: " + target.getName()).append(NL);
        stringBuffer.append("Legend: <target>[task]").append(NL).append(NL);
        stringBuffer.append("<" + target.getName() + ">").append(NL);
        Target target2 = this.getImplicitTarget(target);
        if (target2 != null) {
            stringBuffer.append(this.doTrace(target2));
        }
        stringBuffer.append(this.doTrace(target));
        stringBuffer.append("</" + target.getName() + ">").append(NL).append(NL);
        stringBuffer.append("Done tracing target: " + target.getName()).append(NL).append(NL);
        return stringBuffer.toString();
    }

    private String doTrace(Target target) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.doDependencies(target));
        stringBuffer.append(this.doTasks(target));
        return stringBuffer.toString();
    }

    private String doDependencies(Target target) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = target.getDependencies();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Project project = target.getProject();
            Hashtable hashtable = project.getTargets();
            Target target2 = (Target)hashtable.get(e.toString());
            stringBuffer.append(this.doTrace(target2));
        }
        return stringBuffer.toString();
    }

    private String doTasks(Target target) {
        StringBuffer stringBuffer = new StringBuffer();
        Task[] taskArray = target.getTasks();
        block2: for (int i = 0; i < taskArray.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            String string;
            String string2;
            Object object4;
            Task task = taskArray[i];
            String string3 = task.getTaskName();
            Hashtable hashtable = null;
            RuntimeConfigurable runtimeConfigurable = task.getRuntimeConfigurableWrapper();
            try {
                hashtable = AntUtils.getAntVersion() >= 1.6 ? runtimeConfigurable.getAttributeMap() : this.makeMap((AttributeList)PrivilegedAccessor.invokeMethod((Object)runtimeConfigurable, "getAttributes", null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            if (string3.equals("antcall")) {
                if (hashtable == null) continue;
                object4 = hashtable.keySet().iterator();
                while (object4.hasNext()) {
                    string2 = (String)object4.next();
                    string = (String)hashtable.get(string2);
                    if (!string2.equals("target")) continue;
                    object3 = target.getProject();
                    if (object3 == null) continue block2;
                    object2 = object3.getTargets();
                    object = (Target)((Hashtable)object2).get(string);
                    if (object == null) {
                        stringBuffer.append("Error: <antcall> calling non-existant target ").append(string).append(NL);
                        continue;
                    }
                    stringBuffer.append("<").append(target.getName()).append(">");
                    stringBuffer.append("[").append(string3).append(" target=");
                    stringBuffer.append(this.quote(object.toString())).append("]").append(NL);
                    stringBuffer.append(this.doTrace((Target)object));
                }
                continue;
            }
            if (string3.equals("ant")) {
                object4 = "build.xml";
                string2 = "";
                string = "";
                if (hashtable != null) {
                    object3 = hashtable.keySet().iterator();
                    while (object3.hasNext()) {
                        object2 = (String)object3.next();
                        object = (String)hashtable.get(object2);
                        if (((String)object2).equals("antfile")) {
                            object4 = object;
                        }
                        if (((String)object2).equals("dir")) {
                            string2 = object;
                        }
                        if (!((String)object2).equals("target")) continue;
                        string = object;
                    }
                }
                stringBuffer.append("<").append(target.getName()).append(">");
                stringBuffer.append("[").append(string3).append(" antfile=").append(this.quote((String)object4));
                stringBuffer.append(" dir=").append(this.quote(string2));
                stringBuffer.append(", ").append("target=");
                stringBuffer.append(this.quote(string)).append("]").append(NL);
                object3 = string2.equals("") ? new File(target.getProject().getBaseDir(), (String)object4) : new File(string2, (String)object4);
                object2 = this.createProject((File)object3, target.getProject().getProperties());
                if (string.equals("")) {
                    string = object2.getDefaultTarget();
                }
                if (object2 == null) continue;
                object = object2.getTargets();
                Target target2 = (Target)((Hashtable)object).get(string);
                stringBuffer.append(this.doTrace(target2));
                continue;
            }
            if (string3.equals("property")) {
                object4 = "";
                string2 = "value";
                string = "";
                if (hashtable != null) {
                    object3 = hashtable.keySet().iterator();
                    while (object3.hasNext()) {
                        object2 = (String)object3.next();
                        object = (String)hashtable.get(object2);
                        if (((String)object2).equals("name")) {
                            object4 = object;
                        }
                        if (((String)object2).equals("value")) {
                            string2 = this.parseValue((String)object, target.getProject());
                            string = "value";
                        }
                        if (((String)object2).equals("location")) {
                            string2 = this.parseValue((String)object, target.getProject());
                            string = "location";
                        }
                        if (!((String)object2).equals("refid")) continue;
                        string2 = this.parseValue((String)object, target.getProject());
                        string = "refid";
                    }
                }
                target.getProject().setProperty((String)object4, string2);
                stringBuffer.append("<").append(target.getName()).append(">");
                stringBuffer.append("[").append(string3).append(" name=").append(this.quote((String)object4));
                stringBuffer.append(", ").append(string).append("=");
                stringBuffer.append(this.quote(string2)).append("]").append(NL);
                continue;
            }
            stringBuffer.append("<").append(target.getName()).append(">");
            stringBuffer.append("[").append(string3);
            if (hashtable != null) {
                object4 = hashtable.keySet().iterator();
                while (object4.hasNext()) {
                    string2 = (String)object4.next();
                    string = (String)hashtable.get(string2);
                    string = this.parseValue(string, target.getProject());
                    stringBuffer.append(" ").append(string2).append("=").append(this.quote(string));
                }
            }
            stringBuffer.append("]").append(NL);
        }
        return stringBuffer.toString();
    }

    private String quote(String string) {
        return "\"" + string + "\"";
    }

    private String parseValue(String string, Project project) {
        String string2;
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return string;
        }
        Hashtable hashtable = project.getProperties();
        Hashtable hashtable2 = project.getReferences();
        StringBuffer stringBuffer = new StringBuffer();
        Pattern pattern = Pattern.compile("\\$\\{.+?\\}", 32);
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        boolean bl = false;
        while (matcher.find()) {
            bl = true;
            string2 = matcher.group();
            stringBuffer.append(string.substring(n, matcher.start()));
            String string3 = this.trimCurly(string2);
            String string4 = (String)hashtable.get(string3);
            if (string4 == null) {
                string4 = string2;
                if (!this.unknown_properties.contains(string2)) {
                    this.unknown_properties.add(string2);
                }
            }
            stringBuffer.append(string4);
            n = matcher.end();
        }
        if (bl) {
            stringBuffer.append(string.substring(n));
        }
        if (!bl && (string2 = hashtable2.get(string)) != null) {
            bl = true;
            stringBuffer.append(string2.toString());
        }
        return bl ? stringBuffer.toString() : string;
    }

    private String trimCurly(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.startsWith("${")) {
            stringBuffer.deleteCharAt(0);
            stringBuffer.deleteCharAt(0);
        }
        if (string.endsWith("}")) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private Project createProject(File file, Hashtable hashtable) {
        Project project = new Project();
        try {
            project.init();
            ProjectHelper projectHelper = ProjectHelper.getProjectHelper();
            projectHelper.parse(project, (Object)file);
            project.setUserProperty("ant.file", file.getAbsolutePath());
            if (hashtable == null) {
                return project;
            }
            Iterator iterator = hashtable.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                project.setUserProperty((String)k, (String)hashtable.get(k));
            }
        }
        catch (Exception exception) {
            return null;
        }
        return project;
    }

    public List getUnknownProperties() {
        return this.unknown_properties;
    }

    private Target getImplicitTarget(Target target) {
        Project project = target.getProject();
        Hashtable hashtable = project.getTargets();
        return (Target)hashtable.get("");
    }

    private Document getDocument(File file) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            return document;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Hashtable makeMap(AttributeList attributeList) {
        if (attributeList == null) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < attributeList.getLength(); ++i) {
            hashtable.put(attributeList.getName(i), attributeList.getValue(i));
        }
        return hashtable;
    }
}

