/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class SuiteOriginal
extends Task {
    private Target setUp = null;
    private Target tearDown = null;
    private Vector testTargets = new Vector();
    private Vector failures = new Vector();
    private boolean showSummary = true;
    private boolean showOutput = true;
    private int tests_passed = 0;
    private int tests_failed = 0;

    public int getTestCaseCount() {
        return this.testTargets.size();
    }

    public int getRanCount() {
        return this.tests_passed + this.tests_failed;
    }

    public int getFailedCount() {
        return this.tests_failed;
    }

    public int getPassedCount() {
        return this.tests_passed;
    }

    public Enumeration getFailures() {
        return this.failures.elements();
    }

    public void setShowoutput(boolean bl) {
        this.showOutput = bl;
    }

    public void setShowsummary(boolean bl) {
        this.showSummary = bl;
    }

    public void execute() {
        Object object;
        CharSequence charSequence;
        Hashtable hashtable = this.getProject().getTargets();
        Enumeration<Object> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            charSequence = (String)enumeration.nextElement();
            if (((String)charSequence).equals("setUp")) {
                this.setUp = (Target)hashtable.get(charSequence);
                continue;
            }
            if (((String)charSequence).equals("tearDown")) {
                this.tearDown = (Target)hashtable.get(charSequence);
                continue;
            }
            if (((String)charSequence).startsWith("test")) {
                this.testTargets.addElement(hashtable.get(charSequence));
                continue;
            }
            if (((String)charSequence).lastIndexOf(".") <= 0 || !((String)charSequence).substring(((String)charSequence).lastIndexOf(".") + 1).startsWith("test")) continue;
            this.testTargets.addElement(hashtable.get(charSequence));
        }
        if (this.setUp != null) {
            this.setUp.execute();
        }
        enumeration = this.testTargets.elements();
        charSequence = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            object = (Target)enumeration.nextElement();
            try {
                this.executeDependencies((Target)object);
                object.performTasks();
                if (this.showOutput) {
                    this.log(object.getName() + " passed.");
                }
                ++this.tests_passed;
            }
            catch (Exception exception) {
                ++this.tests_failed;
                if (this.showOutput) {
                    this.log(object.getName() + " failed: " + exception.getMessage());
                }
                this.failures.addElement(object.getName() + " failed: " + exception.getMessage());
            }
        }
        if (this.tearDown != null) {
            this.tearDown.execute();
        }
        if (this.showSummary) {
            if (this.failures.size() > 0) {
                this.log("");
                this.log("---- Errors ---------------------------------");
                enumeration = this.failures.elements();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    this.log((String)object);
                }
            }
            this.log("");
            this.log("---- Results --------------------------------");
            this.log("Ran " + this.getRanCount() + " out of " + this.getTestCaseCount() + " tests.");
            this.log("Passed: " + this.getPassedCount());
            this.log("Failed: " + this.getFailedCount());
        }
    }

    private void executeDependencies(Target target) {
        if (target == null) {
            return;
        }
        Enumeration enumeration = target.getDependencies();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Target target2 = (Target)this.getProject().getTargets().get(string);
            this.executeDependencies(target2);
            target2.performTasks();
        }
    }
}

