/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.Break;
import ise.antelope.tasks.Case;
import ise.antelope.tasks.DefaultCase;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class SwitchTask
extends Task {
    private Vector cases = new Vector();
    private Case defaultCase = null;
    private String name = null;

    public void init() {
        this.getProject().addTaskDefinition("case", Case.class);
        this.getProject().addTaskDefinition("default", DefaultCase.class);
        this.getProject().addTaskDefinition("break", Break.class);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void addCase(Case case_) {
        this.cases.addElement(case_);
    }

    public void addDefault(DefaultCase defaultCase) {
        if (this.defaultCase == null) {
            this.defaultCase = defaultCase;
            return;
        }
        throw new BuildException("<switch> can have only one <default>");
    }

    public void execute() throws BuildException {
        if (this.name == null) {
            throw new BuildException("'name' attribute cannot be null.");
        }
        String string = this.getProject().getProperty(this.name);
        if (string == null) {
            throw new BuildException("Property " + this.name + " does not exist.");
        }
        boolean bl = false;
        Enumeration enumeration = this.cases.elements();
        while (enumeration.hasMoreElements()) {
            Case case_ = (Case)enumeration.nextElement();
            if (bl) {
                case_.perform();
                if (!case_.doBreak()) continue;
                return;
            }
            if (!string.equals(case_.getValue())) continue;
            case_.perform();
            if (case_.doBreak()) {
                return;
            }
            bl = true;
        }
        if (this.defaultCase != null) {
            this.defaultCase.perform();
        }
    }
}

